/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.rpac.rpacp.common.enums.DataStatusEnum;
import kd.rpac.rpacp.common.enums.LicStatusEnum;

public class RpacpClientPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static Log logger = LogFactory.getLog(RpacpClientPlugin.class);
    public static List<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>();
    private static final String ENTRYENTITY = "entryentity";
    private static final String CLIENTID = "clientid";
    private static final String AGENTALIAS = "agentalias";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loanClientDetail();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("ok".equals(afterDoOperationEventArgs.getOperateKey())) {
            int[] index = ((EntryGrid)this.getControl(ENTRYENTITY)).getSelectRows();
            if (ArrayUtils.isEmpty((int[])index)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761RPA\u5ba2\u6237\u7aef\u6570\u636e", (String)"RpacpClientPlugin_0", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put(CLIENTID, this.getModel().getValue(CLIENTID, index[0]));
            returnData.put(AGENTALIAS, this.getModel().getValue(AGENTALIAS, index[0]));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void loanClientDetail() {
        String procid = this.getView().getFormShowParameter().getCustomParam("procid").toString();
        List<Map<String, Object>> result = new ArrayList();
        try {
            result = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getRobotList", (Object[])new Object[]{procid});
        }
        catch (Exception ex) {
            logger.error("\u5fae\u670d\u52a1\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868\u5931\u8d25!" + ex.getMessage());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868\u5931\u8d25!%n%s", (String)"RpacpClientPlugin_1", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]), ex.getMessage()));
        }
        dataMap.clear();
        if (!CollectionUtils.isEmpty(result)) {
            for (Map map : result) {
                dataMap.add(map);
            }
            RpacpClientPlugin.batchFillEntity(ENTRYENTITY, (AbstractFormDataModel)this.getModel(), result);
            this.getView().updateView(ENTRYENTITY);
        } else {
            logger.info("RPA getRobotList result is null, procid " + procid);
        }
    }

    public static void batchFillEntity(String entryName, AbstractFormDataModel model, List<Map<String, Object>> data) {
        model.deleteEntryData(entryName);
        DynamicObject dataEntity = model.getDataEntity(true);
        EntryProp entryProp = (EntryProp)dataEntity.getDataEntityType().getProperties().get((Object)entryName);
        EntryType entryType = (EntryType)entryProp.getItemType();
        if (null != data && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                if (!data.get(i).get("licStatus").toString().equals("0")) continue;
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                model.createNewEntryRow(entryName, row);
                model.setValue(CLIENTID, data.get(i).get("id"), i);
                model.setValue(AGENTALIAS, data.get(i).get("agentAlias"), i);
                model.setValue("agentname", data.get(i).get("agentName"), i);
                model.setValue("curorgname", data.get(i).get("curOrgName"), i);
                model.setValue("status", (Object)DataStatusEnum.getMsgResult((String)data.get(i).get("dataStatus").toString()), i);
                model.setValue("licstatus", (Object)LicStatusEnum.getMsgResult((String)data.get(i).get("licStatus").toString()), i);
                model.setValue("agentos", data.get(i).get("agentOs"), i);
                model.setValue("agentno", data.get(i).get("agentNo"), i);
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Search search = (Search)searchEnterEvent.getSource();
        if (StringUtils.equals((CharSequence)"searchap", (CharSequence)search.getKey())) {
            String searchText = searchEnterEvent.getText();
            this.getEntryRows(searchText);
            this.getView().sendFormAction(this.getView());
        }
    }

    private void getEntryRows(String searchText) {
        if (dataMap.size() != 0) {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < dataMap.size(); ++i) {
                String agentAlias = dataMap.get(i).get("agentAlias").toString();
                String agentName = dataMap.get(i).get("agentName").toString();
                if (agentAlias.indexOf(searchText) == -1 && agentName.indexOf(searchText) == -1) continue;
                data.add(dataMap.get(i));
            }
            RpacpClientPlugin.batchFillEntity(ENTRYENTITY, (AbstractFormDataModel)this.getModel(), data);
        }
    }
}

