/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.rpac.rpacp.common.enums.WorkStatusEnum;

public class RpacpProcessPlugin
extends AbstractFormPlugin
implements SearchEnterListener {
    private static Log logger = LogFactory.getLog(RpacpProcessPlugin.class);
    public static List<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>();
    public static final String ENTRYENTITY = "entryentity";
    public static final String PROCNAME = "procname";
    public static final String PROCCODE = "proccode";
    public static final String PROCID = "procid";
    public static final String PROCVER = "procver";

    public void afterBindData(EventObject e) {
        this.loanProcessDetail();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("ok".equals(args.getOperateKey())) {
            int[] index = ((EntryGrid)this.getControl(ENTRYENTITY)).getSelectRows();
            if (index == null || index.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761RPA\u6d41\u7a0b\u6570\u636e", (String)"RpacpProcessPlugin_0", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.getModel().getValue("workstatus", index[0]).equals(WorkStatusEnum.RELEASE.getMsg())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u53d1\u5e03\u6d41\u7a0b\uff01", (String)"RpacpProcessPlugin_1", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put(PROCNAME, this.getModel().getValue(PROCNAME, index[0]));
            returnData.put(PROCCODE, this.getModel().getValue(PROCCODE, index[0]));
            returnData.put(PROCID, this.getModel().getValue(PROCID, index[0]));
            returnData.put(PROCVER, this.getModel().getValue(PROCVER, index[0]));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void loanProcessDetail() {
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        List<Map<String, Object>> result = new ArrayList();
        try {
            result = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)"rpacp", (String)"RpaService", (String)"getProcessList", (Object[])new Object[]{userId, null});
        }
        catch (Exception ex) {
            logger.error("\u5fae\u670d\u52a1\u83b7\u53d6\u6d41\u7a0b\u5217\u8868\u5931\u8d25!" + ex.getMessage());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u5217\u8868\u5931\u8d25!%n%s", (String)"RpacpProcessPlugin_2", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]), ex.getMessage()));
        }
        dataMap.clear();
        if (!CollectionUtils.isEmpty(result)) {
            for (Map map : result) {
                dataMap.add(map);
            }
            this.batchFillEntity(ENTRYENTITY, (AbstractFormDataModel)this.getModel(), result);
            this.getView().updateView(ENTRYENTITY);
        } else {
            logger.info("\u83b7\u53d6RPA\u6d41\u7a0b\u5217\u8868\u4e3a\u7a7a\uff0cuserid\u4e3a\uff1a" + RequestContext.get().getCurrUserId());
        }
    }

    private void batchFillEntity(String entryName, AbstractFormDataModel model, List<Map<String, Object>> data) {
        model.deleteEntryData(entryName);
        DynamicObject dataEntity = model.getDataEntity(true);
        EntryProp entryProp = (EntryProp)dataEntity.getDataEntityType().getProperties().get((Object)entryName);
        EntryType entryType = (EntryType)entryProp.getItemType();
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
                model.createNewEntryRow(entryName, row);
                model.setValue(PROCID, data.get(i).get("id"), i);
                model.setValue(PROCCODE, data.get(i).get("procCode"), i);
                model.setValue(PROCNAME, data.get(i).get("procName"), i);
                model.setValue("workstatus", (Object)WorkStatusEnum.getMsgResult((String)data.get(i).get("workStatus").toString()), i);
                model.setValue(PROCVER, data.get(i).get("procVer"), i);
                model.setValue("curorgname", data.get(i).get("curOrgName"), i);
                model.setValue("procdesc", data.get(i).get("procDesc"), i);
                model.setValue("createtime", data.get(i).get("createTime"), i);
                model.setValue("developeruser", data.get(i).get("developerUser"), i);
            }
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        Search search = (Search)searchEnterEvent.getSource();
        if (StringUtils.equals((CharSequence)"searchap", (CharSequence)search.getKey())) {
            String searchText = searchEnterEvent.getText();
            this.getEntryRows(searchText);
            this.getView().sendFormAction(this.getView());
        }
    }

    private void getEntryRows(String searchText) {
        if (dataMap.size() != 0) {
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < dataMap.size(); ++i) {
                String procname = dataMap.get(i).get("procName").toString();
                if (procname.indexOf(searchText) == -1) continue;
                data.add(dataMap.get(i));
            }
            this.batchFillEntity(ENTRYENTITY, (AbstractFormDataModel)this.getModel(), data);
        }
    }
}

