/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.openapi.thirdapp.ThirdAppDto;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterWriter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.AESUtils;
import kd.rpac.rpacp.common.CommonConstant;
import kd.rpac.rpacp.common.RpaResponse;
import kd.rpac.rpacp.common.enums.ErrorCodeEnum;
import kd.rpac.rpacp.common.exceptions.RpaException;
import kd.rpac.rpacp.common.helpers.RSAHelper;
import org.apache.commons.lang3.StringUtils;

public class RpacpSystemParam
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener {
    private static final String KEY_INITBTN = "init";
    private static final String KEY_DEINITBTN = "deinit";
    private static final String KEY_SAVEBTN = "save";
    private static final String FILED_URL = "url";
    private static final String ISRPA_KEY = "isrpakey";
    private static final Log logger = LogFactory.getLog(RpacpSystemParam.class);

    public void registerListener(EventObject e) {
        Control deinitControl;
        super.registerListener(e);
        Control control = this.getView().getControl(KEY_INITBTN);
        if (control != null) {
            ((Button)control).addClickListener((ClickListener)this);
        }
        if ((deinitControl = this.getView().getControl(KEY_DEINITBTN)) != null) {
            ((Button)deinitControl).addClickListener((ClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.validInit();
    }

    private void validInit() {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"rpacp");
        AppParam apm = new AppParam();
        apm.setAppId(appInfo.getId());
        apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        logger.info("\u6839orgid:" + OrgUnitServiceHelper.getRootOrgId());
        Map rpaSysParameter = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm);
        logger.info("\u83b7\u53d6\u5230\u7684rpa\u7cfb\u7edf\u53c2\u6570\uff1a" + JSON.toJSONString((Object)rpaSysParameter));
        if (rpaSysParameter == null || rpaSysParameter.size() < 1 || ObjectUtils.isEmpty(rpaSysParameter.get("appid")) || ObjectUtils.isEmpty(rpaSysParameter.get("appsecret"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_DEINITBTN});
            this.getView().setEnable(Boolean.TRUE, new String[]{FILED_URL});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_INITBTN});
        }
        if (rpaSysParameter != null && rpaSysParameter.size() > 0) {
            Object urlObj = rpaSysParameter.get(FILED_URL);
            Object appidObj = rpaSysParameter.get("appid");
            Object appsecretObj = rpaSysParameter.get("appsecret");
            if (!(ObjectUtils.isEmpty(urlObj) || ObjectUtils.isEmpty(appidObj) || ObjectUtils.isEmpty(appsecretObj))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{FILED_URL});
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_INITBTN});
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_DEINITBTN});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "init": {
                this.initRpaSystem();
                break;
            }
            case "deinit": {
                this.confirm();
            }
        }
    }

    private void confirm() {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_DEINITBTN, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u53cd\u521d\u59cb\u5316\u540e\u7528\u6237\u5c06\u65e0\u6cd5\u4f7f\u7528RPA\u670d\u52a1\u4e91\u76f8\u5173\u5e94\u7528\uff0c\u662f\u5426\u786e\u5b9a\u53cd\u521d\u59cb\u5316\uff1f", (String)"RpacpSystemParam_0", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)KEY_DEINITBTN, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().getModel().setValue(FILED_URL, (Object)"");
            this.getView().getModel().setValue("appid", (Object)"");
            this.getView().getModel().setValue("appsecret", (Object)"");
            this.getView().updateView(FILED_URL);
            this.getView().updateView("appid");
            this.getView().updateView("appsecret");
            this.saveSysParam();
            this.disableOpenThirdAppAndClearLink();
            this.getView().setEnable(Boolean.TRUE, new String[]{FILED_URL});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_INITBTN});
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_DEINITBTN});
        }
    }

    private void disableOpenThirdAppAndClearLink() {
        ThirdAppDto thirdAppDto = new ThirdAppDto();
        thirdAppDto.setNumber("CosmicRPA");
        List appDtoList = (List)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)"ThirdAppService", (String)"findThirdApp", (Object[])new Object[]{thirdAppDto});
        for (ThirdAppDto thirdapp : appDtoList) {
            thirdapp.setEnable(false);
            thirdapp.setModifier(Long.valueOf(RequestContext.get().getCurrUserId()));
            thirdapp.setModifytime(new Timestamp(new Date().getTime()));
            thirdapp.setHasRight(true);
            DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)"ThirdAppService", (String)"updateThirdAppEnable", (Object[])new Object[]{thirdapp});
        }
        DeleteServiceHelper.delete((String)"isc_database_link", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CosmicRPA_link")});
    }

    private void initRpaSystem() {
        Object url = this.getView().getModel().getValue(FILED_URL);
        logger.info("url:::" + url);
        if (url == null || StringUtils.isEmpty((CharSequence)url.toString().trim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u597dRPA\u5730\u5740\u540e\u518d\u521d\u59cb\u5316", (String)"RpacpSystemParam_1", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
            return;
        }
        String urlStr = url.toString();
        if (urlStr.length() > 200) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"RPA\u5730\u5740\u4e0d\u5141\u8bb8\u8d85\u8fc7200\u4e2a\u5b57\u7b26", (String)"RpacpSystemParam_2", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] rpacpParmas = BusinessDataServiceHelper.load((String)"rpacp_params", (String)"isrpapublickey", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)"01")});
        if (rpacpParmas.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RpacpSystemParam_3", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
            return;
        }
        if ((urlStr = urlStr.trim()).endsWith("/")) {
            logger.info("\u7528\u6237\u8f93\u5165\u5e26/\u7684\u540e\u7f00\u3002\u3002\u3002");
            int length = urlStr.length();
            urlStr = urlStr.substring(0, length - 1).trim();
        }
        if (!url.toString().equals(urlStr)) {
            url = urlStr;
            this.getView().getModel().setValue(FILED_URL, url);
            this.getView().updateView(FILED_URL);
        }
        try {
            Map<String, String> map = this.saveOpenThirdApps();
            if (map == null || map.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RpacpSystemParam_3", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
                return;
            }
            long t = 0L;
            long e = 0L;
            t = System.currentTimeMillis();
            logger.info("\u83b7\u53d6\u952e\u503c\u5bf9\u524d\u7cfb\u7edf\u65f6\u95f4\uff1a" + t);
            Map keyMap = RSAHelper.getKeyPair();
            e = System.currentTimeMillis();
            logger.info("\u83b7\u53d6\u540e\u65f6\u95f4\uff1a" + e + " \u6d88\u8017\u65f6\u95f4\uff1a" + (e - t));
            String publicKey = (String)keyMap.get("publicKey");
            String privateKey = (String)keyMap.get("privateKey");
            String clientFullContextPath = RequestContext.get().getClientFullContextPath();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("publicKey", publicKey);
            paramMap.put("kdBaseUrl", !StringUtils.isEmpty((CharSequence)clientFullContextPath) && clientFullContextPath.endsWith("/") ? clientFullContextPath.substring(0, clientFullContextPath.length() - 1) : clientFullContextPath);
            paramMap.put("appId", map.get("appId"));
            paramMap.put("appSecret", map.get("syspwd"));
            paramMap.put("symmetricKey", map.get("symmetricKey"));
            String userId = String.valueOf(RequestContext.get().getCurrUserId());
            logger.info("\u7528\u6237id\uff1a" + userId);
            ORM orm = ORM.create();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(userId))};
            DynamicObject userInfoObj = orm.queryOne("bos_user", "id,username,phone,email", qFilters);
            if (userInfoObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"RpacpSystemParam_4", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> userMap = new HashMap<String, Object>();
            userMap.put("username", userInfoObj.get("username"));
            userMap.put("phone", userInfoObj.get("phone"));
            userMap.put("email", userInfoObj.get("email"));
            paramMap.put("userInfo", userMap);
            Account account = AccountUtils.getCorrectAccount((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getTenantId());
            String accountId = account.getAccountId();
            paramMap.put("accountId", accountId);
            String key = rpacpParmas[0].get("isrpapublickey").toString();
            String encryptRes = RSAHelper.encipher((String)JSON.toJSONString(paramMap), (String)key);
            logger.info("result:" + encryptRes);
            if (StringUtils.isEmpty((CharSequence)encryptRes)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"RpacpSystemParam_3", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("encryptRes", encryptRes);
            this.initCosmic(url.toString());
            logger.info("\u8c03\u96c6\u6210\u4e91\u521d\u59cb\u5316api\uff01");
            HashMap resultmap = (HashMap)DispatchServiceHelper.invokeExternalService((String)"rpac", (String)"KD_RPAC_init", params);
            logger.info("\u8c03\u96c6\u6210\u4e91\u521d\u59cb\u5316api\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)resultmap));
            RpaResponse response = new RpaResponse();
            response.setCode(Integer.decode(resultmap.get("code").toString()));
            response.setMsg(resultmap.get("msg").toString());
            response.setResult(resultmap.get("result"));
            if (response.getCode() != 0) {
                String sMessage = "";
                sMessage = response != null && response.getCode() != 0 && !StringUtils.isEmpty((CharSequence)response.getMsg()) ? response.getMsg() : ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4RPA\u5730\u5740\u662f\u5426\u6b63\u786e\u540e\u91cd\u8bd5\u3002", (String)"RpacpSystemParam_8", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]);
                sMessage = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c%s", (String)"RpacpSystemParam_13", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]), sMessage);
                logger.error(sMessage);
                this.getView().showTipNotification(sMessage);
                return;
            }
            logger.info("\u89e3\u5bc6\u5b57\u7b26\u4e32\uff1a" + response.getResult());
            String decipher = RSAHelper.decipher((String)response.getResult().toString(), (String)privateKey);
            logger.info("\u89e3\u5bc6\u7ed3\u679c\uff1a" + decipher);
            JSONObject jsonObject = JSONObject.parseObject((String)decipher);
            this.getView().getModel().setValue("appid", jsonObject.get((Object)"appId"));
            this.getView().getModel().setValue("appsecret", jsonObject.get((Object)"appSecret"));
            this.saveSysParam();
            this.updateLink(jsonObject.get((Object)"appId").toString(), jsonObject.get((Object)"appSecret").toString());
            this.getView().setEnable(Boolean.FALSE, new String[]{FILED_URL});
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_INITBTN});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_DEINITBTN});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f", (String)"RpacpSystemParam_5", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u5931\u8d25\uff0c", (Throwable)e);
            String sMessage = e.getMessage();
            if (sMessage == null) {
                sMessage = e.toString();
            }
            sMessage = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"RpacpSystemParam_14", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]), sMessage);
            this.getView().showTipNotification(sMessage);
            return;
        }
    }

    private Map<String, String> saveOpenThirdApps() throws Exception {
        try {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            String symmetricKey = AESUtils.getBase64EncodeKey();
            String syspwd = EncryptUtil.generatePwCode();
            resultMap.put("appId", "CosmicRPA");
            resultMap.put("symmetricKey", symmetricKey);
            resultMap.put("syspwd", syspwd);
            ThirdAppDto thirdAppDto = new ThirdAppDto();
            thirdAppDto.setNumber("CosmicRPA");
            List appDtoList = (List)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)"ThirdAppService", (String)"findThirdApp", (Object[])new Object[]{thirdAppDto});
            if (appDtoList.size() > 0) {
                thirdAppDto = (ThirdAppDto)appDtoList.get(0);
                thirdAppDto.setAccessToken(syspwd);
                thirdAppDto.setDigestSignKey(symmetricKey);
                thirdAppDto.setModifier(Long.valueOf(RequestContext.get().getCurrUserId()));
                thirdAppDto.setModifytime(new Timestamp(new Date().getTime()));
                thirdAppDto.setEnable(true);
                thirdAppDto.setSense(2);
            } else {
                thirdAppDto.setName(CommonConstant.GET_ISRPA_APP_NAME());
                thirdAppDto.setBasicAuthEnable(false);
                thirdAppDto.setSignAuthEnable(false);
                thirdAppDto.setJwtAuthEnable(false);
                thirdAppDto.setAccessToken(syspwd);
                thirdAppDto.setDigestAuthEnable(true);
                thirdAppDto.setDigestSignType(Long.valueOf(1L));
                thirdAppDto.setDigestSignKey(symmetricKey);
                thirdAppDto.setAllowip(true);
                thirdAppDto.setAllowallapi(true);
                thirdAppDto.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
                thirdAppDto.setCreateTime(new Timestamp(new Date().getTime()));
                thirdAppDto.setStatus(BillStatus.C.toString());
                thirdAppDto.setEnable(true);
                thirdAppDto.setSense(1);
            }
            thirdAppDto.setHasRight(true);
            boolean bResult = (Boolean)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)"ThirdAppService", (String)"saveThirdApp", (Object[])new Object[]{thirdAppDto});
            if (bResult) {
                return resultMap;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u5e73\u53f0\u63a5\u53e3\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u4fe1\u606f\u5931\u8d25\u3002", (String)"RpacpSystemParam_16", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            throw ex;
        }
    }

    private void saveSysParam() {
        IDataModel parameterModel = (IDataModel)this.getView().getService(IDataModel.class);
        DynamicObject dataEntity = parameterModel.getDataEntity();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        String jsonString = jser.serializeToString((Object)dataEntity, null);
        IParameterModel model = (IParameterModel)parameterModel;
        long acctBookId = model.getAcctBookId();
        ParameterWriter.saveSystemParameter((String)model.getParamCloudId(), (String)model.getParamAppId(), (String)model.getViewType(), (long)model.getOrgId(), (long)acctBookId, (String)jsonString);
    }

    private void importConnectType() {
        logger.info("\u9884\u7f6e\u8fde\u63a5\u7c7b\u578b\uff1a");
        String connect_param = this.importFile("RPAPresetISCLinkType.dts");
        DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResource", (Object[])new Object[]{connect_param});
    }

    private void importApi() {
        logger.info("\u9884\u7f6e\u81ea\u5b9a\u4e49api\uff1a");
        String api_param = this.importFile("RPAPresetISCCustomAPI.dts");
        DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResource", (Object[])new Object[]{api_param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String importFile(String fileName) {
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResource(fileName).openStream();){
            String result;
            if (in == null) {
                String string = "";
                return string;
            }
            try {
                InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));
                result = RpacpSystemParam.readText(reader);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        logger.error("\u8bfb\u53d6\u6587\u4ef6\u5173\u95ed\u6d41\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }
            }
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw new RpaException(ErrorCodeEnum.NO_DATA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(Reader reader) {
        String result = "";
        try {
            StringBuilder sb = new StringBuilder();
            int c = reader.read();
            while (c >= 0) {
                sb.append((char)c);
                c = reader.read();
            }
            result = sb.toString();
        }
        catch (IOException ioe) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.error("\u8bfb\u53d6\u6587\u4ef6\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return result;
    }

    public void initCosmic(String url) {
        try {
            this.importConnectType();
            DynamicObject connectionType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CosmicRPA")});
            DynamicObject databaseLink = BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CosmicRPA_link")});
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
            if (databaseLink == null) {
                databaseLink = new DynamicObject((DynamicObjectType)entityType);
                Long userExtId = DB.genLongId((String)"isc_database_link");
                databaseLink.set("id", (Object)userExtId);
                databaseLink.set("masterid", (Object)userExtId);
                databaseLink.set("number", (Object)"CosmicRPA_link");
                databaseLink.set("name", (Object)ResManager.loadKDString((String)"\u82cd\u7a79RPA\u79c1\u6709\u4e91", (String)"RpacpSystemParam_15", (String)"rpac-rpacp-formplugin", (Object[])new Object[0]));
                databaseLink.set("database_type", (Object)"CosmicRPA");
                if (connectionType != null) {
                    databaseLink.set("dum_link", connectionType.getPkValue());
                }
                databaseLink.set("isv", (Object)"kingdee.rpa");
            }
            String httpType = url.split("://")[0];
            String ip = url.split("://")[1];
            databaseLink.set("http_protocal", (Object)httpType);
            databaseLink.set("server_ip", (Object)ip);
            SaveServiceHelper.save((IDataEntityType)entityType, (Object[])new DynamicObject[]{databaseLink});
            OperateOption option = OperateOption.create();
            OperationServiceHelper.executeOperate((String)KEY_SAVEBTN, (String)"isc_database_link", (DynamicObject[])new DynamicObject[]{databaseLink}, (OperateOption)option);
            this.importApi();
            DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CosmicRPA_link")});
            if (dataSource != null) {
                DynamicObject dblink = BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CosmicRPA_link")});
                dataSource.set("dblink", dblink.getPkValue());
                dataSource.set("connection_type", (Object)"CosmicRPA");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSource});
            }
            DynamicObject[] apis = BusinessDataServiceHelper.load((String)"isc_apic_script", (String)"number,name,enable,group", (QFilter[])new QFilter[]{new QFilter("isv", "=", (Object)"kingdee.rpa")});
            Arrays.stream(apis).forEach(f -> f.set("enable", (Object)"1"));
            SaveServiceHelper.save((DynamicObject[])apis);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u521b\u5efa\u96c6\u6210\u4e91\u8d44\u6e90\u5f02\u5e38\u3002", (Throwable)e);
            throw e;
        }
    }

    public void updateLink(String appid, String appsecret) {
        DynamicObject databaseLink = BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CosmicRPA_link")});
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
        databaseLink.set("appid", (Object)appid);
        databaseLink.set("appsecret_new", (Object)appsecret);
        SaveServiceHelper.save((IDataEntityType)entityType, (Object[])new DynamicObject[]{databaseLink});
        OperateOption option = OperateOption.create();
        OperationServiceHelper.executeOperate((String)KEY_SAVEBTN, (String)"isc_database_link", (DynamicObject[])new DynamicObject[]{databaseLink}, (OperateOption)option);
    }
}

