/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.rpac.rpacp.common.enums.RoleEnum;

public class UserHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> queryUserIdByRoleId(List<String> roles) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserHelper.queryUserIdByRoleId", (String)"perm_userrole", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("role", "in", (Object)roles.toArray())}, (String)"user.id asc");
        GroupbyDataSet groupby = dataSet.groupBy(new String[]{"user.id"});
        DataSet dataSetResult = groupby.finish();
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            for (Row row : dataSetResult) {
                ids.add(row.getLong("user.id"));
            }
        }
        finally {
            dataSet.close();
            dataSetResult.close();
        }
        return ids;
    }

    public static List<Map<String, Object>> getUerInfo(List<Long> userids) {
        List isRoleIds = RoleEnum.getAllRoleId();
        List<Map<String, Object>> allRoleInfolist = UserHelper.queryRolesByRoleId(isRoleIds);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Long userid : userids) {
            DynamicObject user;
            HashMap<String, Object> response = new HashMap<String, Object>();
            try {
                user = BusinessDataServiceHelper.loadSingle((Object)userid, (String)"bos_user");
            }
            catch (Exception e) {
                user = null;
            }
            if (user == null) continue;
            response.put("id", user.getString("id"));
            response.put("number", user.getString("number"));
            response.put("username", user.get("username"));
            response.put("name", user.get("name"));
            response.put("email", user.getString("email"));
            response.put("phone", user.getString("phone"));
            ArrayList<Map<String, Object>> roles = new ArrayList<Map<String, Object>>();
            Set roleSet = PermissionServiceHelper.getRolesByUser((Long)userid);
            for (Map<String, Object> role : allRoleInfolist) {
                if (!roleSet.contains(role.get("id").toString())) continue;
                roles.add(role);
            }
            boolean hasOrg = UserHelper.isUserHaveOrg(userid);
            if (roles.size() > 0 && hasOrg) {
                response.put("haveright", 1);
            } else {
                response.put("haveright", 0);
            }
            response.put("roles", roles);
            ArrayList<Long> useridfororg = new ArrayList<Long>();
            useridfororg.add(user.getLong("id"));
            List orgInfoList = UserServiceHelper.getPosition(useridfororg);
            ArrayList orgs = new ArrayList();
            for (Map org : orgInfoList) {
                if (org.get("entryentity") == null) continue;
                List entryentityList = (List)org.get("entryentity");
                for (Map entryentity : entryentityList) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    DynamicObject dpt = (DynamicObject)entryentity.get("dpt");
                    map.put("id", dpt.get("id"));
                    map.put("number", dpt.get("number"));
                    map.put("name", dpt.get("name"));
                    ArrayList<Long> orgIds = new ArrayList<Long>();
                    orgIds.add(dpt.getLong("id"));
                    Map orgParentMap = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"01", orgIds);
                    if (orgParentMap.size() > 0) {
                        if (((Long)orgParentMap.get(dpt.get("id"))).toString().equals("0")) {
                            map.put("parentid", null);
                        } else {
                            map.put("parentid", orgParentMap.get(dpt.get("id")));
                        }
                    } else {
                        map.put("parentid", null);
                    }
                    orgs.add(map);
                }
            }
            response.put("orgs", orgs);
            list.add(response);
        }
        return list;
    }

    public static List<Map<String, Object>> queryRolesByRoleId(List<String> roleId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String e : roleId) {
            DynamicObject a = BusinessDataServiceHelper.loadSingle((Object)e, (String)"perm_role", (String)"id,number,name");
            if (a == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", a.get("id"));
            map.put("number", a.get("number"));
            map.put("name", a.get("name"));
            list.add(map);
        }
        return list;
    }

    public static String isUserHasRightToOpenRPA(long userid) {
        boolean bAssigned = UserHelper.isUserHaveRole(userid);
        if (!bAssigned) {
            return ResManager.loadKDString((String)"\u7531\u4e8e\u60a8\u7684\u8d26\u53f7\u672a\u5206\u914dRPA\u670d\u52a1\u4e91\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272\uff0c\u65e0\u6cd5\u4f7f\u7528\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (String)"UserHelper_0", (String)"rpac-rpacp-business", (Object[])new Object[0]);
        }
        boolean hasOrg = UserHelper.isUserHaveOrg(userid);
        if (!hasOrg) {
            return ResManager.loadKDString((String)"\u7531\u4e8e\u60a8\u7684\u8d26\u53f7\u672a\u5206\u914d\u90e8\u95e8\uff0c\u65e0\u6cd5\u4f7f\u7528\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u90e8\u95e8\u3002", (String)"UserHelper_1", (String)"rpac-rpacp-business", (Object[])new Object[0]);
        }
        return null;
    }

    public static boolean isUserHaveRole(long userid) {
        boolean flag = false;
        List allRoleInfolist = RoleEnum.getAllRoleId();
        Set roleSet = PermissionServiceHelper.getRolesByUser((Long)userid);
        for (String roleid : allRoleInfolist) {
            if (!roleSet.contains(roleid)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isUserHaveOrg(long userid) {
        ArrayList<Long> useridfororg = new ArrayList<Long>();
        useridfororg.add(userid);
        List orgInfoList = UserServiceHelper.getPosition(useridfororg);
        boolean flag = false;
        for (Map org : orgInfoList) {
            if (org.get("entryentity") == null) continue;
            flag = true;
        }
        return flag;
    }
}

