/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.webapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.url.UrlService;

@ApiController(value="rpac", desc="\u9644\u4ef6\u4e0b\u8f7d\u63a7\u5236\u7c7b")
@ApiMapping(value="/basic")
public class AnnexApiController {
    private static final Log logger = LogFactory.getLog(AnnexApiController.class);
    public static final int INITIALIZATION = 4;

    @ApiPostMapping(value="/getPkId")
    public CustomApiResult<Object> getPkId(@Valid @ApiParam(required=true, value="\u5355\u636e\u6807\u8bc6") @Valid @ApiParam(required=true, value="\u5355\u636e\u6807\u8bc6") String entityNumber, @Valid @ApiParam(required=true, value="\u5355\u636e\u7f16\u7801") @Valid @ApiParam(required=true, value="\u5355\u636e\u7f16\u7801") String number) {
        try {
            HashMap<String, Object> resultInfo = new HashMap<String, Object>();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection dataEntityProperties = mainEntityType.getProperties();
            String fieldName = "number";
            if (dataEntityProperties.containsKey((Object)"number")) {
                fieldName = "number";
            } else if (dataEntityProperties.containsKey((Object)"billno")) {
                fieldName = "billno";
            }
            try {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityNumber, (QFilter[])new QFilter[]{new QFilter(fieldName, "=", (Object)number)});
                resultInfo.put("id", dynamicObject.getPkValue());
                return CustomApiResult.success(resultInfo);
            }
            catch (Exception e) {
                logger.error("api\u2014\u2014\u8868\u5355\u4e0d\u5b58\u5728/\u6570\u636e\u4e0d\u5b58\u5728\uff1a", (Throwable)e);
                return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728/\u6570\u636e\u4e0d\u5b58\u5728", (String)"AnnexApiController_3", (String)"rpac-rpacp-webapi", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("api\u2014\u2014\u83b7\u53d6getPkId\u5931\u8d25\uff1a", (Throwable)e);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u83b7\u53d6getPkId\u5931\u8d25", (String)"AnnexApiController_5", (String)"rpac-rpacp-webapi", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/getAnnexFileInfo")
    public CustomApiResult<Object> getAnnexFileInfo(@Valid @ApiParam(required=true, value="\u5e94\u7528Id") @Valid @ApiParam(required=true, value="\u5e94\u7528Id") String appId, @Valid @ApiParam(required=true, value="\u5355\u636e\u6807\u8bc6") @Valid @ApiParam(required=true, value="\u5355\u636e\u6807\u8bc6") String entityNumber, @Valid @ApiParam(required=true, value="\u5355\u636e\u5185\u7801id") @Valid @ApiParam(required=true, value="\u5355\u636e\u5185\u7801id") String pkId) {
        DynamicObject dynamicObject;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entityNumber);
        }
        catch (Exception e) {
            logger.error("api\u2014\u2014\u8868\u5355\u4e0d\u5b58\u5728/\u6570\u636e\u4e0d\u5b58\u5728\uff1a", (Throwable)e);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728/\u6570\u636e\u4e0d\u5b58\u5728", (String)"AnnexApiController_3", (String)"rpac-rpacp-webapi", (Object[])new Object[0]));
        }
        try {
            Boolean hasPerm;
            if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId()) && !(hasPerm = Boolean.valueOf(PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityNumber, (String)"47150e89000000ac"))).booleanValue()) {
                String sMessage = String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u6ca1\u6709\u5e94\u7528\u3010%2$s\u3011\u7684\u8868\u5355\u3010%3$s\u3011\u7684\u67e5\u770b\u6743\u9650", (String)"AnnexApiController_20", (String)"rpac-rpacp-webapi", (Object[])new Object[0]), RequestContext.get().getUserName(), appId, entityNumber);
                return CustomApiResult.fail((String)"-3", (String)sMessage);
            }
        }
        catch (Exception e) {
            logger.error("api\u2014\u2014\u6743\u9650\u6821\u9a8c\u5f02\u5e38\uff1a", (Throwable)e);
            return CustomApiResult.fail((String)"-4", (String)e.getMessage());
        }
        try {
            ArrayList resultInfo = new ArrayList();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection dataEntityProperties = mainEntityType.getProperties();
            for (IDataEntityProperty e : dataEntityProperties) {
                if (!e.getClass().getName().equals("kd.bos.entity.property.AttachmentProp")) continue;
                DynamicObject file = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)e.getName(), (QFilter[])new QFilter[]{new QFilter("id", "=", dynamicObject.getPkValue())});
                DynamicObjectCollection lagoAttachmentfield = (DynamicObjectCollection)file.get(e.getName());
                for (DynamicObject field : lagoAttachmentfield) {
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    DynamicObject fbasedataId = field.getDynamicObject("fbasedataId");
                    map.put("url", UrlService.getAttachmentFullUrl((String)fbasedataId.get("url").toString()));
                    map.put("size", fbasedataId.get("size").toString());
                    map.put("filename", fbasedataId.get("name").toString());
                    map.put("key", e.getName());
                    resultInfo.add(map);
                }
            }
            ArrayList attachKeyList = new ArrayList();
            Map attachmentMap = AttachmentServiceHelper.getAttachmentsForApi((String)entityNumber, (Object)pkId);
            Set attachmentPannelKeys = attachmentMap.keySet();
            attachKeyList.addAll(attachmentPannelKeys);
            for (String tempAttaKey : attachKeyList) {
                List attachments = AttachmentServiceHelper.getAttachments((String)entityNumber, (Object)pkId, (String)tempAttaKey);
                if (attachments == null || attachments.isEmpty()) continue;
                for (Map e : attachments) {
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    map.put("url", e.get("url").toString());
                    map.put("size", e.get("size").toString());
                    map.put("filename", e.get("name").toString());
                    map.put("key", tempAttaKey);
                    resultInfo.add(map);
                }
            }
            return CustomApiResult.success(resultInfo);
        }
        catch (Exception e) {
            logger.error("api\u2014\u2014\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7durl\u5f02\u5e38\uff1a", (Throwable)e);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7durl\u5f02\u5e38", (String)"AnnexApiController_4", (String)"rpac-rpacp-webapi", (Object[])new Object[0]));
        }
    }
}

