/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.webapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ValidationUtils;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;

@ApiController(value="rpac", desc="rpacAPI\u63a7\u5236\u7c7b")
@ApiMapping(value="/basic")
public class RpacApiController {
    private static final Log logger = LogFactory.getLog(RpacApiController.class);
    private static final String SYSTEMTYPE = "rpac-rpacp-webapi";
    private static final String RPACP = "rpacp";
    private static final String RPASERVICE = "RpaService";

    @ApiPostMapping(value="/getProcessList")
    public CustomApiResult<Object> getProcessListService(@Valid @ApiParam(required=true, value="\u82cd\u7a79\u5e73\u53f0\u7528\u6237\u540d/\u624b\u673a\u53f7") @Valid @ApiParam(required=true, value="\u82cd\u7a79\u5e73\u53f0\u7528\u6237\u540d/\u624b\u673a\u53f7") String user, @ApiParam(value="\u6d41\u7a0b\u6807\u7b7e") @ApiParam(value="\u6d41\u7a0b\u6807\u7b7e") String procLabel) {
        List listResult;
        String userId = this.queryUserIdByAccount(user);
        if (userId == null) {
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728", (String)"RpacApiController_8", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        try {
            logger.info("api\u2014\u2014\u83b7\u53d6\u6d41\u7a0b\u5217\u8868...");
            listResult = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)RPACP, (String)RPASERVICE, (String)"getProcessList", (Object[])new Object[]{userId, procLabel});
            logger.info("api\u2014\u2014\u83b7\u53d6\u6d41\u7a0b\u6210\u529f!");
        }
        catch (KDException ex) {
            logger.error("api\u2014\u2014\u83b7\u53d6\u6d41\u7a0b\u5931\u8d25\uff1a", (Throwable)ex);
            if (ex.getMessage().contains(ResManager.loadKDString((String)"\u7528\u6237\u4e0d\u5b58\u5728", (String)"RpacApiController_8", (String)SYSTEMTYPE, (Object[])new Object[0]))) {
                ArrayList listResult2 = new ArrayList();
                return CustomApiResult.success(listResult2);
            }
            return CustomApiResult.fail((String)"-1", (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error("api\u2014\u2014\u83b7\u53d6\u6d41\u7a0b\u5931\u8d25\uff1a", (Throwable)ex);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u5931\u8d25!", (String)"RpacApiController_1", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)listResult);
    }

    @ApiPostMapping(value="/getRobotList")
    public CustomApiResult<Object> getRobotListService(@Valid @ApiParam(required=true, value="\u6d41\u7a0bid") @Valid @ApiParam(required=true, value="\u6d41\u7a0bid") String processId) {
        List result;
        try {
            logger.info("api\u2014\u2014\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868...");
            result = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)RPACP, (String)RPASERVICE, (String)"getRobotList", (Object[])new Object[]{processId});
            logger.info("api\u2014\u2014\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868\u6210\u529f!");
        }
        catch (Exception ex) {
            logger.error("api\u2014\u2014\u83b7\u53d6\u673a\u5668\u4eba\u5217\u8868\u5931\u8d25\uff1a", (Throwable)ex);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u673a\u5668\u4eba\u5931\u8d25!", (String)"RpacApiController_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)result);
    }

    @ApiPostMapping(value="/addTask")
    public CustomApiResult<Object> addTaskService(@Valid @ApiParam(required=true, value="\u6d41\u7a0b\u7f16\u7801") @Valid @ApiParam(required=true, value="\u6d41\u7a0b\u7f16\u7801") String procCode, @Valid @ApiParam(required=true, value="\u673a\u5668\u4ebaid") @Valid @ApiParam(required=true, value="\u673a\u5668\u4ebaid") String robotId, @ApiParam(value="\u6d41\u7a0b\u7248\u672c\u53f7") @ApiParam(value="\u6d41\u7a0b\u7248\u672c\u53f7") String processVersion, @ApiParam(value="\u6d41\u7a0b\u53c2\u6570") @ApiParam(value="\u6d41\u7a0b\u53c2\u6570") List<Map<String, String>> params) {
        String taskId;
        try {
            logger.info("api\u2014\u2014\u65b0\u589e\u6d41\u7a0b\u4efb\u52a1...");
            taskId = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)RPACP, (String)RPASERVICE, (String)"addTask", (Object[])new Object[]{procCode, robotId, processVersion, params});
            logger.info("api\u2014\u2014\u65b0\u589e\u6d41\u7a0b\u4efb\u52a1\u6210\u529f!");
        }
        catch (Exception ex) {
            logger.error("api\u2014\u2014\u65b0\u589e\u6d41\u7a0b\u4efb\u52a1\u5931\u8d25\uff1a", (Throwable)ex);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u65b0\u589e\u4efb\u52a1\u5931\u8d25!", (String)"RpacApiController_3", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)taskId);
    }

    @ApiPostMapping(value="/getTaskLogUrl")
    public CustomApiResult<Object> getTaskLogUrlService(@Valid @ApiParam(required=true, value="\u4efb\u52a1id") @Valid @ApiParam(required=true, value="\u4efb\u52a1id") String taskId) {
        String logurl;
        try {
            logger.info("api\u2014\u2014\u83b7\u53d6\u4efb\u52a1\u8fd0\u884c\u65e5\u5fd7url...");
            logurl = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)RPACP, (String)RPASERVICE, (String)"getTaskLogUrl", (Object[])new Object[]{taskId});
            logger.info("api\u2014\u2014\u83b7\u53d6\u4efb\u52a1\u8fd0\u884c\u65e5\u5fd7url\u6210\u529f!");
            if (!logurl.startsWith("http")) {
                logurl = RequestContext.get().getClientFullContextPath() + logurl;
            }
        }
        catch (Exception ex) {
            logger.error("api\u2014\u2014\u83b7\u53d6\u4efb\u52a1\u8fd0\u884c\u65e5\u5fd7url\u5931\u8d25\uff1a", (Throwable)ex);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1\u8fd0\u884c\u65e5\u5fd7url\u5931\u8d25!", (String)"RpacApiController_4", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)logurl);
    }

    @ApiPostMapping(value="/getTaskInfo")
    public CustomApiResult<Object> getTaskInfoService(@Valid @ApiParam(required=true, value="\u4efb\u52a1id") @Valid @ApiParam(required=true, value="\u4efb\u52a1id") String taskId) {
        Map response;
        try {
            logger.info("api\u2014\u2014\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f...");
            response = (Map)DispatchServiceHelper.invokeBizService((String)"rpac", (String)RPACP, (String)RPASERVICE, (String)"getTaskInfo", (Object[])new Object[]{taskId});
            logger.info("api\u2014\u2014\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u6210\u529f!");
        }
        catch (Exception ex) {
            logger.error("api\u2014\u2014\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)ex);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25!", (String)"RpacApiController_5", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)response);
    }

    @ApiPostMapping(value="/getProcessParams")
    public CustomApiResult<Object> getProcessParamsService(@Valid @ApiParam(required=true, value="\u6d41\u7a0b\u7f16\u53f7") @Valid @ApiParam(required=true, value="\u6d41\u7a0b\u7f16\u53f7") String procCode, @ApiParam(value="\u6d41\u7a0b\u7248\u672c\u53f7") @ApiParam(value="\u6d41\u7a0b\u7248\u672c\u53f7") String procVer) {
        List mapList;
        try {
            logger.info("api\u2014\u2014\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570...");
            mapList = (List)DispatchServiceHelper.invokeBizService((String)"rpac", (String)RPACP, (String)RPASERVICE, (String)"getProcessParms", (Object[])new Object[]{procCode, procVer});
            logger.info("api\u2014\u2014\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u6210\u529f!");
        }
        catch (Exception ex) {
            logger.error("api\u2014\u2014\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u5931\u8d25\uff1a", (Throwable)ex);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u5931\u8d25!", (String)"RpacApiController_6", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)mapList);
    }

    @ApiPostMapping(value="/encryptStr")
    public CustomApiResult<Object> encryptStrService(@Valid @ApiParam(required=true, value="\u5f85\u52a0\u5bc6\u5b57\u7b26\u4e32") @Valid @ApiParam(required=true, value="\u5f85\u52a0\u5bc6\u5b57\u7b26\u4e32") String str) {
        String encryptedStr;
        try {
            logger.info("api\u2014\u2014\u5b57\u7b26\u4e32\u52a0\u5bc6...");
            encryptedStr = (String)DispatchServiceHelper.invokeBizService((String)"rpac", (String)RPACP, (String)RPASERVICE, (String)"passwordEncrypt", (Object[])new Object[]{str});
            logger.info("api\u2014\u2014\u5b57\u7b26\u4e32\u52a0\u5bc6\u6210\u529f!");
        }
        catch (Exception ex) {
            logger.error("api\u2014\u2014\u5b57\u7b26\u4e32\u52a0\u5bc6\uff1a", (Throwable)ex);
            return CustomApiResult.fail((String)"-1", (String)ResManager.loadKDString((String)"\u5b57\u7b26\u4e32\u52a0\u5bc6\u5931\u8d25!", (String)"RpacApiController_7", (String)SYSTEMTYPE, (Object[])new Object[0]));
        }
        return CustomApiResult.success((Object)encryptedStr);
    }

    private String queryUserIdByAccount(String account) {
        ORM orm = ORM.create();
        logger.info("\u67e5\u8be2\u8d26\u6237\u7684userid\uff1a-----\uff1a" + account);
        QFilter[] qFilters = ValidationUtils.isPhone((String)account) ? new QFilter[]{new QFilter("phone", "=", (Object)account)} : new QFilter[]{new QFilter("username", "=", (Object)account)};
        DynamicObject user = orm.queryOne("bos_user", "id", qFilters);
        if (user != null) {
            logger.info("\u8d26\u6237\u7684userid\uff1a-----\uff1a" + user.get("id").toString());
            return user.get("id").toString();
        }
        return null;
    }
}

