/*
 * Decompiled with CFR 0.152.
 */
package kd.rpac.rpacp.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.rpac.rpacp.business.UserHelper;
import kd.rpac.rpacp.common.RpaResponse;
import kd.rpac.rpacp.common.utils.IsrpaHttpUtil;
import kd.rpac.rpacp.formplugin.RpacpSystemParam;
import kd.rpac.rpacp.mservice.api.RpaService;
import org.apache.commons.lang3.StringUtils;

public class RpaServiceImpl
implements RpaService {
    private static final Log logger = LogFactory.getLog(RpaServiceImpl.class);
    private static final String FACTORYQUALIFIEDPREFIX = "ysq.rpac.rpamc.servicehelper";
    private static final String APPID = "ysq_rpamc";
    private static final String SERVICENAME = "RpaService";

    public String isUserHasRightToOpenRPA(Long userid) {
        return UserHelper.isUserHasRightToOpenRPA((long)userid);
    }

    public List<Map<String, Object>> getProcessList(String userId, String procLabel) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        if (!StringUtils.isEmpty((CharSequence)procLabel)) {
            map.put("procLabel", procLabel);
        }
        if (!this.isInitRpaSysParameter()) {
            logger.info("\u83b7\u53d6\u6d41\u7a0b\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
            List response = (List)DispatchServiceHelper.invokeService((String)FACTORYQUALIFIEDPREFIX, (String)APPID, (String)SERVICENAME, (String)"getProcessList", (Object[])new Object[]{map});
            logger.info("\u83b7\u53d6\u6d41\u7a0b\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)response));
            return response;
        }
        logger.info("\u83b7\u53d6\u6d41\u7a0b\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        this.isinit();
        HashMap resultmap = (HashMap)DispatchServiceHelper.invokeExternalService((String)"rpac", (String)"KD_RPAC_getProcessList", map);
        RpaResponse plainPost = this.getRpaResponse(resultmap);
        logger.info("\u83b7\u53d6\u6d41\u7a0b\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)plainPost));
        if (plainPost.getCode() != 0) {
            throw new KDException(new ErrorCode("rpac.rpacp.rpaService", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a7\u5236\u53f0\u63a5\u53e3\u5f02\u5e38:%s", (String)"RpaServiceImpl_1", (String)"rpac-rpacp-mservice", (Object[])new Object[0]), plainPost.getMsg())), new Object[]{plainPost.getMsg()});
        }
        JSONObject result = (JSONObject)JSON.toJSON((Object)plainPost.getResult());
        JSONArray items = result.getJSONArray("items");
        List data = (List)JSON.parse((String)items.toJSONString());
        return data;
    }

    public List<Map<String, Object>> getRobotList(String processId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processId", processId);
        if (!this.isInitRpaSysParameter()) {
            logger.info("\u83b7\u53d6\u673a\u5668\u4eba\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
            List response = (List)DispatchServiceHelper.invokeService((String)FACTORYQUALIFIEDPREFIX, (String)APPID, (String)SERVICENAME, (String)"getRobotList", (Object[])new Object[]{map});
            logger.info("\u83b7\u53d6\u673a\u5668\u4eba\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)response));
            return response;
        }
        logger.info("\u83b7\u53d6\u673a\u5668\u4eba\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        this.isinit();
        HashMap resultmap = (HashMap)DispatchServiceHelper.invokeExternalService((String)"rpac", (String)"KD_RPAC_getRobotList", map);
        RpaResponse plainPost = this.getRpaResponse(resultmap);
        logger.info("\u83b7\u53d6\u673a\u5668\u4eba\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)plainPost));
        if (plainPost.getCode() != 0) {
            throw new KDException(new ErrorCode("rpac.rpacp.rpaService", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a7\u5236\u53f0\u63a5\u53e3\u5f02\u5e38:%s", (String)"RpaServiceImpl_1", (String)"rpac-rpacp-mservice", (Object[])new Object[0]), plainPost.getMsg())), new Object[]{plainPost.getMsg()});
        }
        JSONObject result = (JSONObject)JSON.toJSON((Object)plainPost.getResult());
        JSONArray items = result.getJSONArray("items");
        List data = (List)JSON.parse((String)items.toJSONString());
        return data;
    }

    public String addTask(String processCode, String robotId, String processVersion, List<Map<String, String>> parms) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("procCode", processCode);
        map.put("performTerminal", robotId);
        if (StringUtils.isEmpty((CharSequence)processVersion)) {
            map.put("procVer", "");
        } else {
            map.put("procVer", processVersion);
        }
        if (!this.isInitRpaSysParameter()) {
            if (parms != null && parms.size() > 0) {
                map.put("procPar", this.transParmsToObject(parms));
            }
            logger.info("\u65b0\u589e\u4efb\u52a1\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
            String response = (String)DispatchServiceHelper.invokeService((String)FACTORYQUALIFIEDPREFIX, (String)APPID, (String)SERVICENAME, (String)"addTask", (Object[])new Object[]{map});
            logger.info("\u65b0\u589e\u4efb\u52a1\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)response));
            return response;
        }
        if (parms != null && parms.size() > 0) {
            map.put("procPar", JSON.toJSONString(this.transParmsToObject(parms)));
        }
        logger.info("\u65b0\u589e\u4efb\u52a1\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        this.isinit();
        HashMap resultmap = (HashMap)DispatchServiceHelper.invokeExternalService((String)"rpac", (String)"KD_RPAC_addTask", map);
        RpaResponse plainPost = this.getRpaResponse(resultmap);
        logger.info("\u65b0\u589e\u4efb\u52a1\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)plainPost));
        if (plainPost.getCode() != 0) {
            throw new KDException(new ErrorCode("rpac.rpacp.rpaService", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a7\u5236\u53f0\u63a5\u53e3\u5f02\u5e38:%s", (String)"RpaServiceImpl_1", (String)"rpac-rpacp-mservice", (Object[])new Object[0]), plainPost.getMsg())), new Object[]{plainPost.getMsg()});
        }
        JSONObject result = (JSONObject)JSON.toJSON((Object)plainPost.getResult());
        String taskId = result.getString("taskId");
        return taskId;
    }

    public String getTaskLogUrl(String taskId) {
        if (!this.isInitRpaSysParameter()) {
            return "?formId=ysq_rpa_job_log&id=" + taskId;
        }
        Map<String, Object> rpaSysParameter = this.getRpaSysParameter();
        logger.info("\u83b7\u53d6\u4efb\u52a1\u6267\u884c\u65e5\u5fd7url\u2014\u2014\u2014RPA\u79c1\u6709\u4e91");
        String url = "/console/openplay?jobId=" + taskId;
        return rpaSysParameter.get("url").toString().concat(url);
    }

    public Map<String, Object> getTaskInfo(String taskId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        if (!this.isInitRpaSysParameter()) {
            logger.info("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
            Map response = (Map)DispatchServiceHelper.invokeService((String)FACTORYQUALIFIEDPREFIX, (String)APPID, (String)SERVICENAME, (String)"getTaskStatus", (Object[])new Object[]{map});
            logger.info("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)response));
            return response;
        }
        logger.info("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        this.isinit();
        HashMap resultmap = (HashMap)DispatchServiceHelper.invokeExternalService((String)"rpac", (String)"KD_RPAC_getTaskInfo", map);
        RpaResponse plainPost = this.getRpaResponse(resultmap);
        logger.info("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)plainPost));
        if (plainPost.getCode() != 0) {
            throw new KDException(new ErrorCode("rpac.rpacp.rpaService", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a7\u5236\u53f0\u63a5\u53e3\u5f02\u5e38:%s", (String)"RpaServiceImpl_1", (String)"rpac-rpacp-mservice", (Object[])new Object[0]), plainPost.getMsg())), new Object[]{plainPost.getMsg()});
        }
        JSONObject result = (JSONObject)JSON.toJSON((Object)plainPost.getResult());
        Map data = (Map)JSON.parse((String)result.toJSONString());
        return data;
    }

    public List<Map<String, String>> getProcessParms(String procCode, String procVer) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("procCode", procCode);
        if (!StringUtils.isEmpty((CharSequence)procVer)) {
            map.put("procVer", procVer);
        }
        if (!this.isInitRpaSysParameter()) {
            logger.info("\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u4fe1\u606f\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
            List response = (List)DispatchServiceHelper.invokeService((String)FACTORYQUALIFIEDPREFIX, (String)APPID, (String)SERVICENAME, (String)"getParams", (Object[])new Object[]{map});
            List<Map<String, String>> data = this.transParmsToString(response);
            logger.info("\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u4fe1\u606f\u2014\u2014\u2014RPA\u516c\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)response));
            return data;
        }
        logger.info("\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u4fe1\u606f\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(map));
        this.isinit();
        HashMap resultmap = (HashMap)DispatchServiceHelper.invokeExternalService((String)"rpac", (String)"KD_RPAC_getProcessParms", map);
        RpaResponse plainPost = this.getRpaResponse(resultmap);
        logger.info("\u83b7\u53d6\u6d41\u7a0b\u53c2\u6570\u4fe1\u606f\u2014\u2014\u2014RPA\u79c1\u6709\u4e91\u2014\u2014\u2014\u8bf7\u8fd4\u56de\u62a5\u6587\uff1a" + JSON.toJSONString((Object)plainPost));
        List<Map<String, String>> data = new ArrayList<Map<String, String>>();
        if (plainPost.getCode() != 0) {
            throw new KDException(new ErrorCode("rpac.rpacp.rpaService", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u63a7\u5236\u53f0\u63a5\u53e3\u5f02\u5e38:%s", (String)"RpaServiceImpl_1", (String)"rpac-rpacp-mservice", (Object[])new Object[0]), plainPost.getMsg())), new Object[]{plainPost.getMsg()});
        }
        if ("[]".equals(plainPost.getResult())) {
            return data;
        }
        JSONArray result = (JSONArray)JSON.toJSON((Object)plainPost.getResult());
        List response = (List)JSON.parse((String)result.toJSONString());
        data = this.transParmsToString(response);
        return data;
    }

    private List<Map<String, String>> transParmsToString(List<Map<String, Object>> parms) {
        for (int i = 0; i < parms.size(); ++i) {
            if (!parms.get(i).get("Type").equals("excel_cell") && !parms.get(i).get("Type").equals("excel_range")) continue;
            parms.get(i).put("Value", JSON.toJSONString((Object)parms.get(i).get("Value")));
        }
        String str = JSON.toJSONString(parms);
        return (List)JSON.parse((String)str);
    }

    private List<Map<String, Object>> transParmsToObject(List<Map<String, String>> parms) {
        String str = JSON.toJSONString(parms);
        List responseObject = (List)JSON.parse((String)str);
        for (int i = 0; i < responseObject.size(); ++i) {
            if (!((Map)responseObject.get(i)).get("Type").equals("excel_cell") && !((Map)responseObject.get(i)).get("Type").equals("excel_range")) continue;
            ((Map)responseObject.get(i)).put("Value", JSON.parse((String)parms.get(i).get("Value")));
        }
        return responseObject;
    }

    public String passwordEncrypt(String passWord) throws Exception {
        String szTmp;
        passWord = "#*" + passWord + "*#";
        Base64.Encoder encoder = Base64.getEncoder();
        String szOut = encoder.encodeToString(passWord.getBytes("utf-8"));
        int nSize = szOut.length();
        int nFind = szOut.indexOf(61);
        String szEq = "";
        if (szOut.indexOf(61) > -1) {
            szTmp = szOut.substring(0, nFind);
            szEq = szOut.substring(nFind, nSize);
        } else {
            szTmp = szOut;
        }
        int nHalf = szTmp.length() / 2;
        passWord = szTmp.substring(nHalf) + szTmp.substring(0, nHalf) + szEq;
        return passWord;
    }

    public Map<String, String> getheaderMap(Map<String, Object> paramMap, String accessToken) throws Exception {
        logger.info("\u83b7\u53d6\u52a0\u7b7eheader\u8bf7\u6c42\u53c2\u6570--map\uff1a" + JSON.toJSONString(paramMap) + "\u83b7\u53d6\u52a0\u7b7eheader\u8bf7\u6c42\u53c2\u6570--accessToken\uff1a" + accessToken);
        Map result = IsrpaHttpUtil.getSignaPostHeader(paramMap, (String)accessToken);
        logger.info("\u83b7\u53d6\u52a0\u7b7eheader\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)result));
        return result;
    }

    private Map<String, Object> getRpaSysParameter() {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"rpacp");
        AppParam apm = new AppParam();
        apm.setAppId(appInfo.getId());
        apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm);
    }

    private boolean isInitRpaSysParameter() {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"rpacp");
        AppParam apm = new AppParam();
        apm.setAppId(appInfo.getId());
        apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        Map rpaSysParameter = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm);
        return !CollectionUtils.isEmpty((Map)rpaSysParameter) && rpaSysParameter.get("url") != null && !kd.bos.login.utils.StringUtils.isEmpty((String)rpaSysParameter.get("url").toString().trim()) && rpaSysParameter.get("appid") != null && !kd.bos.login.utils.StringUtils.isEmpty((String)rpaSysParameter.get("appid").toString().trim()) && rpaSysParameter.get("appsecret") != null && !kd.bos.login.utils.StringUtils.isEmpty((String)rpaSysParameter.get("appsecret").toString().trim());
    }

    public RpaResponse getRpaResponse(Map<String, Object> resultmap) {
        logger.info("\u5f97\u5230\u7684\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a--" + resultmap.toString());
        RpaResponse response = new RpaResponse();
        response.setCode(Integer.decode(resultmap.get("code").toString()));
        response.setMsg(resultmap.get("msg").toString());
        response.setResult(resultmap.get("result"));
        return response;
    }

    public void isinit() {
        DynamicObject connectionType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"CosmicRPA")});
        if (connectionType == null) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)"rpacp");
            AppParam apm = new AppParam();
            apm.setAppId(appInfo.getId());
            apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
            Map rpaSysParameter = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm);
            logger.info("\u83b7\u53d6\u5230\u7684rpa\u7cfb\u7edf\u53c2\u6570\uff1a" + JSON.toJSONString((Object)rpaSysParameter));
            RpacpSystemParam rpacpSystemParam = new RpacpSystemParam();
            String url = rpaSysParameter.get("url").toString();
            String appid = rpaSysParameter.get("appid").toString();
            String appsecret = rpaSysParameter.get("appsecret").toString();
            if (url.length() != 0 && appid.length() != 0 && appsecret.length() != 0) {
                rpacpSystemParam.initCosmic(url);
                rpacpSystemParam.updateLink(appid, appsecret);
            }
        }
    }
}

