/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.appApi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.constant.YsqScheduleConstant;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class AppRobotBindActionApiPlugin
implements IBillWebApiPlugin {
    protected Log log = LogFactory.getLog(this.getClass());
    public static final String appBindListURL = "/app/ysq_rpaac/appBindList";

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String url = ctx.getRequestURL();
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        if (ObjectUtils.isEmpty(commtoken)) {
            return ISearchApiResultVO.fail((String)"commtoken is none!", (Integer)1);
        }
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        switch (url) {
            case "/app/ysq_rpaac/appBindList": {
                return this.appBindListURL(ctx);
            }
        }
        return ISearchApiResultVO.fail((String)"404", (Integer)1);
    }

    private ApiResult appBindListURL(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        HashMap resaultMap = new HashMap();
        if (commtoken == null) {
            return ISearchApiResultVO.fail((String)"commtoken\u4e3a\u7a7a\uff01", (Integer)1);
        }
        QFilter procType = new QFilter("ysq_proc_type", "=", (Object)"standard");
        QFilter[] proFilters = new QFilter[]{procType};
        DynamicObjectCollection procList = QueryServiceHelper.query((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])proFilters);
        ArrayList bindList = new ArrayList();
        ArrayList procCodelist = new ArrayList();
        procList.stream().forEach(proc -> procCodelist.add(proc.getString("ysq_proc_code")));
        procList.stream().forEach(proc -> {
            HashMap<String, Object> onePorcVer = new HashMap<String, Object>();
            onePorcVer.put("proc_name", proc.getString("ysq_proc_name"));
            onePorcVer.put("proc_code", proc.getString("ysq_proc_code"));
            onePorcVer.put("proc_file", proc.getString("ysq_proc_file"));
            if (!LicenseUtils.checkStdAppLicense((String)proc.getString("ysq_proc_code")).booleanValue()) {
                return;
            }
            List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process", (Object)proc.getLong("id"), (String)"attachmentpanel");
            if (attachmentpanel.size() > 0) {
                String url = ((Map)attachmentpanel.get(0)).get("url").toString();
                onePorcVer.put("file_url", url);
                this.log.info("\u83b7\u53d6\u6807\u51c6\u5e94\u7528\u5217\u8868\uff0c\u83b7\u53d6\u6d41\u7a0b\u9644\u4ef6\u4fe1\u606f" + attachmentpanel);
            } else {
                QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)proc.getString("ysq_proc_code")), new QFilter("ysq_proc_ver", "=", (Object)proc.getString("ysq_proc_ver"))};
                DynamicObject processVerDb = null;
                try {
                    processVerDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr);
                }
                catch (Exception e) {
                    return;
                }
                attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process_ver", (Object)processVerDb.getLong("id"), (String)"attachmentpanel");
                if (attachmentpanel.size() > 0) {
                    String url = ((Map)attachmentpanel.get(0)).get("url").toString();
                    onePorcVer.put("file_url", url);
                    this.log.info("\u83b7\u53d6\u6807\u51c6\u5e94\u7528\u5217\u8868\uff0c\u83b7\u53d6\u6d41\u7a0b\u7248\u672c\u9644\u4ef6\u4fe1\u606f" + attachmentpanel);
                } else {
                    this.log.warn("\u83b7\u53d6\u6807\u51c6\u5e94\u7528\u5217\u8868\u6ca1\u6709\u627e\u5230\u9644\u4ef6");
                    return;
                }
            }
            onePorcVer.put("proc_ver", proc.getString("ysq_proc_ver"));
            onePorcVer.put("publish", proc.getString("ysq_publish_time"));
            onePorcVer.put("proc_run_mode", "all");
            onePorcVer.put("is_assistant", proc.getBoolean("ysq_is_assistant"));
            onePorcVer.put("is_start_up", proc.getBoolean("ysq_is_start_up"));
            onePorcVer.put("proc_desc", proc.getString("ysq_proc_desc"));
            bindList.add(onePorcVer);
        });
        resaultMap.put("procList", bindList);
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult(resaultMap);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    public void deleteSchAgent(String procCode, CdaAgentVO agent) {
        QFilter schProcCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject[] procSchList = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)YsqScheduleConstant.selAllFileds(), (QFilter[])new QFilter[]{schProcCodeFilter});
        if (null != procSchList && procSchList.length > 0) {
            for (int i = 0; i < procSchList.length; ++i) {
                String execRobotsNo = procSchList[i].getString("ysq_exec_robots_no_tag");
                String robotsSel = procSchList[i].getString("ysq_robots_sel");
                if (execRobotsNo.contains(agent.getAgentNo())) {
                    String newNo = execRobotsNo.replace("-" + agent.getAgentNo() + "-", "");
                    String newNoSel = robotsSel.replace(agent.getAgentNo(), "");
                    procSchList[i].set("ysq_exec_robots_no_tag", (Object)newNo);
                    procSchList[i].set("ysq_robots_sel", (Object)newNoSel);
                }
                SaveServiceHelper.update((DynamicObject)procSchList[i]);
            }
        }
    }
}

