/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.assetApi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAssetConstant;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.enums.RobotTypeEnums;
import ysq.rpac.rpamc.common.model.AssetVO;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.OrgServiceHelper;
import ysq.rpac.rpamc.common.utils.EsUtils;
import ysq.rpac.rpamc.common.utils.SecretUtil;

public class AssetInfoApiPlugin
implements IBillWebApiPlugin {
    private static Log log = LogFactory.getLog(AssetInfoApiPlugin.class);
    public static final String QUERY_ASSET_URL = "/app/ysq_rpamc/getAsset";
    public static final String EDIT_ASSET_URL = "/app/ysq_rpamc/editAsset";

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String url;
        switch (url = ctx.getRequestURL()) {
            case "/app/ysq_rpamc/getAsset": {
                return this.queryAsset(ctx);
            }
            case "/app/ysq_rpamc/editAsset": {
                return this.editAsset(ctx);
            }
        }
        return ISearchApiResultVO.fail((String)"404", (Integer)1);
    }

    public ApiResult queryAsset(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        Long agentOrgFid = null;
        String agentNo = null;
        String agentType = null;
        if (commtoken != null && commtoken != "") {
            CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
            agentOrgFid = agent.getOrgFid();
            agentNo = agent.getAgentNo();
            agentType = agent.getAgentType();
        }
        Map data = ctx.getData();
        Object assetNameObj = data.get("assetName");
        Object jobNoObj = data.get("jobNo");
        Object procCodeObj = data.get("procCode");
        if (agentOrgFid == null) {
            agentOrgFid = RequestContext.get().getOrgId();
        }
        if (assetNameObj == null) {
            return ISearchApiResultVO.fail((String)"\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Integer)1);
        }
        String assetName = assetNameObj.toString();
        String jobNo = jobNoObj.toString();
        String procCode = procCodeObj.toString();
        Long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("ysq_asset_name", "=", (Object)assetName);
        DynamicObject assetObj = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_asset", (String)YsqAssetConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
        if (assetObj == null) {
            return ISearchApiResultVO.fail((String)"\u53d8\u91cf\u4e0d\u5b58\u5728", (Integer)1);
        }
        if (this.checkAssetOrg(assetObj, agentNo, agentOrgFid)) {
            return ISearchApiResultVO.fail((String)"\u5f53\u524d\u673a\u5668\u4eba\u6ca1\u6709\u8bbf\u95ee\u6b64\u53d8\u91cf\u7684\u6743\u9650", (Integer)1);
        }
        String assetValue = assetObj.getString("ysq_asset_value_tag");
        String assetType = assetObj.getString("ysq_asset_type");
        if (StringUtils.isNotBlank((CharSequence)assetValue) && StringUtils.isNotBlank((CharSequence)assetType) && StringUtils.equals((CharSequence)assetType, (CharSequence)"passwd")) {
            assetObj.set("ysq_asset_value_tag", (Object)SecretUtil.desDecrypt((String)assetValue));
        }
        QFilter robotNoQFilter = new QFilter("ysq_agent_no", "=", (Object)agentNo);
        QFilter agentTypeFilter = new QFilter("ysq_agent_no", "!=", (Object)RobotTypeEnums.STUDIO.getCode());
        DynamicObject object = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)"ysq_agent_alias", (QFilter[])new QFilter[]{robotNoQFilter, agentTypeFilter});
        String agentAlias = null;
        if (object != null) {
            agentAlias = object.getString("ysq_agent_alias");
        }
        EsUtils.addAssetEsIndex((DynamicObject)assetObj, (String)"read", (String)agentAlias, (String)jobNo, (String)procCode, (Long)userId, (String)agentType, (String)"");
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        AssetVO assetVO = new AssetVO();
        assetVO.setAssetName(assetObj.getString("ysq_asset_name"));
        assetVO.setAssetValue(assetObj.getString("ysq_asset_value_tag"));
        assetVO.setAssetType(assetObj.getString("ysq_asset_type"));
        if (assetObj.getBoolean("ysq_is_client_edit")) {
            assetVO.setIsClientEdit("yes");
        } else {
            assetVO.setIsClientEdit("no");
        }
        if (assetObj.getBoolean("ysq_is_python_expr")) {
            assetVO.setIsPythonExpr("yes");
        } else {
            assetVO.setIsPythonExpr("no");
        }
        apiResult.setResult((Object)assetVO);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    public ApiResult editAsset(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        Long agentOrgFid = null;
        String agentNo = null;
        String agentType = null;
        if (commtoken != null && commtoken != "") {
            CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
            agentOrgFid = agent.getOrgFid();
            agentNo = agent.getAgentNo();
            agentType = agent.getAgentType();
        }
        if (agentOrgFid == null) {
            agentOrgFid = RequestContext.get().getOrgId();
        }
        AssetVO assetVO = new AssetVO();
        Map data = ctx.getData();
        assetVO.setAssetName(data.get("assetName").toString());
        assetVO.setAssetValue(data.get("assetValue").toString());
        assetVO.setJobNo(data.get("jobNo").toString());
        assetVO.setProcCode(data.get("procCode").toString());
        Long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("ysq_asset_name", "=", (Object)assetVO.getAssetName());
        DynamicObject assetObj = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_asset", (String)YsqAssetConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
        if (assetObj == null) {
            return ISearchApiResultVO.fail((String)"\u53d8\u91cf\u4e0d\u5b58\u5728", (Integer)1);
        }
        if (this.checkAssetOrg(assetObj, agentNo, agentOrgFid)) {
            return ISearchApiResultVO.fail((String)"\u5f53\u524d\u673a\u5668\u4eba\u6ca1\u6709\u8bbf\u95ee\u6b64\u53d8\u91cf\u7684\u6743\u9650", (Integer)1);
        }
        if (!assetObj.getBoolean("ysq_is_client_edit")) {
            return ISearchApiResultVO.fail((String)"\u53d8\u91cf\u4e0d\u5141\u8bb8\u4fee\u6539", (Integer)1);
        }
        String assetValue = assetObj.getString("ysq_asset_value_tag");
        StringBuilder esDetails = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)assetVO.getJobNo())) {
            long currUserId = RequestContext.get().getCurrUserId();
            ArrayList<Long> userIdList = new ArrayList<Long>();
            userIdList.add(currUserId);
            List maps = UserServiceHelper.get(userIdList);
            String name = ((Map)maps.get(0)).get("name").toString();
            esDetails.append("\u7528\u6237" + name + "\u4fee\u6539\"\u53d8\u91cf\u503c\"\u3002");
        } else {
            esDetails.append("\u4fee\u6539\"\u53d8\u91cf\u503c\"\u3002");
        }
        if (!"passwd".equals(assetObj.getString("ysq_asset_type"))) {
            esDetails.append("\u4fee\u6539\u524d\uff1a" + assetValue + ";\u4fee\u6539\u540e\uff1a" + assetVO.getAssetValue());
        }
        if ("passwd".equals(assetObj.getString("ysq_asset_type"))) {
            if ((long)assetVO.getAssetValue().length() > YsqAssetConstant.LIMIT_PWD_SIZE) {
                log.debug("\u53d8\u91cf\u5bc6\u7801\u957f\u5ea6100\u9650\u5236");
                return ISearchApiResultVO.fail((String)"\u53d8\u91cf\u5bc6\u7801\u957f\u5ea6100\u9650\u5236", (Integer)1);
            }
            assetValue = SecretUtil.desEncrypt((String)assetVO.getAssetValue());
            assetObj.set("ysq_asset_value", (Object)assetValue);
            assetObj.set("ysq_asset_value_tag", (Object)assetValue);
        } else {
            if ((long)assetVO.getAssetValue().length() > YsqAssetConstant.LIMIT_TEXT_SIZE) {
                log.debug("\u53d8\u91cf\u6587\u672c\u957f\u5ea64096\u9650\u5236");
                return ISearchApiResultVO.fail((String)"\u53d8\u91cf\u6587\u672c\u957f\u5ea64096\u9650\u5236", (Integer)1);
            }
            assetValue = assetVO.getAssetValue();
            if (assetValue.length() > 255) {
                String substring = assetValue.substring(0, 254);
                assetObj.set("ysq_asset_value", (Object)substring);
            } else {
                assetObj.set("ysq_asset_value", (Object)assetValue);
            }
            assetObj.set("ysq_asset_value_tag", (Object)assetValue);
        }
        QFilter robotNoQFilter = new QFilter("ysq_agent_no", "=", (Object)agentNo);
        QFilter agentTypeFilter = new QFilter("ysq_agent_no", "!=", (Object)RobotTypeEnums.STUDIO.getCode());
        DynamicObject object = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)"ysq_agent_alias", (QFilter[])new QFilter[]{robotNoQFilter, agentTypeFilter});
        String agentAlias = null;
        if (object != null) {
            agentAlias = object.getString("ysq_agent_alias");
        }
        EsUtils.addAssetEsIndex((DynamicObject)assetObj, (String)"edit", (String)agentAlias, (String)assetVO.getJobNo(), (String)assetVO.getProcCode(), (Long)userId, (String)agentType, (String)esDetails.toString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{assetObj});
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    private boolean checkAssetOrg(DynamicObject assetObj, String agentNo, Long robotOrgId) {
        String robotsNo = assetObj.getString("ysq_robots_no_tag");
        DynamicObject orgObj = (DynamicObject)assetObj.get("org");
        Long assetOrgId = orgObj.getLong(0);
        List assetOrgList = OrgServiceHelper.getChildOrg((long)assetOrgId);
        if (StringUtils.isNotEmpty((CharSequence)agentNo) && robotsNo.contains(agentNo)) {
            return false;
        }
        if (robotsNo.contains(RobotRangeEnums.DEPTALL.getCode()) && robotOrgId != null && assetOrgList.contains(robotOrgId)) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)agentNo) || assetOrgId == null || robotOrgId == null || !assetOrgList.contains(robotOrgId);
    }
}

