/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;

public class RobotActionApiPlugin
implements IBillWebApiPlugin {
    public static final String unbindURL = "/app/ysq_rpamc/unbind";
    public static final String modifyAliasURL = "/app/ysq_rpamc/modifyAlias";
    private RobotCache robotCache = RobotCache.getInstance();

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String url = ctx.getRequestURL();
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        if (ObjectUtils.isEmpty(commtoken)) {
            return ISearchApiResultVO.fail((String)"commtoken is none!", (Integer)1);
        }
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        switch (url) {
            case "/app/ysq_rpamc/unbind": {
                return this.unbind(ctx);
            }
            case "/app/ysq_rpamc/modifyAlias": {
                return this.modifyAlias(ctx);
            }
        }
        return ISearchApiResultVO.fail((String)"404", (Integer)1);
    }

    private ApiResult modifyAlias(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        Object agentAlias = ctx.getData().get("agentAlias");
        if (null == agentAlias) {
            return ISearchApiResultVO.fail((String)BaseVO.PARAMNONE, (Integer)1);
        }
        agent.setAgentAlias(agentAlias.toString());
        DynamicObject agentDb = agent.buildDynamicObject();
        SaveServiceHelper.update((DynamicObject)agentDb);
        this.robotCache.put(commtoken.toString(), agent);
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    private ApiResult unbind(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (commtoken != null) {
            String comtokenStr = commtoken.toString();
            QFilter commtokenFilter = new QFilter("ysq_comm_token", "=", (Object)comtokenStr);
            QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"robot");
            agentTypeFilter.or(new QFilter("ysq_agent_type", "=", (Object)"standardRobot"));
            QFilter[] filters = new QFilter[]{commtokenFilter, agentTypeFilter};
            DeleteServiceHelper.delete((String)"ysq_rpa_agent", (QFilter[])filters);
            this.robotCache.remove(commtoken.toString());
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }
}

