/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.task.AgentChangeTask;

public class RobotExitOutPlugin
implements IBillWebApiPlugin {
    private Log log = LogFactory.getLog(this.getClass());
    private RobotCache robotCache = RobotCache.getInstance();

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        Map param = ctx.getData();
        if (ObjectUtils.isEmpty(commtoken)) {
            return ISearchApiResultVO.fail((String)"commtoken is none!", (Integer)1);
        }
        String commToken = commtoken.toString();
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commToken);
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        new AgentChangeTask().doTask();
        QFilter[] filters = new QFilter[]{new QFilter("ysq_comm_token", "=", (Object)commToken)};
        DynamicObject agentDb = null;
        try {
            agentDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            agentDb = null;
        }
        if (null == agentDb) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        agent.setDataStatus(RoborDataStatusEnums.OFFLINE.getCode());
        agentDb.set("ysq_data_status", (Object)RoborDataStatusEnums.OFFLINE.getCode());
        SaveServiceHelper.update((DynamicObject)agentDb);
        this.robotCache.put(agent.getCommToken(), agent);
        return apiResult;
    }
}

