/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.utils.LicenseUtils;
import ysq.rpac.rpamc.common.utils.ObjectToMapListUtils;

public class RobotGetAliasAndOrgApiPlugin
implements IBillWebApiPlugin {
    private static Log log = LogFactory.getLog(RobotGetAliasAndOrgApiPlugin.class);

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        Map params = ctx.getData();
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return ISearchApiResultVO.fail((String)BaseVO.USERNONE, (Integer)1);
        }
        Map uservo = (Map)userInfoList.get(0);
        Object entryentity = uservo.get("entryentity");
        String username = uservo.get("username").toString();
        List list = ObjectToMapListUtils.castList(entryentity, Map.class);
        DynamicObject dpt = (DynamicObject)((Map)list.get(0)).get("dpt");
        String curOrgId = dpt.get("id").toString();
        String curOrgCode = dpt.get("number").toString();
        String curOrgname = dpt.get("name").toString();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (ObjectUtils.isNotEmpty((Object)username)) {
            result.put("username", username.toString());
        }
        QFilter agentFilter = null;
        if ("assistant".equals(params.get("agentType"))) {
            if (null != userId) {
                agentFilter = new QFilter("ysq_agent_no", "=", (Object)userId.toString());
            }
            Object typeObj = params.get("agentType");
            QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)typeObj.toString());
            QFilter[] filters = new QFilter[]{agentFilter, agentTypeFilter};
            DynamicObject agent = null;
            try {
                agent = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
                if (null == agent) {
                    return ISearchApiResultVO.fail((String)BaseVO.USER_NO_APPLY_ASSISTANT, (Integer)1);
                }
                result.put("id", agent.get("id").toString());
                result.put("agentAlias", agent.getString("ysq_agent_alias"));
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                return ISearchApiResultVO.fail((String)BaseVO.USER_NO_APPLY_ASSISTANT, (Integer)1);
            }
            this.setOrg(agent, curOrgId, curOrgCode, curOrgname, result);
        } else {
            Object dcodeObj = params.get("agentDcode");
            if (null != dcodeObj) {
                agentFilter = new QFilter("ysq_agent_no", "=", (Object)dcodeObj.toString());
            }
            QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"robot");
            QFilter[] filters = new QFilter[]{agentFilter, agentTypeFilter};
            try {
                DynamicObject agentRobot = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
                if (null == agentRobot) {
                    result.put("agentAlias", params.get("agentDcode"));
                } else {
                    result.put("agentAlias", agentRobot.getString("ysq_agent_alias"));
                    result.put("id", agentRobot.get("id").toString());
                    this.setOrg(agentRobot, curOrgId, curOrgCode, curOrgname, result);
                }
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
            agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"standardRobot");
            filters = new QFilter[]{agentFilter, agentTypeFilter};
            try {
                DynamicObject agentCommon = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
                if (null == agentCommon) {
                    result.put("agentAliasCommon", params.get("agentDcode"));
                } else {
                    result.put("agentAliasCommon", agentCommon.getString("ysq_agent_alias"));
                    result.put("id", agentCommon.get("id").toString());
                    this.setOrg(agentCommon, curOrgId, curOrgCode, curOrgname, result);
                }
            }
            catch (Exception e) {
                log.debug(e.getMessage());
            }
            result.put("canUseRobot", LicenseUtils.remainingLicCheck((String)"robot"));
            result.put("canUseApp", LicenseUtils.remainingCsLicCheck());
        }
        result.put("loginMode", "cloud");
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult(result);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    private void setOrg(DynamicObject agent, String curOrgId, String curOrgCode, String curOrgname, Map<String, Object> result) {
        String orgCode = "";
        String orgName = "";
        String orgId = "";
        if (ObjectUtils.isNotEmpty((Object)agent.get("org"))) {
            DynamicObject orgq = agent.getDynamicObject("org");
            orgId = orgq.getString("id");
            orgCode = orgq.getString("number");
            orgName = orgq.getString("name");
        }
        result.put("orgId", StringUtils.isEmpty((CharSequence)orgId) ? curOrgId : orgId);
        result.put("orgCode", StringUtils.isEmpty((CharSequence)orgCode) ? curOrgCode : orgCode);
        result.put("curOrgName", StringUtils.isEmpty((CharSequence)orgName) ? curOrgname : orgName);
    }
}

