/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.ApiParamsEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.model.rpai.BaseRapiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;

public class RobotHeartApiPlugin
implements IBillWebApiPlugin {
    private static Log log = LogFactory.getLog(RobotHeartApiPlugin.class);

    public String getVersion() {
        return "2.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResult doCustomService(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        Map param = ctx.getData();
        if (ObjectUtils.isEmpty(commtoken)) {
            return ISearchApiResultVO.fail((String)"commtoken is none!", (Integer)1);
        }
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        String dataStatus = MapUtils.getString((Map)param, (Object)ApiParamsEnums.DATA_STATUS.getParamKey());
        String jobNo = MapUtils.getString((Map)param, (Object)ApiParamsEnums.JOB_NO.getParamKey());
        if (StringUtils.isBlank((CharSequence)dataStatus)) {
            return ISearchApiResultVO.fail((String)BaseVO.RPA_STATUS_NULL, (Integer)1);
        }
        if (!RoborDataStatusEnums.FREE.getCode().equals(dataStatus) && !RoborDataStatusEnums.RUNNING.getCode().equals(dataStatus)) {
            return ISearchApiResultVO.fail((String)BaseVO.RPA_STATUS_ERROR, (Integer)1);
        }
        DLock lock = DLock.create((String)(RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + RedisLockKeysEnums.KEY_SPLIT_LOCK.getKey() + RedisLockKeysEnums.ROBOT_HEART_HEAD.getKey() + agent.getExtendAgentNo()));
        BaseRapiResultVO result = null;
        try {
            if (lock.tryLock()) {
                result = AgentServiceHelper.robotsHeartNew((CdaAgentVO)agent, (String)dataStatus, (String)jobNo);
            } else {
                result = new BaseRapiResultVO();
                result.setAction("nothing");
                log.debug("\u5fc3\u8df3\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a" + agent.getExtendAgentNo());
            }
        }
        catch (Exception e) {
            log.error("\u5fc3\u8df3\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            lock.unlock();
            lock.close();
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)result);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }
}

