/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;

public class RobotInfoApiPlugin
implements IBillWebApiPlugin {
    public static final String queryAssistAliasURL = "/app/ysq_rpamc/queryAssistAlias";
    public static final String proclistURL = "/app/ysq_rpamc/proclist";
    public static final String deptListURL = "/app/ysq_rpamc/deptList";
    public static final String checktokenURL = "/app/ysq_rpamc/checktoken";
    public static final String runParam = "/app/ysq_rpamc/runParam";
    private static String proc_run_mode = "proc_run_mode";
    private static String is_start_up = "is_start_up";
    protected Log log = LogFactory.getLog(this.getClass());

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String url = ctx.getRequestURL();
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        if (ObjectUtils.isEmpty(commtoken)) {
            return ISearchApiResultVO.fail((String)"commtoken is none!", (Integer)1);
        }
        switch (url) {
            case "/app/ysq_rpamc/queryAssistAlias": {
                return this.queryAssistAlias(ctx);
            }
            case "/app/ysq_rpamc/proclist": {
                return this.proclist(ctx);
            }
            case "/app/ysq_rpamc/deptList": {
                return this.deptList(ctx);
            }
            case "/app/ysq_rpamc/checktoken": {
                return this.checktoken(ctx);
            }
            case "/app/ysq_rpamc/runParam": {
                return this.procInfo(ctx);
            }
        }
        return ISearchApiResultVO.fail((String)"404", (Integer)1);
    }

    private ApiResult checktoken(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.COMMTOKEN_UNUSE, (Integer)4010);
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)agent.getAgentAlias());
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.COMMTOKEN_USE);
        return apiResult;
    }

    private ApiResult deptList(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)agent.getAgentAlias());
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    public ApiResult queryAssistAlias(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)agent.getAgentAlias());
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    public ApiResult proclist(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        CdaAgentVO cdaAgent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == cdaAgent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(cdaAgent.getOrgFid());
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List parentIds = orgService.getAllSubordinateOrgs(Long.valueOf(1L), orgIds, true);
        QFilter processFilter = new QFilter("org", "in", (Object)parentIds);
        QFilter commonFilter = new QFilter("ysq_proc_type", "!=", (Object)"standard");
        QFilter[] processFilters = new QFilter[]{processFilter, commonFilter};
        DynamicObject[] processList = BusinessDataServiceHelper.load((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])processFilters);
        ArrayList resultList = new ArrayList();
        for (DynamicObject proc : processList) {
            try {
                String url;
                HashMap<String, Object> onePorcVer = new HashMap<String, Object>();
                onePorcVer.put("proc_name", proc.getString("ysq_proc_name"));
                onePorcVer.put("proc_code", proc.getString("ysq_proc_code"));
                QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)proc.getString("ysq_proc_code")), new QFilter("ysq_proc_ver", "=", (Object)proc.getString("ysq_proc_ver"))};
                DynamicObject processVerDb = null;
                processVerDb = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr);
                List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process", (Object)proc.getLong("id"), (String)"attachmentpanel");
                if (attachmentpanel.size() > 0) {
                    onePorcVer.put("proc_file", "/doc/ipkg/" + proc.getLong("id") + ".ipkg");
                    url = ((Map)attachmentpanel.get(0)).get("url").toString();
                    onePorcVer.put("file_url", url);
                } else {
                    attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process_ver", (Object)processVerDb.getLong("id"), (String)"attachmentpanel");
                    if (attachmentpanel.size() <= 0) continue;
                    onePorcVer.put("proc_file", "/doc/ipkg/" + processVerDb.getLong("id") + ".ipkg");
                    url = ((Map)attachmentpanel.get(0)).get("url").toString();
                    onePorcVer.put("file_url", url);
                }
                onePorcVer.put("proc_ver", proc.getString("ysq_proc_ver"));
                onePorcVer.put("publish", proc.getString("ysq_publish_time"));
                onePorcVer.put("proc_run_mode", "all");
                onePorcVer.put("is_assistant", proc.getBoolean("ysq_is_assistant"));
                onePorcVer.put("is_start_up", proc.getBoolean("ysq_is_start_up"));
                onePorcVer.put("proc_desc", proc.getString("ysq_proc_desc"));
                resultList.add(onePorcVer);
            }
            catch (Exception e) {
                this.log.info("\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f\u5f02\u5e38\u3002" + e.getMessage() + proc.toString());
            }
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult(resultList);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    public ApiResult procInfo(WebApiContext ctx) {
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        Map data = ctx.getData();
        Object procCodeObj = data.get("procCode");
        Object procVerObj = data.get("procVer");
        String baseParams = "";
        if (procCodeObj != null && procVerObj != null) {
            String procCode = procCodeObj.toString();
            String procVer = procVerObj.toString();
            if (StringUtils.isNotBlank((CharSequence)procCode) && StringUtils.isNotBlank((CharSequence)procVer)) {
                QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
                QFilter procVerFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
                DynamicObjectCollection procInfos = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter, procVerFilter});
                if (CollectionUtils.isNotEmpty((Collection)procInfos)) {
                    DynamicObject dynamicObject = (DynamicObject)procInfos.get(0);
                    String param = dynamicObject.getString("ysq_param_tag");
                    JSONArray jsonArray = JSONArray.parseArray((String)param);
                    JSONObject paramsJson = new JSONObject();
                    paramsJson.put("Inputs", (Object)jsonArray);
                    param = JSONObject.toJSONString((Object)paramsJson);
                    if (StringUtils.isNotBlank((CharSequence)param)) {
                        baseParams = IsearchFileUtils.paramsBase64((String)param);
                    }
                }
            }
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)baseParams);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }
}

