/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.ApiParamsEnums;
import ysq.rpac.rpamc.common.enums.QueueItemStatusEnums;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.HandSaveJobVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentProcessServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.status.redo.JobRedoOffer;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class RobotProcessApiPlugin
implements IBillWebApiPlugin {
    private static Log log = LogFactory.getLog(RobotProcessApiPlugin.class);
    public static final String runURL = "/app/ysq_rpamc/run";
    public static final String jobresultURL = "/app/ysq_rpamc/jobresult";
    public static final String handSaveJobURL = "/app/ysq_rpamc/handSaveJob";
    private RobotCache robotCache = RobotCache.getInstance();

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String url = ctx.getRequestURL();
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        if (ObjectUtils.isEmpty(commtoken)) {
            return ISearchApiResultVO.fail((String)"commtoken is none!", (Integer)1);
        }
        switch (url) {
            case "/app/ysq_rpamc/run": {
                return this.run(ctx);
            }
            case "/app/ysq_rpamc/handSaveJob": {
                return this.handSaveJob(ctx, commtoken.toString());
            }
            case "/app/ysq_rpamc/jobresult": {
                return this.jobresult(ctx, commtoken.toString());
            }
        }
        return ISearchApiResultVO.fail((String)"404", (Integer)1);
    }

    private ApiResult jobresult(WebApiContext ctx, String commToken) {
        Map params = ctx.getData();
        String jobNo = MapUtils.getString((Map)params, (Object)ApiParamsEnums.JOB_NO.getParamKey());
        String result = MapUtils.getString((Map)params, (Object)ApiParamsEnums.RESULT.getParamKey());
        String resultDesc = MapUtils.getString((Map)params, (Object)ApiParamsEnums.RESULT_DESC.getParamKey());
        String procEndTime = MapUtils.getString((Map)params, (Object)ApiParamsEnums.PROC_END_TIME.getParamKey());
        String procStartTime = MapUtils.getString((Map)params, (Object)ApiParamsEnums.PROC_START_TIME.getParamKey());
        String exceName = MapUtils.getString((Map)params, (Object)ApiParamsEnums.EXCE_NAME.getParamKey());
        String exceDesc = MapUtils.getString((Map)params, (Object)ApiParamsEnums.EXCE_DESC.getParamKey());
        if (StringUtils.isBlank((CharSequence)exceName)) {
            exceName = null;
        }
        if (StringUtils.isBlank((CharSequence)exceDesc)) {
            exceDesc = null;
        } else if (exceDesc.length() > 2000) {
            exceDesc = exceDesc.substring(0, 2000);
        }
        if (StringUtils.isEmpty((CharSequence)commToken)) {
            return ISearchApiResultVO.fail((String)BaseVO.PARAMNONE, (Integer)1);
        }
        CdaAgentVO cdaAgent = AgentServiceHelper.checkCommonToken((String)commToken);
        if (null == cdaAgent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        if (StringUtils.isEmpty((CharSequence)jobNo)) {
            return ISearchApiResultVO.fail((String)BaseVO.RPA_JOB_CODE_ISNULL);
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return ISearchApiResultVO.fail((String)BaseVO.RPA_JOB_RUN_ISNULL);
        }
        if (!(result.equals(RpaJobStatusEnums.PENDING.getCode()) || result.equals(RpaJobStatusEnums.RUNNING.getCode()) || result.equals(RpaJobStatusEnums.STOPPING.getCode()) || result.equals(RpaJobStatusEnums.SUCCESS.getCode()) || result.equals(RpaJobStatusEnums.FAILED.getCode()) || result.equals(RpaJobStatusEnums.STOPPED.getCode()) || result.equals(RpaJobStatusEnums.CANCELLED.getCode()) || result.equals(RpaJobStatusEnums.PEND_OUTTIME.getCode()) || result.equals(RpaJobStatusEnums.RUN_OUTTIME.getCode()))) {
            return ISearchApiResultVO.fail((String)BaseVO.RPA_JOB_RUN_NO);
        }
        this.robotCache.put(commToken, cdaAgent);
        if (StringUtils.isNotEmpty((CharSequence)resultDesc) && resultDesc.length() > 254) {
            return ISearchApiResultVO.fail((String)BaseVO.RPA_JOB_RUN_DESC_LONG);
        }
        if (StringUtils.isNotEmpty((CharSequence)procEndTime)) {
            try {
                DateUtils.parseDate((String)procEndTime);
            }
            catch (Exception e) {
                return ISearchApiResultVO.fail((String)BaseVO.RPA_JOB_RUN_ENDTIME_ERR, (Integer)1);
            }
        }
        QFilter rpaJobFilter = new QFilter("ysq_job_no", "=", (Object)jobNo);
        QFilter[] filters = new QFilter[]{rpaJobFilter};
        DynamicObject rpaJob = null;
        try {
            rpaJob = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])filters);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            rpaJob = null;
        }
        if (null == rpaJob) {
            return ISearchApiResultVO.fail((String)BaseVO.JOB_NOT_EXITS, (Integer)1);
        }
        AgentProcessServiceHelper.robotsJobResult((CdaAgentVO)cdaAgent, (DynamicObject)rpaJob, (String)result, (String)resultDesc, (String)procEndTime, (String)procStartTime, (String)exceName, (String)exceDesc);
        rpaJob.set("ysq_status", (Object)result);
        if (RpaJobStatusEnums.FAILED.getCode().equals(result)) {
            JobRedoOffer.getInstance().addDatas(rpaJob);
        }
        return ISearchApiResultVO.ok();
    }

    private ApiResult run(WebApiContext ctx) {
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return ISearchApiResultVO.fail((String)BaseVO.USERNONE, (Integer)1);
        }
        Map user = (Map)userInfoList.get(0);
        Object commtoken = ctx.getRequestHeaders().get("commtoken");
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commtoken.toString());
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
        }
        Map data = ctx.getData();
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)AgentProcessServiceHelper.run((Map)user, (CdaAgentVO)agent, (String)data.get("procCode").toString(), (String)data.get("procVer").toString()));
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    private ApiResult handSaveJob(WebApiContext ctx, String commToken) {
        DynamicObject job;
        CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commToken);
        Map data = ctx.getData();
        HandSaveJobVO handSaveJobVo = new HandSaveJobVO();
        handSaveJobVo.setJob_no(data.get("job_no").toString());
        handSaveJobVo.setProc_code(data.get("proc_code").toString());
        handSaveJobVo.setProc_ver(data.get("proc_ver").toString());
        handSaveJobVo.setStart_time(data.get("start_time").toString());
        if (StringUtils.isBlank((CharSequence)handSaveJobVo.getProc_code())) {
            return ISearchApiResultVO.fail((String)ResultStatusEnums.PROCVERS_PROCCODE_NULL.getCodeMsg(), (Integer)ResultStatusEnums.PROCVERS_PROCCODE_NULL.getCode());
        }
        String agentType = agent.getAgentType();
        if (agentType.equals("standardRobot") && !LicenseUtils.checkStdAppLicense((String)handSaveJobVo.getProc_code()).booleanValue()) {
            return ISearchApiResultVO.fail((String)"\u65e0\u53ef\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u7ba1\u7406\u5458\u3002", (Integer)ResultStatusEnums.LIC_PLATFORM_NO_LICENSE.getCode());
        }
        if (StringUtils.isBlank((CharSequence)handSaveJobVo.getProc_ver())) {
            QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)handSaveJobVo.getProc_code())};
            DynamicObject[] processVerArr = BusinessDataServiceHelper.load((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr, (String)"id asc");
            if (null != processVerArr && processVerArr.length > 0) {
                handSaveJobVo.setProc_ver(processVerArr[0].getString("ysq_proc_ver"));
            }
        }
        if (null == (job = AgentProcessServiceHelper.saveJob((HandSaveJobVO)handSaveJobVo, (CdaAgentVO)agent))) {
            return ISearchApiResultVO.fail((String)"\u6d41\u7a0b\u4e0d\u5b58\u5728", (Integer)ResultStatusEnums.PROC_NOT_EXIT.getCode());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job});
        if (agent != null && StringUtils.isNotBlank((CharSequence)agent.getAgentUncode())) {
            agent.setDataStatus(RoborDataStatusEnums.RUNNING.getCode());
            SaveServiceHelper.update((DynamicObject)agent.buildDynamicObject());
            this.robotCache.put(agent.getCommToken(), agent);
        }
        this.sendStatusToKD(job);
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)job);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    private void sendStatusToKD(DynamicObject job) {
        try {
            String procName = job.getString("ysq_proc_name");
            String procVer = job.getString("ysq_proc_ver");
            Long jobId = job.getLong("id");
            String jobStatus = QueueItemStatusEnums.RUNNING.getCode();
            JSONObject data = new JSONObject();
            data.put("rpa_processname", (Object)procName);
            data.put("rpa_processversion", (Object)procVer);
            data.put("rpa_taskid", (Object)jobId);
            data.put("rpa_status", (Object)jobStatus);
            EventServiceHelper.triggerEventSubscribe((String)"RPA_status_event", (String)data.toJSONString());
            log.info("\u6d41\u7a0b\uff1a{}\uff0cjobNO:{}\u5f00\u59cb\u624b\u52a8\u8fd0\u884c\u3002", (Object)procName, (Object)jobId);
        }
        catch (Exception e) {
            log.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
    }
}

