/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.enums.HkWinStatusEnums;
import ysq.rpac.rpamc.common.enums.RedisLockKeysEnums;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class RobotSaveApiPlugin
implements IBillWebApiPlugin {
    private static Log log = LogFactory.getLog(RobotSaveApiPlugin.class);

    public String getVersion() {
        return "2.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResult doCustomService(WebApiContext ctx) {
        Map rpaRobot;
        Long userId = RequestContext.get().getCurrUserId();
        Map params = ctx.getData();
        String agentType = params.get("agentType").toString();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return ISearchApiResultVO.fail((String)BaseVO.USERNONE, (Integer)1);
        }
        Map user = (Map)userInfoList.get(0);
        String userName = user.get("username").toString();
        QFilter agentFilter = null != params.get("id") && !"".equals(params.get("id").toString()) ? new QFilter("id", "=", (Object)Long.parseLong(params.get("id").toString())) : new QFilter("ysq_agent_dcode", "=", (Object)params.get("agentDcode").toString());
        QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)agentType);
        if (agentType.equals("standardRobot") || agentType.equals("robot")) {
            ArrayList<String> types = new ArrayList<String>();
            types.add("standardRobot");
            types.add("robot");
            agentTypeFilter = new QFilter("ysq_agent_type", "in", types);
        }
        QFilter[] filters = new QFilter[]{agentFilter, agentTypeFilter};
        String feild = YsqAgentConstant.selAllFileds();
        DynamicObject agent = null;
        try {
            agent = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)feild, (QFilter[])filters);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            agent = null;
        }
        if (null == agent) {
            if ("assistant".equals(params.get("agentType"))) {
                return ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1);
            }
            if (!LicenseUtils.remainingLicCheck((String)params.get("agentType").toString())) {
                return ISearchApiResultVO.fail((String)BaseVO.NO_LIS, (Integer)1);
            }
            agent = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_agent");
            agent.set("creator", (Object)userId);
        }
        agent.set("ysq_access_token", ctx.getRequestHeaders().get("access_token"));
        if ("robot".equals(params.get("agentType")) || "standardRobot".equals(params.get("agentType"))) {
            agent.set("ysq_agent_no", params.get("agentDcode"));
        }
        agent.set("ysq_rpa_user_name", (Object)userName);
        agent.set("ysq_status", (Object)"yes");
        agent.set("ysq_win_status", (Object)HkWinStatusEnums.UNBIND.getCode());
        agent.set("ysq_agent_type", params.get("agentType"));
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        DLock lock = DLock.create((String)(RedisLockKeysEnums.KEY_HEAD.getKey() + RequestContext.get().getAccountId() + RedisLockKeysEnums.KEY_SPLIT_LOCK.getKey() + RedisLockKeysEnums.ROBOT_HEART_HEAD.getKey() + "RobotSaveApiPlugin" + userId));
        try {
            lock.lock();
            rpaRobot = AgentServiceHelper.saveAgent((DynamicObject)agent, (Map)user, (Map)params);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            apiResult.setCode(Integer.valueOf(1));
            apiResult.setMsg(e.getMessage());
            ISearchApiResultVO iSearchApiResultVO = apiResult;
            return iSearchApiResultVO;
        }
        finally {
            lock.unlock();
            lock.close();
        }
        apiResult.setResult((Object)rpaRobot);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }
}

