/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;

public class StudioInfoApiPlugin
implements IBillWebApiPlugin {
    public static final String checklicURL = "/app/ysq_rpamc/checklic";
    public static final String userInfoURL = "/app/ysq_rpamc/userInfo";

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String url;
        switch (url = ctx.getRequestURL()) {
            case "/app/ysq_rpamc/userInfo": {
                return this.userInfo(ctx);
            }
            case "/app/ysq_rpamc/checklic": {
                return this.checklic(ctx);
            }
        }
        return ISearchApiResultVO.fail((String)"404", (Integer)1);
    }

    private ApiResult userInfo(WebApiContext ctx) {
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return ISearchApiResultVO.fail((String)BaseVO.USER_NO_APPLY_STUDIO, (Integer)1);
        }
        Map user = (Map)userInfoList.get(0);
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", userId);
        result.put("userName", user.get("username").toString());
        apiResult.setResult(result);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    private ApiResult checklic(WebApiContext ctx) {
        Long userId = RequestContext.get().getCurrUserId();
        QFilter agentFilter = new QFilter("ysq_agent_no", "=", (Object)userId.toString());
        QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
        QFilter[] filters = new QFilter[]{agentFilter, agentTypeFilter};
        DynamicObject agent = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.NO_LIS, (Integer)1);
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)userId);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }
}

