/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.ProcessServiceHelper;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class StudioProcessApiPlugin
implements IBillWebApiPlugin {
    private static Log log = LogFactory.getLog(StudioProcessApiPlugin.class);
    public static final String upprocURL = "/app/ysq_rpamc/upproc";
    public static final String processUploadURL = "/app/ysq_rpamc/processUpload";
    public static final String processUploadCheckURL = "/app/ysq_rpamc/upprocCheck";

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String url;
        Long userId = RequestContext.get().getCurrUserId();
        QFilter agentFilter = new QFilter("ysq_agent_no", "=", (Object)userId.toString());
        QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
        QFilter[] filters = new QFilter[]{agentFilter, agentTypeFilter};
        DynamicObject agent = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])filters);
        if (null == agent) {
            return ISearchApiResultVO.fail((String)BaseVO.NO_LIS, (Integer)1);
        }
        switch (url = ctx.getRequestURL()) {
            case "/app/ysq_rpamc/upproc": {
                return this.upproc(ctx);
            }
            case "/app/ysq_rpamc/processUpload": {
                return this.upproc(ctx);
            }
            case "/app/ysq_rpamc/upprocCheck": {
                return this.processUploadCheck(ctx);
            }
        }
        return ISearchApiResultVO.fail((String)"404", (Integer)1);
    }

    public ApiResult upproc(WebApiContext ctx) {
        String version;
        QFilter versionFilter;
        String procCode;
        QFilter procCodeFilter;
        QFilter[] procFilter;
        boolean exists;
        Map data = ctx.getQueryString();
        long procVerId = ID.genLongId();
        String fileName = UUID.randomUUID().toString().replace("-", "") + ".ipkg";
        ArrayList attachments = new ArrayList();
        HashMap<String, String> attach = new HashMap<String, String>();
        attach.put("uid", AttachmentServiceHelper.generateUid());
        attach.put("name", (String)data.get("name"));
        attach.put("size", (String)data.get("size"));
        attach.put("url", (String)data.get("url"));
        attachments.add(attach);
        AttachmentServiceHelper.upload((String)"ysq_rpa_process_ver", (Object)procVerId, (String)"attachmentpanel", attachments);
        List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_process_ver", (Object)procVerId, (String)"attachmentpanel");
        String url = ((Map)attachmentpanel.get(0)).get("url").toString();
        Map<String, Object> map = this.urlToStream(url);
        if (ObjectUtils.isNotEmpty((Object)map.get("proName")) && ObjectUtils.isNotEmpty((Object)map.get("proCode"))) {
            String proName = map.get("proName").toString();
            String proCode = map.get("proCode").toString();
            if (ProcessServiceHelper.checkProcName((String)proCode, (String)proName)) {
                if ((proName = proName + "_" + ID.genLongId()).length() > 64) {
                    proName = proName.substring(proName.length() - 64);
                }
                map.put("proName", proName);
            }
        }
        try {
            ProcessServiceHelper.saveProcessMultiVersion(map, (long)procVerId, (String)fileName, (String)("/doc/ipkg/" + UUID.randomUUID() + ".ipkg"));
        }
        catch (KDException e) {
            return ISearchApiResultVO.fail((String)e.getMessage(), (Integer)1);
        }
        if (map != null && (exists = QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])(procFilter = new QFilter[]{procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)(procCode = map.get("proCode").toString())), versionFilter = new QFilter("ysq_proc_ver", "=", (Object)(version = map.get("proVersion").toString()))})))) {
            this.cancle(procCode, version);
        }
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        apiResult.setResult((Object)procVerId);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    public ApiResult processUploadCheck(WebApiContext ctx) {
        Map data = ctx.getQueryString();
        this.checkParams(data);
        String procCode = data.get("procCode").toString();
        String proVer = data.get("procVer").toString();
        int resultCode = 0;
        Long userId = RequestContext.get().getCurrUserId();
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter procVerFilter = new QFilter("ysq_proc_ver", "=", (Object)proVer);
        QFilter[] filters = new QFilter[]{procCodeFilter};
        DynamicObject proc = null;
        try {
            proc = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])filters);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            proc = null;
        }
        if (proc != null) {
            if (!UserUtils.getDptId().equals(proc.getDynamicObject("org").getLong("id"))) {
                resultCode = 1;
            } else {
                DynamicObject versionModel = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{procVerFilter, procCodeFilter});
                if (versionModel != null) {
                    resultCode = 2;
                }
            }
        }
        apiResult.setResult((Object)resultCode);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }

    private void checkParams(Map<String, Object> map) {
        Object procCodeObj = map.get("procCode");
        Object proVerObj = map.get("procVer");
        if (procCodeObj == null) {
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u4e3a\u7a7a");
        }
        String procCodeStr = procCodeObj.toString();
        if (StringUtils.isBlank((CharSequence)procCodeStr)) {
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (proVerObj == null) {
            throw new KDException("\u6d41\u7a0b\u7248\u672c\u4e3a\u7a7a");
        }
        String proVerStr = proVerObj.toString();
        if (StringUtils.isBlank((CharSequence)proVerStr)) {
            throw new KDException("\u6d41\u7a0b\u7248\u672c\u4e3a\u7a7a");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> urlToStream(String url) {
        InputStream inStream = null;
        Map map = null;
        try {
            URL path = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)path.openConnection();
            inStream = conn.getInputStream();
            map = IsearchFileUtils.readIpkgFile((InputStream)inStream);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            }
        }
        return map;
    }

    private void cancle(String procCode, String version) {
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter versionFilter = new QFilter("ysq_proc_ver", "=", (Object)version);
        QFilter statusFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
        DynamicObject[] jobs = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter, statusFilter, versionFilter});
        if (jobs != null && jobs.length > 0) {
            for (DynamicObject job : jobs) {
                String jobNo = job.getString("ysq_job_no");
                Long jobId = job.getLong("id");
                boolean isExist = RobotPendingJobProducer.getInstance().checkHasJob(jobNo, null);
                if (isExist) {
                    log.info("\u4efb\u52a1\u5df2\u88ab\u9886\u53d6\uff0c\u4ec5\u7b49\u5f85\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u53d6\u6d88\u64cd\u4f5c\u3002");
                    continue;
                }
                boolean b = JobStatusCache.getInstance().handChacheStatusCheck(jobId, jobNo, RpaJobStatusEnums.PENDING.getCode(), this.getClass().getName());
                if (b) {
                    log.info("\u4fee\u6539\u52a8\u4f5c\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002");
                    continue;
                }
                try {
                    JobStatusCache.getInstance().handChacheStatus(jobId, jobNo, RpaJobStatusEnums.CANCELLED.getCode(), this.getClass().getName());
                }
                catch (Exception e) {
                    log.debug("exc: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u63d0\u4ea4\uff0c\u672c\u6b21\u4e0d\u63d0\u4ea4\u961f\u5217\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, jobNo, RpaJobStatusEnums.CANCELLED.getCode(), new Date()});
                }
            }
        }
    }
}

