/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;

public class StudioSaveApiPlugin
implements IBillWebApiPlugin {
    private static Log log = LogFactory.getLog(StudioSaveApiPlugin.class);

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        Map params = ctx.getData();
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            return ISearchApiResultVO.fail((String)BaseVO.USERNONE, (Integer)1);
        }
        Map user = (Map)userInfoList.get(0);
        QFilter agentNoFilter = new QFilter("ysq_agent_no", "=", (Object)userId.toString());
        QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
        QFilter[] filters = new QFilter[]{agentNoFilter, agentTypeFilter};
        String feild = YsqAgentConstant.selAllFileds();
        DynamicObject agent = null;
        ISearchApiResultVO apiResult = new ISearchApiResultVO();
        try {
            agent = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)feild, (QFilter[])filters);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            apiResult.setCode(Integer.valueOf(1));
            apiResult.setMsg(e.getMessage());
            return apiResult;
        }
        if (ObjectUtils.isEmpty((Object)agent)) {
            return ISearchApiResultVO.fail((String)BaseVO.USER_NO_APPLY_STUDIO, (Integer)1);
        }
        agent.set("ysq_access_token", ctx.getRequestHeaders().get("access_token"));
        Map rpaRobot = new HashMap();
        try {
            rpaRobot = AgentServiceHelper.saveAgent((DynamicObject)agent, (Map)user, (Map)params);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            apiResult.setCode(Integer.valueOf(1));
            apiResult.setMsg(e.getMessage());
            return apiResult;
        }
        apiResult.setResult(rpaRobot);
        apiResult.setCode(Integer.valueOf(0));
        apiResult.setMsg(BaseVO.SUCCESS);
        return apiResult;
    }
}

