/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.api.oapi.impl;

import com.alibaba.fastjson.JSONArray;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.api.oapi.RpaService;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.model.response.KingRpaJobRes;
import ysq.rpac.rpamc.common.utils.CronExpressionUtils;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.IpkgUtils;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.LicenseUtils;
import ysq.rpac.rpamc.common.utils.ObjectToMapListUtils;
import ysq.rpac.rpamc.common.utils.ProcVerComparator;
import ysq.rpac.rpamc.common.utils.ScheduleUtils;
import ysq.rpac.rpamc.common.utils.StringUtil;
import ysq.rpac.rpamc.common.utils.TriggerTimeUtils;

public class RpaSercviceImpl
implements RpaService {
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();
    private static Log log = LogFactory.getLog(RpaSercviceImpl.class);

    @Override
    public List<Map<String, Object>> getProcessList(Map<String, Object> param) {
        DynamicObject[] query;
        Object procDescObj;
        Object procVerObj;
        Object procNameObj;
        ArrayList<Map<String, Object>> rtList = new ArrayList<Map<String, Object>>();
        Object userIdObj = param.get("userId");
        if (userIdObj == null || new Long(0L).equals(userIdObj)) {
            throw new KDException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Long userId = 0L;
        try {
            userId = Long.valueOf(userIdObj.toString());
        }
        catch (Exception e) {
            log.error("\u7528\u6237ID\u9519\u8bef");
            throw new KDException("\u7528\u6237ID\u9519\u8bef");
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            log.error("\u90e8\u95e8\u4e0d\u5b58\u5728");
            throw new KDException("\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        Map uservo = (Map)userInfoList.get(0);
        Object entryentity = uservo.get("entryentity");
        if (ObjectUtils.isEmpty(entryentity)) {
            log.error("\u7528\u6237\u90e8\u95e8\u4e3a\u7a7a");
            return rtList;
        }
        List list = ObjectToMapListUtils.castList(entryentity, Map.class);
        DynamicObject dpt = (DynamicObject)((Map)list.get(0)).get("dpt");
        String curOrgId = dpt.get("id").toString();
        if (StringUtils.isBlank((CharSequence)curOrgId)) {
            log.error("\u7528\u6237\u90e8\u95e8\u4e3a\u7a7a");
            return rtList;
        }
        String appIdName = "ysq_rpamc";
        String entityNum = "ysq_rpa_process";
        String appId = AppMetadataCache.getAppInfo((String)appIdName).getId();
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)appId, (String)entityNum, (String)"47156aff000000ac");
        QFilter orgFilter = allPermOrgs.hasAllOrgPerm() ? new QFilter("1", "=", (Object)1) : new QFilter("org", "in", (Object)allPermOrgs.getHasPermOrgs());
        Object procObj = param.get("procCode");
        if (ObjectUtils.isNotEmpty((Object)procObj)) {
            String proc = procObj.toString();
            orgFilter.and(new QFilter("ysq_proc_code", "like", (Object)("%" + proc + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)(procNameObj = param.get("procName")))) {
            String procName = procNameObj.toString();
            orgFilter.and(new QFilter("ysq_proc_name", "like", (Object)("%" + procName + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)(procVerObj = param.get("procVer")))) {
            String procVer = procVerObj.toString();
            orgFilter.and(new QFilter("ysq_proc_ver", "like", (Object)("%" + procVer + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)(procDescObj = param.get("procDesc")))) {
            String procDesc = procDescObj.toString();
            orgFilter.and(new QFilter("ysq_proc_desc", "like", (Object)("%" + procDesc + "%")));
        }
        orgFilter.and(new QFilter("ysq_proc_type", "=", (Object)"common"));
        for (DynamicObject dynamicObject : query = BusinessDataServiceHelper.load((String)"ysq_rpa_process", (String)(YsqProcessConstant.selAllFileds() + "," + "createtime" + "," + "modifytime"), (QFilter[])new QFilter[]{orgFilter})) {
            Map<String, Object> process = this.paramsEnca(dynamicObject);
            String procCode = dynamicObject.getString("ysq_proc_code");
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            codeFilter.and(new QFilter("ysq_work_status", "=", (Object)"release"));
            DynamicObjectCollection procVerList = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
            if (procVerList.size() <= 0) continue;
            Collections.sort(procVerList, new ProcVerComparator());
            process.put("procVer", ((DynamicObject)procVerList.get(0)).getString("ysq_proc_ver"));
            rtList.add(process);
        }
        return rtList;
    }

    @Override
    public String addTask(Map<String, Object> param) {
        QFilter procCodeFileter;
        Object procCodeObj = param.get("procCode");
        Object procVerObj = param.get("procVer");
        Object performTerminalObj = param.get("performTerminal");
        Object procParObj = param.get("procPar");
        String procCode = "";
        String procVer = "";
        String performTerminal = "";
        String procPar = "";
        this.checkParams(procCodeObj, procVerObj, performTerminalObj, procParObj);
        procCode = procCodeObj.toString();
        performTerminal = performTerminalObj.toString();
        if (ObjectUtils.isNotEmpty((Object)procVerObj)) {
            procVer = procVerObj.toString();
        }
        if (ObjectUtils.isNotEmpty((Object)procParObj)) {
            procPar = procParObj.toString();
        }
        if (ObjectUtils.isNotEmpty((Object)performTerminalObj)) {
            performTerminal = performTerminalObj.toString();
        }
        DynamicObject ver = null;
        if (procVerObj == null || StringUtils.isBlank((CharSequence)procVerObj.toString())) {
            procCodeFileter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            QFilter statusFileter = new QFilter("ysq_work_status", "=", (Object)"release");
            DynamicObjectCollection listVers = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFileter, statusFileter});
            if (CollectionUtils.isNotEmpty((Collection)listVers)) {
                Collections.sort(listVers, new ProcVerComparator());
                ver = (DynamicObject)listVers.get(0);
            }
        } else {
            procCodeFileter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            QFilter procVerFileter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
            QFilter statusFileter = new QFilter("ysq_work_status", "=", (Object)"release");
            DynamicObjectCollection listVers = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFileter, statusFileter, procVerFileter});
            if (CollectionUtils.isNotEmpty((Collection)listVers)) {
                ver = (DynamicObject)listVers.get(0);
            } else {
                log.error("\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728");
                throw new KDException("\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728");
            }
        }
        DynamicObject robot = null;
        if ("deptall".equals(performTerminal)) {
            robot = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_agent");
            robot.set("ysq_agent_no", (Object)"deptall");
            robot.set("ysq_agent_name", (Object)"deptall");
            robot.set("ysq_agent_alias", (Object)"deptall");
        }
        if (!"deptall".equals(performTerminal)) {
            QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(performTerminal));
            qFilter.and(new QFilter("ysq_agent_type", "=", (Object)"robot"));
            robot = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
            if (robot == null) {
                log.error("\u673a\u5668\u4eba\u4e0d\u5b58\u5728");
                throw new KDException("\u673a\u5668\u4eba\u4e0d\u5b58\u5728");
            }
        }
        Long id = 0L;
        if (ver == null || null == robot) {
            log.error("\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728");
            throw new KDException("\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728");
        }
        id = this.saveSchedulerJob(ver, robot, procPar, performTerminal);
        return id.toString();
    }

    @Override
    public List<Map<String, Object>> getRobotList(Map<String, Object> param) throws InvocationTargetException, IllegalAccessException {
        if (ObjectUtils.isEmpty((Object)param.get("processId"))) {
            log.error("\u6d41\u7a0bid\u4e0d\u53ef\u4e3a\u7a7a");
            throw new KDException("\u6d41\u7a0bid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        DynamicObject processes = null;
        try {
            processes = BusinessDataServiceHelper.loadSingle((Object)param.get("processId"), (String)"ysq_rpa_process");
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            processes = null;
        }
        if (null == processes) {
            log.error("\u6d41\u7a0b\u4e0d\u5b58\u5728");
            throw new KDException("\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        Long orgId = BaseVO.getOrgId((DynamicObject)processes);
        List<Long> agentOrgs = new ArrayList<Long>();
        agentOrgs.add(orgId);
        agentOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", agentOrgs, (boolean)true);
        QFilter orgFilter = new QFilter("org", "in", agentOrgs);
        QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"robot");
        orgFilter.and(agentTypeFilter);
        if (ObjectUtils.isNotEmpty((Object)param.get("agentDcode"))) {
            orgFilter.and(new QFilter("ysq_agent_dcode", "like", (Object)("%" + param.get("agentDcode").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("agentNo"))) {
            orgFilter.and(new QFilter("ysq_agent_no", "like", (Object)("%" + param.get("agentNo").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("agentIp"))) {
            orgFilter.and(new QFilter("ysq_agent_ip", "like", (Object)("%" + param.get("agentIp").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("agentAlias"))) {
            orgFilter.and(new QFilter("ysq_agent_alias", "like", (Object)("%" + param.get("agentAlias").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("userName"))) {
            orgFilter.and(new QFilter("ysq_user_name", "like", (Object)("%" + param.get("userName").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("userDomain"))) {
            orgFilter.and(new QFilter("ysq_user_domain", "like", (Object)("%" + param.get("userDomain").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("agentName"))) {
            orgFilter.and(new QFilter("ysq_agent_name", "like", (Object)("%" + param.get("agentName").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("agentOs"))) {
            orgFilter.and(new QFilter("ysq_agent_os", "like", (Object)("%" + param.get("agentOs").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("agentVersion"))) {
            orgFilter.and(new QFilter("ysq_agent_version", "like", (Object)("%" + param.get("agentVersion").toString() + "%")));
        }
        if (ObjectUtils.isNotEmpty((Object)param.get("description"))) {
            orgFilter.and(new QFilter("ysq_description", "like", (Object)("%" + param.get("description").toString() + "%")));
        }
        DynamicObject[] agents = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])new QFilter[]{orgFilter});
        ArrayList<Map<String, Object>> agentList = new ArrayList<Map<String, Object>>();
        for (DynamicObject agent : agents) {
            agentList.add(new CdaAgentVO().mapFromDynamicObject(agent));
        }
        return agentList;
    }

    @Override
    public List<Map<String, Object>> getParams(Map<String, Object> param) {
        Object procCode = param.get("procCode");
        Object procVer = param.get("procVer");
        String ysqParam = "";
        if (ObjectUtils.isEmpty((Object)procCode)) {
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode.toString());
        DynamicObject[] listProc = BusinessDataServiceHelper.load((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter});
        if (null == listProc || listProc.length == 0) {
            throw new KDException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff01");
        }
        QFilter workStatusFilter = new QFilter("ysq_work_status", "=", (Object)"release");
        if (ObjectUtils.isEmpty((Object)procVer)) {
            DynamicObjectCollection listVers = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter, workStatusFilter});
            if (CollectionUtils.isNotEmpty((Collection)listVers)) {
                Collections.sort(listVers, new ProcVerComparator());
                DynamicObject processVerNew = (DynamicObject)listVers.get(0);
                ysqParam = processVerNew.getString("ysq_param_tag");
            }
        } else {
            QFilter procVerFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer.toString());
            DynamicObject ver = null;
            try {
                ver = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter, workStatusFilter, procVerFilter});
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                return new ArrayList<Map<String, Object>>();
            }
            if (ObjectUtils.isEmpty((Object)ver)) {
                throw new KDException("\u6d41\u7a0b\u7248\u672c\u4e0d\u5b58\u5728\uff01");
            }
            ysqParam = ver.getString("ysq_param_tag");
        }
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        if (StringUtils.isEmpty((CharSequence)ysqParam)) {
            return mapList;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)ysqParam);
        List list = jsonArray.toJavaList(Map.class);
        list.stream().forEach(i -> {
            HashMap m = new HashMap();
            m.putAll(i);
            mapList.add(m);
        });
        return mapList;
    }

    @Override
    public Map<String, Object> getTaskStatus(Map<String, Object> param) {
        String taskId = param.get("taskId").toString();
        if (ObjectUtils.isEmpty((Object)taskId)) {
            throw new KDException("taskId is none\uff01");
        }
        DynamicObject job = null;
        try {
            job = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"ysq_rpa_job");
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            job = null;
        }
        if (null == job) {
            throw new KDException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        return KingRpaJobRes.objToKingRpaJobRes((DynamicObject)job);
    }

    @Override
    public Map<String, Object> readIpkgFile(InputStream inputStream) {
        return IsearchFileUtils.readIpkgFile((InputStream)inputStream);
    }

    @Override
    public Map<String, Object> checkIpkgIntact(Map<String, Object> ipkgInfoMap) {
        return IpkgUtils.checkIpkgIsIntact(ipkgInfoMap);
    }

    @Override
    public Map<String, Object> checkStandIpkg(Map<String, Object> ipkgInfoMap) {
        return IpkgUtils.checkNoOpenIpkg(ipkgInfoMap);
    }

    @Override
    public Map<String, Object> addSch(Map<String, Object> param) {
        Object procCodeObj = param.get("procCode");
        if (procCodeObj == null) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PROCVERS_PROCCODE_NULL.getCode() + "", ResultStatusEnums.PROCVERS_PROCCODE_NULL.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        String procCode = procCodeObj.toString();
        if (!LicenseUtils.checkStdAppLicense((String)procCode).booleanValue()) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.LIC_PLATFORM_NO_LICENSE.getCode() + "", ResultStatusEnums.LIC_PLATFORM_NO_LICENSE.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        QFilter[] procCodeFilter = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)};
        DynamicObject[] process = BusinessDataServiceHelper.load((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])procCodeFilter);
        if (process == null || process.length == 0) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PROC_NOT_EXIT.getCode() + "", ResultStatusEnums.PROC_NOT_EXIT.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        QFilter[] procVerfilterArr = new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)};
        DynamicObject[] processVerArr = BusinessDataServiceHelper.load((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])procVerfilterArr, (String)"id asc");
        if (null == processVerArr || processVerArr.length == 0) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PROC_PROCESS_VERSION_EMPTY.getCode() + "", ResultStatusEnums.PROC_PROCESS_VERSION_EMPTY.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        DynamicObject ysqSchedule = BusinessDataServiceHelper.newDynamicObject((String)"ysq_process_schedule");
        ysqSchedule.set("ysq_proc_code", (Object)procCode);
        Object schParamsObj = param.get("schParams");
        if (schParamsObj != null) {
            ysqSchedule.set("ysq_sch_param_tag", (Object)param.get("schParams").toString());
        }
        Object robotSelObj = param.get("robots_select");
        String robotSel = "";
        if (robotSelObj == null) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PROCSCH_ROBOT_IS_ERROR.getCode() + "", ResultStatusEnums.PROCSCH_ROBOT_IS_ERROR.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        robotSel = robotSelObj.toString();
        if (!StringUtils.equals((CharSequence)RobotRangeEnums.DEFAULT.getCode(), (CharSequence)robotSel)) {
            ysqSchedule.set("ysq_exec_robots_no_sel", (Object)"2");
            ysqSchedule.set("ysq_robots_sel", (Object)robotSel);
        } else {
            ysqSchedule.set("ysq_exec_robots_no_sel", (Object)robotSel);
        }
        ysqSchedule.set("ysq_proc_name", (Object)process[0].getString("ysq_proc_name"));
        Object schId = param.get("schId");
        if (ObjectUtils.isNotEmpty((Object)schId)) {
            ysqSchedule.set("id", (Object)Long.parseLong(schId.toString()));
        }
        Object id = this.saveSchedule(ysqSchedule, param);
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("schId", id);
        return result;
    }

    private Long saveSchedulerJob(DynamicObject ver, DynamicObject robot, String procPar, String performTerminal) {
        String procCode = ver.getString("ysq_proc_code");
        String procVer = ver.getString("ysq_proc_ver");
        String agentNo = robot.getString("ysq_agent_no");
        String agentName = robot.getString("ysq_agent_name");
        String agentAlias = robot.getString("ysq_agent_alias");
        Timestamp now = new Timestamp(Calendar.getInstance().getTimeInMillis());
        QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject processDb = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
        RpaJobVO job = new RpaJobVO();
        job.setWorkStatus(processDb.getString("ysq_work_status"));
        job.setJobNo(UUID.randomUUID().toString());
        job.setJobOrder(Long.valueOf(now.getTime()));
        job.setProduceType("manual_run");
        job.setExecRobotsNo("-" + agentNo + "-");
        job.setExecRobotsNames("-" + agentName + "-");
        job.setExecRobotsAlias("-" + agentAlias + "-");
        QFilter procFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter verFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
        DynamicObject processVerDb = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{procFilter, verFilter});
        if (!ObjectUtils.isNotEmpty((Object)processVerDb)) {
            throw new KDException("\u4e0d\u5b58\u5728\u6b64\u7248\u672c\u53f7\u7684\u6d41\u7a0b\uff01");
        }
        job.setProcFid(Long.valueOf(processVerDb.getLong("id")));
        job.setProcCode(processDb.getString("ysq_proc_code"));
        job.setProcName(processDb.getString("ysq_proc_name"));
        job.setProcFile(ver.getString("ysq_proc_file"));
        job.setProcVer(ver.getString("ysq_proc_ver"));
        job.setPublishTime(ver.getDate("ysq_publish_time"));
        long orgId = processDb.getLong("org");
        job.setOrgId(Long.valueOf(orgId));
        job.setDeveloperUserFid(Long.valueOf(processDb.getLong("ysq_dev_user_fid")));
        job.setDeveloperUserAlias(processDb.getString("ysq_dev_user_alias"));
        job.setJobTime((Date)now);
        job.setStatus(RpaJobStatusEnums.PENDING.getCode());
        job.setPendingTimeout(Integer.valueOf(processDb.getInt("ysq_pending_timeout")));
        job.setRunningTimeout(Integer.valueOf(processDb.getInt("ysq_running_timeout")));
        job.setProcHandDoMin(Integer.valueOf(0));
        job.setAutoStopTime(Integer.valueOf(processDb.getInt("ysq_auto_stop_time")));
        job.setFailTryTimes(Integer.valueOf(0));
        job.setRunTimes(Integer.valueOf(1));
        job.setPriority("higher");
        if (StringUtils.isNotBlank((CharSequence)procPar)) {
            Base64.Encoder encoder = Base64.getEncoder();
            try {
                procPar = encoder.encodeToString(String.valueOf(procPar).getBytes("utf-8"));
                job.setParameter(procPar);
            }
            catch (UnsupportedEncodingException e) {
                throw new KDException("\u6d41\u7a0b\u53c2\u6570\u52a0\u5bc6\u5931\u8d25");
            }
        }
        String userType = "";
        Long userId = RequestContext.get().getCurrUserId();
        if (userId != null && !new Long(0L).equals(userId)) {
            userType = userId.toString();
        } else {
            Long procUserId = processDb.getLong("creator");
            userType = procUserId.toString();
        }
        job.setJobType(userType);
        job.setSchType("manager");
        job.setProcVerDesc(processDb.getString("ysq_proc_desc"));
        job.setStudioVer(processDb.getString("ysq_studio_ver"));
        job.setComJobType("common");
        String proChange = ver.getString("ysq_pro_change");
        Object[] jobs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{job.buildDynamicObject()});
        DynamicObject jobd = (DynamicObject)jobs[0];
        Long jobId = jobd.getLong("id");
        job.setFid(jobId);
        this.jobQueueProducer.addJob(job, proChange);
        return jobId;
    }

    private void checkParams(Object procCodeObj, Object procVerObj, Object performTerminalObj, Object procParObj) {
        QFilter procTypeFileter;
        if (procCodeObj == null) {
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        String str = procCodeObj.toString();
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (performTerminalObj == null) {
            throw new KDException("\u6267\u884c\u7ec8\u7aef\u4e0d\u80fd\u4e3a\u7a7a");
        }
        str = performTerminalObj.toString();
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new KDException("\u6267\u884c\u7ec8\u7aef\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (procParObj != null && StringUtils.isNotBlank((CharSequence)(str = procParObj.toString())) && StringUtil.isNotJSON((String)str)) {
            throw new KDException("\u6d41\u7a0b\u53c2\u6570\u4e0d\u662fJSON\u683c\u5f0f");
        }
        String procCode = procCodeObj.toString();
        QFilter procCodeFileter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])new QFilter[]{procCodeFileter, procTypeFileter = new QFilter("ysq_proc_type", "=", (Object)"common")});
        if (!exists) {
            throw new KDException("\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
    }

    private List<Long> orgLike(List<Long> orgs, String orgName) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        for (Long orgId : orgs) {
            String nodeOrgName;
            OrgTreeParam param = new OrgTreeParam();
            param.setOrgViewNumber("01");
            param.setId(orgId.longValue());
            List rootInfoMap = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
            if (!CollectionUtils.isNotEmpty((Collection)rootInfoMap) || !(nodeOrgName = ((TreeNode)rootInfoMap.get(0)).getText()).contains(orgName)) continue;
            orgList.add(orgId);
        }
        return orgList;
    }

    private Map<String, Object> paramsEnca(DynamicObject dynamicObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", dynamicObject.getLong("id"));
        map.put("procCode", dynamicObject.getString("ysq_proc_code"));
        map.put("procName", dynamicObject.getString("ysq_proc_name"));
        map.put("procLabel", "");
        map.put("procVer", dynamicObject.getString("ysq_proc_ver"));
        DynamicObject userInfo = dynamicObject.getDynamicObject("creator");
        String devName = "";
        if (userInfo != null) {
            devName = userInfo.get("name").toString();
        }
        map.put("developerUser", devName);
        map.put("owberUser", dynamicObject.getString("ysq_owner_user_fid"));
        Date publishTimedate = dynamicObject.getDate("ysq_publish_time");
        if (publishTimedate != null) {
            String publishTime = "";
            publishTime = DateUtils.formatDate((Date)publishTimedate, (String)"yyyy-MM-dd HH:mm:ss");
            map.put("publishTime", publishTime);
        }
        map.put("procDesc", dynamicObject.getString("ysq_proc_desc"));
        map.put("pendingTimeout", dynamicObject.getString("ysq_pending_timeout"));
        map.put("runningTimeout", dynamicObject.getString("ysq_running_timeout"));
        map.put("handDoMin", dynamicObject.getString("ysq_hand_do_min"));
        map.put("autoStopTime", dynamicObject.getString("ysq_auto_stop_time"));
        map.put("failTryTimes", dynamicObject.getString("ysq_fail_try_times"));
        map.put("keyWords", dynamicObject.getString("ysq_key_words"));
        map.put("workStatus", dynamicObject.getString("ysq_work_status"));
        Date statuCtimeDate = dynamicObject.getDate("ysq_status_ctime");
        if (statuCtimeDate != null) {
            String statusCTime = "";
            statusCTime = DateUtils.formatDate((Date)statuCtimeDate, (String)"yyyy-MM-dd HH:mm:ss");
            map.put("statusCtime", statusCTime);
        }
        map.put("isAssistant", dynamicObject.getString("ysq_is_assistant"));
        map.put("isStartUp", dynamicObject.getString("ysq_is_start_up"));
        map.put("createTime", DateUtils.formatDate((Date)dynamicObject.getDate("createtime"), (String)"yyyy-MM-dd HH:mm:ss"));
        map.put("modifyTime", DateUtils.formatDate((Date)dynamicObject.getDate("modifytime"), (String)"yyyy-MM-dd HH:mm:ss"));
        DynamicObject orgInfo = dynamicObject.getDynamicObject("org");
        if (null != orgInfo) {
            String name = orgInfo.getString("name");
            map.put("curOrgName", name);
        }
        return map;
    }

    private Object saveSchedule(DynamicObject dataObj, Map<String, Object> param) {
        String monthSelDay;
        String monthSelMonth;
        String week;
        String schTime;
        String hourSplit;
        String minSplit;
        String cronExpression;
        String schModel = ObjectUtils.isEmpty((Object)param.get("schModel")) ? "" : param.get("schModel").toString();
        String[] scheduleCommandArr = CronExpressionUtils.buildCommands((String)schModel, (String)(cronExpression = ObjectUtils.isEmpty((Object)param.get("cronExpression")) ? "" : param.get("cronExpression").toString()), (String)(minSplit = ObjectUtils.isEmpty((Object)param.get("minSplit")) ? "" : param.get("minSplit").toString()), (String)(hourSplit = ObjectUtils.isEmpty((Object)param.get("hourSplit")) ? "" : param.get("hourSplit").toString()), (String)(schTime = ObjectUtils.isEmpty((Object)param.get("schTime")) ? "" : param.get("schTime").toString()), (String)(week = ObjectUtils.isEmpty((Object)param.get("week")) ? "" : param.get("week").toString()), (String)(monthSelMonth = ObjectUtils.isEmpty((Object)param.get("monthSelMonth")) ? "" : param.get("monthSelMonth").toString()), (String)(monthSelDay = ObjectUtils.isEmpty((Object)param.get("monthSelDay")) ? "" : param.get("monthSelDay").toString()));
        if (null == scheduleCommandArr) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PRECESSES_CRONEXPR_ERROR.getCode() + "", ResultStatusEnums.PRECESSES_CRONEXPR_ERROR.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        String[] schConfigArr = CronExpressionUtils.getCronExpression((String)schModel, (String)scheduleCommandArr[0], (String)scheduleCommandArr[1]);
        if (null == schConfigArr) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PRECESSES_CRONEXPR_ERROR.getCode() + "", ResultStatusEnums.PRECESSES_CRONEXPR_ERROR.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        if (!TriggerTimeUtils.checkCronStr((String)schConfigArr[1]).booleanValue()) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PRECESSES_CRONEXPR_ERROR.getCode() + "", ResultStatusEnums.PRECESSES_CRONEXPR_ERROR.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        if (StringUtils.isBlank((CharSequence)cronExpression)) {
            cronExpression = schConfigArr[1];
        }
        Long schId = dataObj.getLong("id");
        Date startTime = new Date();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(new Date());
        endCalendar.add(1, 200);
        Date endTime = endCalendar.getTime();
        dataObj.set("ysq_start_time", (Object)startTime);
        dataObj.set("ysq_end_time", (Object)endTime);
        dataObj.set("ysq_sch_type", (Object)"standard");
        dataObj.set("ysq_schedule_mode", (Object)schModel);
        if (schId == 0L) {
            schId = ID.genLongId();
            dataObj.set("id", (Object)schId);
            String schName = this.setSchName(dataObj.getString("ysq_proc_name"));
            dataObj.set("ysq_sch_name", (Object)schName);
            String[] jobPlanIds = ScheduleUtils.addTaskJob((Long)dataObj.getLong("id"), (Date)startTime, (Date)endTime, (String)cronExpression, (String)schName);
            Long jobLong = Long.valueOf(jobPlanIds[0]);
            Long planLong = Long.valueOf(jobPlanIds[1]);
            dataObj.set("ysq_kd_jobid", (Object)jobLong);
            dataObj.set("ysq_kd_planid", (Object)planLong);
            dataObj.set("ysq_status", (Object)"yes");
            this.saveDbSchdule(dataObj, scheduleCommandArr, schConfigArr, false);
            return schId;
        }
        String croeNew = schConfigArr[1];
        Long lid = Long.parseLong(schId.toString());
        DynamicObject schDynObj = null;
        try {
            schDynObj = BusinessDataServiceHelper.loadSingle((Object)schId, (String)"ysq_process_schedule");
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            schDynObj = null;
        }
        if (schDynObj == null) {
            ErrorCode errorCode = new ErrorCode(ResultStatusEnums.PROCSCH_INFO_ALREADY_EXISTS.getCode() + "", ResultStatusEnums.PROCSCH_INFO_ALREADY_EXISTS.getCodeMsg());
            throw new KDException(errorCode, null, null);
        }
        Long jobId = (Long)schDynObj.get("ysq_kd_jobid");
        Long palinId = (Long)schDynObj.get("ysq_kd_planid");
        ScheduleUtils.delTaskJob((String)jobId.toString(), (String)palinId.toString());
        String[] jobPlanIds = ScheduleUtils.addTaskJob((Long)lid, (Date)startTime, (Date)endTime, (String)croeNew, (String)schDynObj.getString("ysq_sch_name"));
        dataObj.set("ysq_kd_jobid", (Object)Long.valueOf(jobPlanIds[0]));
        dataObj.set("ysq_kd_planid", (Object)Long.valueOf(jobPlanIds[1]));
        this.saveDbSchdule(dataObj, scheduleCommandArr, schConfigArr, true);
        return dataObj.get("id");
    }

    private String setSchName(String appName) {
        String schName = appName + "\u8c03\u5ea6\u8ba1\u5212";
        QFilter schNameFilter = new QFilter("ysq_sch_name", "like", (Object)(appName + "\u8c03\u5ea6\u8ba1\u5212" + "%"));
        DynamicObjectCollection schNameCollection = QueryServiceHelper.query((String)"ysq_process_schedule", (String)"ysq_sch_name", (QFilter[])new QFilter[]{schNameFilter});
        ArrayList<Integer> nameList = new ArrayList<Integer>();
        for (DynamicObject object : schNameCollection) {
            String name = object.getString("ysq_sch_name");
            String substring = name.substring(schName.length());
            if (!substring.matches("[0-9]+")) continue;
            nameList.add(Integer.valueOf(substring));
        }
        nameList.sort(Comparator.naturalOrder());
        if (nameList.size() > 0) {
            Integer integer = (Integer)nameList.get(nameList.size() - 1) + 1;
            return appName + "\u8c03\u5ea6\u8ba1\u5212" + integer;
        }
        return appName + "\u8c03\u5ea6\u8ba1\u52121";
    }

    private void saveDbSchdule(DynamicObject schSaveObject, String[] scheduleCommandArr, String[] schConfigArr, boolean isUpdate) {
        QFilter proFilter;
        QFilter[] proFilters;
        String field;
        DynamicObject[] processList;
        String codeStr;
        String robotsNoSel = schSaveObject.getString("ysq_exec_robots_no_sel");
        schSaveObject.set("ysq_exec_robots_no_sel", (Object)robotsNoSel);
        if (RobotRangeEnums.DEFAULT.getCode().equals(robotsNoSel)) {
            schSaveObject.set("ysq_exec_robots_no_tag", (Object)robotsNoSel);
            schSaveObject.set("ysq_robots_sel", null);
        } else {
            String[] split;
            StringBuilder robots = new StringBuilder();
            String string = schSaveObject.getString("ysq_robots_sel");
            if (StringUtils.isNotEmpty((CharSequence)string) && (split = string.split(",")).length > 0) {
                for (String robotNo : split) {
                    if (!StringUtils.isNotBlank((CharSequence)robotNo)) continue;
                    robots.append("-");
                    robots.append(robotNo);
                    robots.append("-");
                    robots.append(",");
                }
                robots.deleteCharAt(robots.length() - 1);
            }
            schSaveObject.set("ysq_exec_robots_no_tag", (Object)robots.toString());
            schSaveObject.set("ysq_robots_sel", (Object)schSaveObject.getString("ysq_robots_sel"));
        }
        Object proCode = schSaveObject.get("ysq_proc_code");
        if (proCode != null && StringUtils.isNotBlank((CharSequence)(codeStr = proCode.toString())) && (processList = BusinessDataServiceHelper.load((String)"ysq_rpa_process", (String)(field = "ysq_proc_ver,ysq_proc_name,ysq_proc_type"), (QFilter[])(proFilters = new QFilter[]{proFilter = new QFilter("ysq_proc_code", "=", (Object)codeStr)}))) != null && processList.length > 0) {
            DynamicObject dynamicObjects = processList[0];
            String s = dynamicObjects.get("ysq_proc_ver").toString();
            if (StringUtils.isNotBlank((CharSequence)s)) {
                schSaveObject.set("ysq_proc_ver", (Object)s);
            }
            Long procId = dynamicObjects.getLong("id");
            schSaveObject.set("ysq_proc_fid", (Object)procId);
            String procName = dynamicObjects.getString("ysq_proc_name");
            schSaveObject.set("ysq_proc_name", (Object)procName);
            String procType = dynamicObjects.getString("ysq_proc_type");
            schSaveObject.set("ysq_sch_type", (Object)procType);
        }
        schSaveObject.set("ysq_schedule_command", (Object)scheduleCommandArr[0]);
        schSaveObject.set("ysq_schedule_time", (Object)scheduleCommandArr[1]);
        String exper = schConfigArr[1];
        schSaveObject.set("ysq_schedule_expre", (Object)exper);
        schSaveObject.set("ysq_sch_expre_desc", (Object)schConfigArr[2]);
        schSaveObject.set("ysq_next_exe_time", (Object)this.getNextExeTime(exper, schSaveObject.getDate("ysq_start_time")));
        String schParam = schSaveObject.getString("ysq_sch_param_tag");
        if (StringUtils.isNotBlank((CharSequence)schParam)) {
            schSaveObject.set("ysq_sch_param_tag", (Object)IsearchFileUtils.paramsBase64((String)schParam));
        }
        schSaveObject.set("billstatus", (Object)"A");
        schSaveObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        schSaveObject.set("org", (Object)RequestContext.get().getOrgId());
        schSaveObject.set("ysq_priority", (Object)"middle");
        schSaveObject.set("ysq_studio_ver", (Object)"2024.1.2.0");
        schSaveObject.set("ysq_script", (Object)"workday");
        schSaveObject.set("ysq_start_reissue", (Object)"yes");
        schSaveObject.set("ysq_sch_job_nums", (Object)1);
        schSaveObject.set("ysq_fail_try_times", (Object)0);
        schSaveObject.set("ysq_auto_stop_time", (Object)0);
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{schSaveObject});
        } else {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schSaveObject});
        }
    }

    private Date getNextExeTime(String cron, Date lastDate) {
        List nextTimes = TriggerTimeUtils.findNextTimes((String)cron, (Integer)1, (Date)lastDate);
        if (!nextTimes.isEmpty()) {
            return (Date)nextTimes.get(0);
        }
        return null;
    }
}

