/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.controller;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.springframework.web.bind.annotation.RequestParam;
import ysq.rpac.rpamc.common.enums.ItemQueueStatusEnums;
import ysq.rpac.rpamc.common.model.BaseVO;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchApiResultVO;
import ysq.rpac.rpamc.common.model.ISearchCustomApiResultVO;
import ysq.rpac.rpamc.common.model.queueItems.AddQueueItemVO;
import ysq.rpac.rpamc.common.model.queueItems.DeleteQueueItemVO;
import ysq.rpac.rpamc.common.model.queueItems.QueueItemQueryVO;
import ysq.rpac.rpamc.common.model.queueItems.UpdateQueueItemVO;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.QueueItemServiceHelper;

@ApiController(value="/queue/item", desc="\u6570\u636e\u9879")
public class QueueItemController {
    private static Log log = LogFactory.getLog(QueueItemController.class);

    @ApiPostMapping(value="/listQueueItem")
    public CustomApiResult<ISearchApiResultVO> listQueueItem(@ApiParam(value="\u6570\u636e\u9879") @ApiParam(value="\u6570\u636e\u9879") QueueItemQueryVO query) {
        String commtoken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        CdaAgentVO agent = new CdaAgentVO();
        if (ObjectUtils.isNotEmpty((Object)commtoken)) {
            agent = AgentServiceHelper.checkCommonToken((String)commtoken);
            if (null == agent) {
                return CustomApiResult.success((Object)ISearchApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1));
            }
        } else {
            agent.setOrgFid(Long.valueOf(RequestContext.get().getOrgId()));
            agent.setAgentType("studio");
        }
        if (StringUtils.isNotBlank((CharSequence)query.getStatus()) && "succ".equals(query.getStatus())) {
            query.setStatus(ItemQueueStatusEnums.SUCC.getCode());
        }
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            customApiResult.setData((Object)QueueItemServiceHelper.listQueueItem((QueueItemQueryVO)query, (CdaAgentVO)agent));
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)errorCode.getMessage(), (Integer)Integer.parseInt(errorCode.getCode())));
            log.error(errorCode.getMessage());
        }
        return customApiResult;
    }

    @ApiPostMapping(value="/addQueueItem")
    public CustomApiResult<ISearchCustomApiResultVO> addQueueItem(@ApiParam(value="\u6570\u636e\u9879") @ApiParam(value="\u6570\u636e\u9879") AddQueueItemVO queueItem) {
        String commtoken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        CdaAgentVO agent = new CdaAgentVO();
        if (ObjectUtils.isNotEmpty((Object)commtoken)) {
            agent = AgentServiceHelper.checkCommonToken((String)commtoken);
            if (null == agent) {
                return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1));
            }
        } else {
            agent.setOrgFid(Long.valueOf(RequestContext.get().getOrgId()));
            agent.setAgentType("studio");
        }
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            customApiResult.setData((Object)QueueItemServiceHelper.addQueueItem((AddQueueItemVO)queueItem, (CdaAgentVO)agent));
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)errorCode.getMessage(), (Integer)Integer.parseInt(errorCode.getCode())));
            log.error(errorCode.getMessage());
        }
        return customApiResult;
    }

    @ApiGetMapping(value="/popQueueItem")
    public CustomApiResult<ISearchCustomApiResultVO> popQueueItem(@ApiParam(value="\u961f\u5217\u540d", required=true) @Valid @NotBlank @Length(min=2, max=64) @RequestParam @ApiParam(value="\u961f\u5217\u540d", required=true) @Valid @NotBlank @Length(min=2, max=64) String queueName, @ApiParam(value="jobNo") @RequestParam @ApiParam(value="jobNo") String jobNo, @ApiParam(value="procCode") @RequestParam @ApiParam(value="procCode") String procCode) {
        String commtoken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        CdaAgentVO agent = new CdaAgentVO();
        if (ObjectUtils.isNotEmpty((Object)commtoken)) {
            agent = AgentServiceHelper.checkCommonToken((String)commtoken);
            if (null == agent) {
                return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1));
            }
        } else {
            agent.setOrgFid(Long.valueOf(RequestContext.get().getOrgId()));
            agent.setAgentType("studio");
        }
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            customApiResult.setData((Object)QueueItemServiceHelper.popQueueItem((String)queueName, (CdaAgentVO)agent, (String)jobNo, (String)procCode));
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)errorCode.getMessage(), (Integer)Integer.parseInt(errorCode.getCode())));
            log.error(errorCode.getMessage());
        }
        return customApiResult;
    }

    @ApiPostMapping(value="/deleteQueueItem")
    public CustomApiResult<ISearchCustomApiResultVO> deleteQueueItem(@ApiParam(value="\u6570\u636e\u9879") @ApiParam(value="\u6570\u636e\u9879") DeleteQueueItemVO deleteQueueItemVo) {
        String commtoken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        CdaAgentVO agent = new CdaAgentVO();
        if (ObjectUtils.isNotEmpty((Object)commtoken)) {
            agent = AgentServiceHelper.checkCommonToken((String)commtoken);
            if (null == agent) {
                return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1));
            }
        } else {
            agent.setOrgFid(Long.valueOf(RequestContext.get().getOrgId()));
            agent.setAgentType("studio");
        }
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            customApiResult.setData((Object)QueueItemServiceHelper.deleteQueueItem((DeleteQueueItemVO)deleteQueueItemVo, (CdaAgentVO)agent));
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)errorCode.getMessage(), (Integer)Integer.parseInt(errorCode.getCode())));
            log.error(errorCode.getMessage());
        }
        return customApiResult;
    }

    @ApiPostMapping(value="/updateQueueItem")
    public CustomApiResult<ISearchCustomApiResultVO> updateQueueItem(@ApiParam(value="\u6570\u636e\u9879") @ApiParam(value="\u6570\u636e\u9879") UpdateQueueItemVO updateQueueItemVo) {
        String commtoken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
        CdaAgentVO agent = new CdaAgentVO();
        if (ObjectUtils.isNotEmpty((Object)commtoken)) {
            agent = AgentServiceHelper.checkCommonToken((String)commtoken);
            if (null == agent) {
                return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)BaseVO.ROBOTNONE, (Integer)1));
            }
        } else {
            agent.setOrgFid(Long.valueOf(RequestContext.get().getOrgId()));
            agent.setAgentType("studio");
        }
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            customApiResult.setData((Object)QueueItemServiceHelper.updateQueueItem((UpdateQueueItemVO)updateQueueItemVo, (CdaAgentVO)agent));
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)errorCode.getMessage(), (Integer)Integer.parseInt(errorCode.getCode())));
            log.error(errorCode.getMessage());
        }
        return customApiResult;
    }
}

