/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.controller.RpaLibrary;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqLibraryConstant;
import ysq.rpac.rpamc.common.model.ISearchCustomApiResultVO;
import ysq.rpac.rpamc.common.model.LibraryVO;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.PermOrgsUtils;

@ApiController(value="rpaLibrary", desc="\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
public class RpaLibraryController {
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static Log log = LogFactory.getLog(RpaLibraryController.class);
    private final Integer MAX_PACKAGE_SIZE = 0xC800000;

    @ApiGetMapping(value="/library", desc="\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u4e0a\u4f20")
    public CustomApiResult<ISearchCustomApiResultVO> saveCustomComponent(@ApiParam(value="\u7ec4\u4ef6\u4e0a\u4f20url") @ApiParam(value="\u7ec4\u4ef6\u4e0a\u4f20url") String url, @ApiParam(value="\u6587\u4ef6\u5927\u5c0f") @ApiParam(value="\u6587\u4ef6\u5927\u5c0f") Integer size) {
        if (size > this.MAX_PACKAGE_SIZE) {
            log.error("ipkg\u5305\u592a\u5927,\u4e0d\u7ee7\u7eed\u89e3\u6790");
            ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
            result.setCode(Integer.valueOf(-1));
            result.setMsg("ipkg\u5305\u8d85\u8fc7200MB");
            return CustomApiResult.success((Object)result);
        }
        if (url == null || url.isEmpty()) {
            return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)"url is empty", (Integer)-1));
        }
        Long userId = RequestContext.get().getCurrUserId();
        String fileName = UUID.randomUUID().toString().replace("-", "") + ".ipkg";
        long libraryId = ID.genLongId();
        ArrayList list = new ArrayList();
        HashMap<String, Object> attach = new HashMap<String, Object>();
        String path = null;
        try {
            attach.put("uid", UUID.randomUUID().toString());
            attach.put("name", fileName);
            attach.put("size", 0);
            attach.put("url", url);
            list.add(attach);
            AttachmentServiceHelper.upload((String)"ysq_rpa_library", (Object)libraryId, (String)ATTACHMENT_PANEL, list);
            List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_library", (Object)libraryId, (String)ATTACHMENT_PANEL);
            path = ((Map)attachmentpanel.get(0)).get("url").toString();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u9644\u4ef6url\u5931\u8d25");
            ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
            result.setCode(Integer.valueOf(-1));
            result.setMsg("\u83b7\u53d6\u9644\u4ef6url\u5931\u8d25");
            return CustomApiResult.success((Object)result);
        }
        Map<String, Object> baseInfo = null;
        Map<String, String> extraInfo = null;
        try {
            baseInfo = this.urlToStream(path);
            extraInfo = this.getExtraInfo(path);
        }
        catch (Exception e) {
            log.error("\u81ea\u5b9a\u4e49\u7ec4\u4ef6ipkg\u5305\u89e3\u6790\u5931\u8d25");
            ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
            result.setCode(Integer.valueOf(-1));
            result.setMsg("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            return CustomApiResult.success((Object)result);
        }
        if (baseInfo.isEmpty() || extraInfo.isEmpty()) {
            log.error("\u81ea\u5b9a\u4e49\u7ec4\u4ef6ipkg\u5305\u89e3\u6790\u5931\u8d25");
            ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
            result.setCode(Integer.valueOf(-1));
            result.setMsg("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            return CustomApiResult.success((Object)result);
        }
        try {
            String proCode = baseInfo.get("proCode").toString();
            DynamicObject sameNameLibrary = this.findSameNameLibrary(proCode);
            if (sameNameLibrary != null) {
                DynamicObject dynamicObject = sameNameLibrary.getDynamicObject("creator");
                Long creatorId = dynamicObject.getLong("masterid");
                if (!creatorId.equals(userId)) {
                    log.error("\u7ec4\u4ef6\u547d\u540d\u51b2\u7a81\uff0c\u4e0a\u4f20\u4e2d\u6b62");
                    ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
                    result.setCode(Integer.valueOf(-1));
                    result.setMsg("\u7ec4\u4ef6\u540d\u51b2\u7a81");
                    return CustomApiResult.success((Object)result);
                }
                this.deleteOldVersionLib(proCode, userId, sameNameLibrary.getLong("id"));
            }
            this.saveLibrary(baseInfo, extraInfo, libraryId, size);
        }
        catch (Exception e) {
            log.error("\u7ec4\u4ef6\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25");
            ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
            result.setCode(Integer.valueOf(-1));
            result.setMsg("\u7ec4\u4ef6\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25");
            return CustomApiResult.success((Object)result);
        }
        ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
        result.setCode(Integer.valueOf(0));
        result.setMsg("\u4e0a\u4f20\u6210\u529f");
        return CustomApiResult.success((Object)result);
    }

    private DynamicObject findSameNameLibrary(String proCode) {
        QFilter codeFilter = new QFilter("ysq_lib_code", "=", (Object)proCode);
        DynamicObject model = null;
        try {
            model = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_library", (String)YsqLibraryConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
        }
        catch (Exception e) {
            log.error("DB query error");
        }
        return model;
    }

    @ApiGetMapping(value="/library/activated", desc="\u7ec4\u4ef6\u662f\u5426\u5b58\u5728")
    public CustomApiResult<ISearchCustomApiResultVO> libraryActivated(@ApiParam(value="\u7ec4\u4ef6\u7f16\u53f7") @ApiParam(value="\u7ec4\u4ef6\u7f16\u53f7") String libCode) {
        Map requestHeaders = ServiceApiContext.getRequest().getRequestHeaders();
        Long userId = RequestContext.get().getCurrUserId();
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        if (this.existLibrary(libCode, userId).booleanValue()) {
            res.put("existed", true);
        } else {
            res.put("existed", false);
        }
        ISearchCustomApiResultVO result = new ISearchCustomApiResultVO();
        result.setResult(res);
        result.setCode(Integer.valueOf(0));
        result.setMsg("success");
        CustomApiResult customApiResult = new CustomApiResult();
        customApiResult.setData((Object)result);
        return customApiResult;
    }

    @ApiGetMapping(value="/library/sync", desc="\u540c\u6b65\u81ea\u5b9a\u4e49\u7ec4\u4ef6")
    public CustomApiResult<ISearchCustomApiResultVO> syncLibrary() {
        ArrayList<LibraryVO> list = new ArrayList<LibraryVO>();
        DynamicObject[] models = null;
        try {
            for (DynamicObject model : models = BusinessDataServiceHelper.load((String)"ysq_rpa_library", (String)YsqLibraryConstant.selAllFileds(), null)) {
                Long id = (Long)model.get("id");
                List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_library", (Object)id, (String)ATTACHMENT_PANEL);
                String path = ((Map)attachmentpanel.get(0)).get("url").toString();
                LibraryVO libraryVO = new LibraryVO();
                String prefix = "/doc/ilib/";
                String prefixDown = "/attachment";
                libraryVO.setLibUrl(prefix + id.toString() + "/" + model.get("ysq_lib_code").toString() + ".ipkg");
                libraryVO.setLibCode(model.get("ysq_lib_code").toString());
                path = prefixDown + path.split("attachment")[1];
                libraryVO.setLibKdUrl(path);
                libraryVO.setProChange(model.get("ysq_lib_pro_change").toString());
                libraryVO.setLibSize(Integer.valueOf(model.get("ysq_lib_size").toString()));
                libraryVO.setLibVer(model.get("ysq_lib_ver").toString());
                libraryVO.setLibDesc(model.get("ysq_lib_desc").toString());
                DynamicObject createUser = model.getDynamicObject("creator");
                if (null != createUser) {
                    libraryVO.setUserName(createUser.getString("name"));
                } else {
                    libraryVO.setUserName("");
                }
                list.add(libraryVO);
            }
        }
        catch (Exception e) {
            log.error("\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5217\u8868\u6570\u636e\u5e93\u67e5\u8be2\u5931\u8d25");
            ISearchCustomApiResultVO error = new ISearchCustomApiResultVO();
            error.setMsg("DB ERROR");
            error.setCode(Integer.valueOf(-1));
            return CustomApiResult.success((Object)error);
        }
        ISearchCustomApiResultVO res = new ISearchCustomApiResultVO();
        res.setMsg("success");
        res.setCode(Integer.valueOf(0));
        res.setResult(list);
        return CustomApiResult.success((Object)res);
    }

    private Boolean existLibrary(String libCode, Long userId) {
        QFilter codeFilter = new QFilter("ysq_lib_code", "=", (Object)libCode);
        QFilter userFilter = new QFilter("creator", "=", (Object)userId);
        DynamicObject[] models = null;
        try {
            models = BusinessDataServiceHelper.load((String)"ysq_rpa_library", (String)"id", (QFilter[])new QFilter[]{codeFilter, userFilter});
        }
        catch (Exception e) {
            log.error("DB query error");
        }
        if (models == null || models.length == 0) {
            return false;
        }
        return true;
    }

    public Map<String, String> getExtraInfo(String url) throws IOException {
        InputStream inStream = null;
        Map<String, String> map = null;
        URL path = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)path.openConnection();
        inStream = conn.getInputStream();
        map = this.readPackage(inStream);
        return map;
    }

    private Map<String, String> readPackage(InputStream inputStream) throws IOException {
        ArrayList<String> lt = new ArrayList<String>();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try (ZipArchiveInputStream is = new ZipArchiveInputStream(inputStream);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "utf-8"));){
            ZipArchiveEntry entry = null;
            while ((entry = is.getNextZipEntry()) != null) {
                if (entry.isDirectory() || entry.getSize() <= 0L || !entry.getName().endsWith(".ilib")) continue;
                StringBuffer out = new StringBuffer();
                this.readFromInputStream(reader, out);
                if (!StringUtils.isNotBlank((CharSequence)out.toString())) continue;
                Map map = (Map)JSONObject.parse((String)out.toString());
                Map node_panel = (Map)map.get("node_panel");
                returnMap.put("libMenu", (String)node_panel.get("NodeMenuGroup"));
                String nodeTitle = (String)node_panel.get("NodeTitle");
                if (nodeTitle == null || nodeTitle.isEmpty()) continue;
                lt.add(nodeTitle);
            }
            String trueNodeTile = Joiner.on((String)",").join(lt);
            returnMap.put("libShowName", trueNodeTile);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return returnMap;
    }

    private void readFromInputStream(BufferedReader reader, StringBuffer out) throws IOException {
        String line = null;
        while ((line = reader.readLine()) != null) {
            out.append(line);
        }
    }

    private static String getBillNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String format = sdf.format(new Date());
        int i = (int)(Math.random() * 90000.0 + 10000.0);
        String billNo = "RPALibrary_" + format + "_" + i;
        return billNo;
    }

    private void deleteOldVersionLib(String libCode, Long userId, long id) {
        QFilter codeFilter = new QFilter("ysq_lib_code", "=", (Object)libCode);
        QFilter userFilter = new QFilter("creator", "=", (Object)userId);
        try {
            AttachmentServiceHelper.remove((String)"ysq_rpa_library", (Object)id);
            DeleteServiceHelper.delete((String)"ysq_rpa_library", (QFilter[])new QFilter[]{codeFilter, userFilter});
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private void saveLibrary(Map<String, Object> base, Map<String, String> extra, Long libraryId, Integer size) {
        DynamicObject library = null;
        try {
            library = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_library");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        library.set("id", (Object)libraryId);
        library.set("ysq_lib_code", base.get("proCode"));
        library.set("ysq_lib_ver", base.get("proVersion"));
        library.set("ysq_lib_desc", base.get("proDesc"));
        library.set("ysq_lib_menu", (Object)extra.get("libMenu"));
        library.set("ysq_lib_show_name", (Object)extra.get("libShowName"));
        library.set("ysq_lib_size", (Object)String.valueOf(size));
        library.set("ysq_lib_pro_change", base.get("proChange"));
        library.set("billno", (Object)RpaLibraryController.getBillNo());
        library.set("billstatus", (Object)"A");
        Long userId = RequestContext.get().getCurrUserId();
        library.set("creator", (Object)userId);
        library.set("org", (Object)PermOrgsUtils.libraryNewOrgId((Long)userId, null));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{library});
    }

    private Map<String, Object> urlToStream(String url) throws Exception {
        InputStream inStream = null;
        Map map = null;
        URL path = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)path.openConnection();
        inStream = conn.getInputStream();
        map = IsearchFileUtils.readIpkgFile((InputStream)inStream);
        return map;
    }

    private static Long getStudioOrgByUserId(Long userId) {
        if (userId == null || new Long(0L).equals(userId)) {
            return null;
        }
        QFilter userIdFilter = new QFilter("creator", "=", (Object)userId);
        QFilter typeFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
        DynamicObject studioInfo = QueryServiceHelper.queryOne((String)"ysq_rpa_agent", (String)"org", (QFilter[])new QFilter[]{userIdFilter, typeFilter});
        return studioInfo.getLong("org");
    }
}

