/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.controller;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiHeader;
import kd.bos.openapi.common.custom.annotation.ApiHeaders;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.annotation.OperateFileLog;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.FileQueryVO;
import ysq.rpac.rpamc.common.model.ISearchCustomApiResultVO;
import ysq.rpac.rpamc.common.model.ShareFileBatchDownModel;
import ysq.rpac.rpamc.common.model.ShareFileDelModel;
import ysq.rpac.rpamc.common.model.ShareFileModel;
import ysq.rpac.rpamc.common.model.ShareFileSimpleDownModel;
import ysq.rpac.rpamc.common.servicehelper.AgentServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.ShareFileServiceHelper;
import ysq.rpac.rpamc.common.utils.EsUtils;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

@ApiController(value="/", desc="\u6587\u4ef6\u5939")
public class ShareFileController {
    private static Log log = LogFactory.getLog(ShareFileController.class);

    @ApiHeaders(value={@ApiHeader(name="procCode", desc="procCode", example="procCode")})
    @ApiPostMapping(value="/share/file/uploadFile", desc="\u4e0a\u4f20\u6587\u4ef6")
    public CustomApiResult<ISearchCustomApiResultVO> uploadFile(@ApiRequestBody ShareFileModel shareFile) {
        try {
            ShareFileServiceHelper.validateUploadVO((ShareFileModel)shareFile);
            ShareFileServiceHelper.validateTags((ShareFileModel)shareFile);
            return ShareFileServiceHelper.pyUploadFile((ShareFileModel)shareFile);
        }
        catch (KDException e) {
            CustomApiResult customApiResult = new CustomApiResult();
            ErrorCode errorCode = e.getErrorCode();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)errorCode.getMessage(), (Integer)Integer.parseInt(errorCode.getCode())));
            log.error(errorCode.getMessage());
            return customApiResult;
        }
        catch (Exception e) {
            CustomApiResult customApiResult = new CustomApiResult();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)e.getMessage(), (Integer)-1));
            log.error(e.getMessage());
            return customApiResult;
        }
    }

    @ApiGetMapping(value="/share/file/fileList")
    public CustomApiResult<ISearchCustomApiResultVO> loadShareFile(@ApiParam(value="\u6587\u4ef6\u540d") @ApiParam(value="\u6587\u4ef6\u540d") String fileName, @ApiParam(value="\u4e0a\u4f20\u65b9\u5f0f\uff0c user\u4e2a\u4eba/proc\u6d41\u7a0b") @ApiParam(value="\u4e0a\u4f20\u65b9\u5f0f\uff0c user\u4e2a\u4eba/proc\u6d41\u7a0b") String upType, @ApiParam(value="\u4efb\u52a1\u7f16\u53f7") @ApiParam(value="\u4efb\u52a1\u7f16\u53f7") String jobNo, @ApiParam(value="\u9875\u7801") @ApiParam(value="\u9875\u7801") Integer page, @ApiParam(value="\u5927\u5c0f") @ApiParam(value="\u5927\u5c0f") Integer size, @ApiParam(value="\u6807\u7b7e") @ApiParam(value="\u6807\u7b7e") String fileTag) {
        if (page != null) {
            page = page - 1;
        }
        if (page == null || page <= 0) {
            page = 0;
        }
        if (size == null || size <= 0) {
            size = 15;
        }
        if (size > 100) {
            size = 100;
        }
        try {
            FileQueryVO queryVO = new FileQueryVO(fileName, upType, jobNo, page, size, fileTag);
            return ShareFileServiceHelper.pyLoadFile((FileQueryVO)queryVO);
        }
        catch (Exception e) {
            CustomApiResult customApiResult = new CustomApiResult();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)e.getMessage(), (Integer)-1));
            log.error(e.getMessage());
            return customApiResult;
        }
    }

    @ApiPostMapping(value="/share/file/deleteFile", desc="\u5220\u9664\u6587\u4ef6")
    public CustomApiResult<ISearchCustomApiResultVO> deleteShareFile(@ApiRequestBody ShareFileDelModel fileDel) {
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            ShareFileServiceHelper.shareFileDelete((ShareFileDelModel)fileDel);
        }
        catch (KDException e) {
            ErrorCode errorCode = e.getErrorCode();
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)errorCode.getMessage(), (Integer)Integer.parseInt(errorCode.getCode())));
            log.error(errorCode.getMessage());
            return customApiResult;
        }
        return CustomApiResult.success((Object)ISearchCustomApiResultVO.ok());
    }

    @ApiGetMapping(value="/share/file/download", desc="\u4e0b\u8f7d\u6587\u4ef6")
    public CustomApiResult<ISearchCustomApiResultVO> downloadShareFile(@ApiParam(value="\u4e0a\u4f20\u65b9\u5f0f\uff0c user\u4e2a\u4eba/proc\u6d41\u7a0b") @ApiParam(value="\u4e0a\u4f20\u65b9\u5f0f\uff0c user\u4e2a\u4eba/proc\u6d41\u7a0b") String upType, @ApiParam(value="\u6587\u4ef6\u540d,\u5f85\u540e\u7f00\u540d\u4f1a\u533a\u5206\u540e\u7f00\u641c\u7d22", required=true) @ApiParam(value="\u6587\u4ef6\u540d,\u5f85\u540e\u7f00\u540d\u4f1a\u533a\u5206\u540e\u7f00\u641c\u7d22", required=true) String fileName, @ApiParam(value="\u4efb\u52a1\u7f16\u53f7") @ApiParam(value="\u4efb\u52a1\u7f16\u53f7") String jobNo, @ApiParam(value="\u662f\u5426\u6700\u65b0\u7248\u672c, \u9ed8\u8ba4true", required=true) @ApiParam(value="\u662f\u5426\u6700\u65b0\u7248\u672c, \u9ed8\u8ba4true", required=true) String isLaster) {
        ShareFileSimpleDownModel simpleDown = new ShareFileSimpleDownModel();
        simpleDown.setFileName(fileName);
        simpleDown.setUpType(upType);
        simpleDown.setJobNo(jobNo);
        simpleDown.setIsLaster(isLaster);
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            DynamicObject shareFile = ShareFileServiceHelper.queryOneFile((ShareFileSimpleDownModel)simpleDown);
            if (null == shareFile) {
                customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCodeMsg(), (Integer)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCode()));
                return customApiResult;
            }
            HashMap<String, String> file = new HashMap<String, String>();
            String oneAttachments = IsearchFileUtils.getOneAttachments((String)"ysq_rpa_sfile", (Long)shareFile.getLong("id"));
            file.put("fileName", shareFile.getString("ysq_file_name"));
            file.put("url", oneAttachments);
            if (StringUtils.isNotEmpty((CharSequence)oneAttachments)) {
                customApiResult.setData((Object)ISearchCustomApiResultVO.success(file));
            } else {
                customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCodeMsg(), (Integer)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCode()));
            }
            String commToken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
            if (StringUtils.isEmpty((CharSequence)commToken)) {
                EsUtils.addFileEsIndex((Long)shareFile.getLong("id"), (String)shareFile.getString("ysq_file_name"), (String)OperateFileLog.Type.STUDIO_DOWNLOUD.getType(), null, (Long)UserUtils.getCurrUserId(), (Long)shareFile.getLong("ysq_org_id"), (String)shareFile.getString("ysq_agent_alias"));
            } else {
                CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commToken);
                if (null == agent) {
                    agent = new CdaAgentVO();
                    agent.setAgentAlias(shareFile.getString("ysq_agent_alias"));
                }
                QFilter jobNoFilter = new QFilter("ysq_job_no", "=", (Object)jobNo);
                DynamicObject job = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{jobNoFilter});
                DynamicObject process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
                process.set("ysq_proc_name", job.get("ysq_proc_name"));
                process.set("ysq_proc_code", job.get("ysq_proc_code"));
                EsUtils.addFileEsIndex((Long)shareFile.getLong("id"), (String)shareFile.getString("ysq_file_name"), (String)OperateFileLog.Type.AGENT_DOWNLOUD.getType(), (DynamicObject)process, (Long)UserUtils.getCurrUserId(), (Long)shareFile.getLong("ysq_org_id"), (String)agent.getAgentAlias());
            }
        }
        catch (KDException e) {
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)e.getMessage(), (Integer)Integer.parseInt(e.getErrorCode().getCode())));
        }
        return customApiResult;
    }

    @ApiGetMapping(value="/share/file/batchDownload", desc="\u6279\u91cf\u4e0b\u8f7d\u6587\u4ef6")
    public CustomApiResult<ISearchCustomApiResultVO> batchDownloadShareFile(@ApiParam(value="\u4e0a\u4f20\u65b9\u5f0f\uff0c user\u4e2a\u4eba/proc\u6d41\u7a0b") @ApiParam(value="\u4e0a\u4f20\u65b9\u5f0f\uff0c user\u4e2a\u4eba/proc\u6d41\u7a0b") String upType, @ApiParam(value="\u6587\u4ef6\u540d,\u5f85\u540e\u7f00\u540d\u4f1a\u533a\u5206\u540e\u7f00\u641c\u7d22", required=true) @ApiParam(value="\u6587\u4ef6\u540d,\u5f85\u540e\u7f00\u540d\u4f1a\u533a\u5206\u540e\u7f00\u641c\u7d22", required=true) String fileName, @ApiParam(value="\u4efb\u52a1\u7f16\u53f7") @ApiParam(value="\u4efb\u52a1\u7f16\u53f7") String jobNo, @ApiParam(value="\u6587\u4ef6\u6807\u7b7e\uff0c\u9017\u53f7\u5206\u9694\uff0c\u6700\u591a5\u4e2a") @ApiParam(value="\u6587\u4ef6\u6807\u7b7e\uff0c\u9017\u53f7\u5206\u9694\uff0c\u6700\u591a5\u4e2a") String fileTag) {
        ShareFileBatchDownModel batchDown = new ShareFileBatchDownModel();
        batchDown.setFileName(fileName.toLowerCase());
        batchDown.setUpType(upType);
        batchDown.setJobNo(jobNo);
        batchDown.setFileTag(fileTag);
        CustomApiResult customApiResult = new CustomApiResult();
        try {
            DynamicObject[] shareFileList = ShareFileServiceHelper.queryFileList((ShareFileBatchDownModel)batchDown);
            if (shareFileList.length == 0) {
                customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCodeMsg(), (Integer)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCode()));
                return customApiResult;
            }
            String commToken = (String)ServiceApiContext.getRequest().getRequestHeaders().get("commtoken");
            ArrayList urls = new ArrayList();
            QFilter jobNoFilter = new QFilter("ysq_job_no", "=", (Object)jobNo);
            DynamicObject job = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{jobNoFilter});
            for (DynamicObject shareFile : shareFileList) {
                HashMap<String, String> file = new HashMap<String, String>();
                String oneAttachments = IsearchFileUtils.getOneAttachments((String)"ysq_rpa_sfile", (Long)shareFile.getLong("id"));
                if (StringUtils.isNotEmpty((CharSequence)oneAttachments)) {
                    file.put("fileName", shareFile.getString("ysq_file_name"));
                    file.put("url", oneAttachments);
                    urls.add(file);
                }
                if (StringUtils.isEmpty((CharSequence)commToken)) {
                    EsUtils.addFileEsIndex((Long)shareFile.getLong("id"), (String)shareFile.getString("ysq_file_name"), (String)OperateFileLog.Type.STUDIO_DOWNLOUD.getType(), null, (Long)UserUtils.getCurrUserId(), (Long)shareFile.getLong("ysq_org_id"), (String)shareFile.getString("ysq_agent_alias"));
                    continue;
                }
                CdaAgentVO agent = AgentServiceHelper.checkCommonToken((String)commToken);
                if (null == agent) {
                    agent = new CdaAgentVO();
                    agent.setAgentAlias(shareFile.getString("ysq_agent_alias"));
                }
                DynamicObject process = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
                if (job != null) {
                    process.set("ysq_proc_name", job.get("ysq_proc_name"));
                    process.set("ysq_proc_code", job.get("ysq_proc_code"));
                }
                EsUtils.addFileEsIndex((Long)shareFile.getLong("id"), (String)shareFile.getString("ysq_file_name"), (String)OperateFileLog.Type.AGENT_DOWNLOUD.getType(), (DynamicObject)process, (Long)UserUtils.getCurrUserId(), (Long)shareFile.getLong("ysq_org_id"), (String)agent.getAgentAlias());
            }
            if (urls.size() > 0) {
                customApiResult.setData((Object)ISearchCustomApiResultVO.success(urls));
            } else {
                customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCodeMsg(), (Integer)ResultStatusEnums.RPA_SHARE_FILE_NOEXIST.getCode()));
            }
        }
        catch (KDException e) {
            customApiResult.setData((Object)ISearchCustomApiResultVO.fail((String)e.getMessage(), (Integer)Integer.parseInt(e.getErrorCode().getCode())));
        }
        return customApiResult;
    }
}

