/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.controller.robot;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RedisCache;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.enums.RedisKeyItemsEnums;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.model.CdaAgentVO;
import ysq.rpac.rpamc.common.model.ISearchCustomApiResultVO;
import ysq.rpac.rpamc.common.model.LicenseVO;
import ysq.rpac.rpamc.common.model.dto.AgentDTO;
import ysq.rpac.rpamc.common.model.dto.ValidationVO;
import ysq.rpac.rpamc.common.status.agent.model.AgentChangeBean;
import ysq.rpac.rpamc.common.task.AgentChangeTask;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

@ApiController(value="standardRobot", desc="\u901a\u7528\u573a\u666f\u673a\u5668\u4eba")
public class ValidateLoginLicenseController {
    private RobotCache robotCache = RobotCache.getInstance();
    private RedisCache redisCache = RedisCache.getInstance();
    private static final Integer MAX_FAILED_TIMES = 10;

    @ApiGetMapping(value="/std-robot/license/validate", desc="\u901a\u7528\u573a\u666f\u673a\u5668\u4eba\u767b\u5f55\u8bb8\u53ef\u9a8c\u8bc1")
    public CustomApiResult<ISearchCustomApiResultVO> validateLicenseForLogin() {
        new AgentChangeTask().doTask();
        ValidationVO res = new ValidationVO();
        Boolean remain = LicenseUtils.remainingLicCheck((String)"standardRobot");
        LicenseVO licenseVO = LicenseUtils.licenseNums();
        Integer totalLic = licenseVO.getCsRobot();
        ArrayList<AgentDTO> list = new ArrayList<AgentDTO>();
        if (totalLic == 0) {
            return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)"\u65e0\u53ef\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u7ba1\u7406\u5458\u3002", (Integer)1));
        }
        if (!remain.booleanValue()) {
            DynamicObject[] models;
            QFilter typeFilter = new QFilter("ysq_agent_type", "=", (Object)"standardRobot");
            QFilter statusFilter = new QFilter("ysq_data_status", "!=", (Object)RoborDataStatusEnums.RUNNING.getCode());
            for (DynamicObject model : models = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])new QFilter[]{typeFilter, statusFilter})) {
                AgentDTO agentDTO = new AgentDTO(Long.valueOf(model.getLong("id")), model.getString("ysq_agent_alias"));
                list.add(agentDTO);
            }
        }
        if (totalLic == 1) {
            if (list.size() > 1) {
                return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)"\u670d\u52a1\u5668\u51fa\u9519", (Integer)5002));
            }
            res.setSingle(Boolean.valueOf(true));
        } else if (totalLic > 1) {
            res.setSingle(Boolean.valueOf(false));
        }
        res.setHasLic(remain);
        res.setAgentList(list);
        return CustomApiResult.success((Object)ISearchCustomApiResultVO.success((Object)res));
    }

    @ApiGetMapping(value="/std-robot/agent/unbind", desc="\u89e3\u7ed1\u673a\u5668\u4eba")
    public CustomApiResult<ISearchCustomApiResultVO> unbindAgent(@ApiParam(value="\u673a\u5668\u4ebaid") @ApiParam(value="\u673a\u5668\u4ebaid") Long agentId) {
        if (agentId == null) {
            return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)"\u53c2\u6570\u673a\u5668\u4ebaid\u4e3a\u7a7a", (Integer)1));
        }
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)agentId, (String)"ysq_rpa_agent");
        }
        catch (Exception e) {
            return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)"\u89e3\u7ed1\u5931\u8d25,\u4e0d\u5b58\u5728\u6b64\u7ec8\u7aef", (Integer)1));
        }
        new AgentChangeTask().doTask();
        QFilter typeFilter = new QFilter("ysq_agent_type", "=", (Object)"standardRobot");
        QFilter statusFilter = new QFilter("ysq_data_status", "=", (Object)RoborDataStatusEnums.RUNNING.getCode());
        QFilter idFilter = new QFilter("id", "=", (Object)agentId);
        DynamicObject[] models = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])new QFilter[]{idFilter, typeFilter, statusFilter});
        if (models.length > 0) {
            return CustomApiResult.success((Object)ISearchCustomApiResultVO.fail((String)"\u89e3\u7ed1\u5931\u8d25,\u6b64\u7ec8\u7aef\u6b63\u5728\u8fd0\u884c\u4e2d", (Integer)1));
        }
        String commtoken = dynamicObject.get("ysq_comm_token").toString();
        if (StringUtils.isNotBlank((CharSequence)commtoken)) {
            this.robotCache.remove(commtoken);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)agentId);
        DeleteServiceHelper.delete((String)"ysq_rpa_agent", (QFilter[])new QFilter[]{qFilter});
        return CustomApiResult.success((Object)ISearchCustomApiResultVO.ok());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStatus() {
        AgentChangeBean cacheBean = (AgentChangeBean)this.redisCache.pop(RedisKeyItemsEnums.ROBOT_STATUS_MODIFY_H.getKey(), AgentChangeBean.class);
        Long agentId = cacheBean.getAgentId();
        Date lastHeartTime = cacheBean.getLastHeartTime();
        String dataStatus = cacheBean.getDataStatus();
        cacheBean.addFailedTimes();
        int failedTimes = cacheBean.getFailedTimes();
        boolean isTrue = false;
        try {
            if (failedTimes > MAX_FAILED_TIMES) {
                isTrue = true;
                return;
            }
            DynamicObject agentObj = BusinessDataServiceHelper.loadSingle((Object)agentId, (String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds());
            agentObj.set("ysq_data_status", (Object)dataStatus);
            agentObj.set("ysq_last_heart_time", (Object)lastHeartTime);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentObj});
            this.robotCache.put(agentObj.getString("ysq_comm_token"), new CdaAgentVO().fromDynamicObject(agentObj));
            isTrue = true;
        }
        catch (Exception exception) {
        }
        finally {
            if (failedTimes <= MAX_FAILED_TIMES && !isTrue) {
                this.redisCache.rightPush(RedisKeyItemsEnums.ROBOT_STATUS_MODIFY_H.getKey(), SerializationUtils.toJsonString((Object)cacheBean));
            }
        }
    }
}

