/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.utils.LicenseUtils;
import ysq.rpac.rpamc.common.utils.PermOrgsUtils;

public class AgentBindPlugin
extends AbstractFormPlugin {
    private static String keyButton = "btnok";
    private static String keyUser = "ysq_user";
    private static String ysqCboxRobot = "ysq_cbox_robot";
    private static String ysqCboxStudio = "ysq_cbox_studio";
    private static RobotCache robotCache = RobotCache.getInstance();
    private static String masterid = "masterid";
    private static Log log = LogFactory.getLog(AgentBindPlugin.class);

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)keyUser, (CharSequence)fieldKey)) {
            ChangeData[] change = e.getChangeSet();
            DynamicObject newValue = (DynamicObject)change[0].getNewValue();
            Long userId = (Long)newValue.get(masterid);
            IDataModel model = this.getModel();
            QFilter userFilter = new QFilter("creator", "=", (Object)userId);
            QFilter robotFilter = new QFilter("ysq_agent_type", "=", (Object)"assistant");
            boolean robotExists = QueryServiceHelper.exists((String)"ysq_rpa_agent", (QFilter[])new QFilter[]{userFilter, robotFilter});
            if (robotExists) {
                model.setValue(ysqCboxRobot, (Object)true);
            } else {
                model.setValue(ysqCboxRobot, (Object)false);
            }
            QFilter studioFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
            boolean studioExists = QueryServiceHelper.exists((String)"ysq_rpa_agent", (QFilter[])new QFilter[]{userFilter, studioFilter});
            if (studioExists) {
                model.setValue(ysqCboxStudio, (Object)true);
            } else {
                model.setValue(ysqCboxStudio, (Object)false);
            }
        }
        super.propertyChanged(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getView().getControl(keyButton);
        button.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)keyButton, (CharSequence)key)) {
            QFilter typeQFilter;
            QFilter fidQFilter;
            DynamicObjectCollection query;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObject user = (DynamicObject)dataEntity.get(keyUser);
            if (user == null) {
                this.getView().showTipNotification("\u672a\u9009\u62e9\u201c\u7528\u6237\u201d\u3002");
                evt.setCancel(true);
                return;
            }
            Boolean isRobot = (Boolean)this.getModel().getValue(ysqCboxRobot);
            Boolean isStudio = (Boolean)this.getModel().getValue(ysqCboxStudio);
            Long userId = (Long)user.get("id");
            if (isRobot.booleanValue() && !LicenseUtils.remainingLicCheck((String)"assistant") && (query = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{fidQFilter = new QFilter("creator", "=", (Object)userId), typeQFilter = new QFilter("ysq_agent_type", "=", (Object)"assistant")})).size() == 0) {
                this.getView().showTipNotification("\u6709\u4eba\u503c\u5b88\u673a\u5668\u4eba\u65e0\u53ef\u7528\u8bb8\u53ef\u3002");
                evt.setCancel(true);
                return;
            }
            if (isStudio.booleanValue() && !LicenseUtils.remainingLicCheck((String)"studio") && (query = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{fidQFilter = new QFilter("creator", "=", (Object)userId), typeQFilter = new QFilter("ysq_agent_type", "=", (Object)"studio")})).size() == 0) {
                this.getView().showTipNotification("\u8bbe\u8ba1\u5668\u65e0\u53ef\u7528\u8bb8\u53ef\u3002");
                evt.setCancel(true);
                return;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)keyButton, (CharSequence)key)) {
            this.bindOk(control);
        }
    }

    private void bindOk(Control control) {
        DynamicObject agent;
        String feild;
        QFilter[] filters;
        QFilter userFilter;
        QFilter agentTypeFilter;
        IDataModel model = control.getModel();
        Boolean assistant = (Boolean)model.getValue("ysq_cbox_robot");
        Boolean boxStudio = (Boolean)model.getValue("ysq_cbox_studio");
        DynamicObject user = (DynamicObject)model.getValue(keyUser);
        if (user == null) {
            this.getView().showTipNotification("\u672a\u9009\u62e9\u201c\u7528\u6237\u201d\u3002");
            return;
        }
        Long userId = (Long)user.get("id");
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        List userInfoList = UserServiceHelper.get(userIds);
        if (CollectionUtils.isEmpty((Collection)userInfoList)) {
            this.getView().showTipNotification("\u6240\u9009\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
            return;
        }
        if (Boolean.TRUE.equals(assistant)) {
            agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"assistant");
            userFilter = new QFilter("creator", "=", (Object)userId);
            filters = new QFilter[]{userFilter, agentTypeFilter};
            feild = YsqAgentConstant.selAllFileds();
            agent = null;
            try {
                agent = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)feild, (QFilter[])filters);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                agent = null;
            }
            if (agent == null) {
                agent = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_agent");
                this.bindAgent(userInfoList, agent, "assistant");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agent});
            }
        } else {
            agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"assistant");
            userFilter = new QFilter("creator", "=", (Object)userId);
            filters = new QFilter[]{userFilter, agentTypeFilter};
            feild = YsqAgentConstant.selAllFileds();
            agent = null;
            try {
                agent = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)feild, (QFilter[])filters);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                agent = null;
            }
            if (agent != null) {
                String commtoken = agent.getString("ysq_comm_token");
                if (StringUtils.isNotBlank((CharSequence)commtoken)) {
                    robotCache.remove(commtoken);
                }
                DeleteServiceHelper.delete((String)"ysq_rpa_agent", (QFilter[])filters);
            }
        }
        if (Boolean.TRUE.equals(boxStudio)) {
            agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
            userFilter = new QFilter("creator", "=", (Object)userId);
            filters = new QFilter[]{userFilter, agentTypeFilter};
            feild = YsqAgentConstant.selAllFileds();
            agent = null;
            try {
                agent = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_agent", (String)feild, (QFilter[])filters);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                agent = null;
            }
            if (agent == null) {
                agent = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_agent");
                this.bindAgent(userInfoList, agent, "studio");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agent});
            }
        } else {
            agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"studio");
            userFilter = new QFilter("creator", "=", (Object)userId);
            filters = new QFilter[]{userFilter, agentTypeFilter};
            DeleteServiceHelper.delete((String)"ysq_rpa_agent", (QFilter[])filters);
        }
        this.getView().returnDataToParent((Object)true);
        this.getView().close();
    }

    private void bindAgent(List<Map<String, Object>> userInfoList, DynamicObject agent, String type) {
        Map<String, Object> map = userInfoList.get(0);
        Long id = (Long)map.get("id");
        String name = map.get("name").toString();
        agent.set("ysq_agent_alias", (Object)name);
        agent.set("ysq_agent_type", (Object)type);
        agent.set("ysq_is_manager", (Object)"yes");
        agent.set("ysq_rpa_user_name", (Object)name);
        agent.set("ysq_status", (Object)"yes");
        agent.set("ysq_under_managerment", (Object)"no");
        agent.set("ysq_auto_login", (Object)"no");
        agent.set("modifier", (Object)id);
        agent.set("creator", (Object)id);
        agent.set("org", (Object)PermOrgsUtils.agentNewOrgId((Long)id, null));
        agent.set("ysq_agent_no", (Object)id.toString());
        if (!StringUtils.equals((CharSequence)type, (CharSequence)"studio")) {
            agent.set("ysq_data_status", (Object)RoborDataStatusEnums.OFFLINE.getCode());
        } else {
            agent.set("ysq_data_status", (Object)"-");
        }
        agent.set("createtime", (Object)new Date());
        agent.set("modifytime", (Object)new Date());
    }
}

