/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.agent;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.cache.RobotCache;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.enums.RobotTypeEnums;
import ysq.rpac.rpamc.common.model.CdaAgentVO;

public class AgentInfoFormPlugin
extends AbstractFormPlugin {
    public static final String IS_MANAGER_YES = "yes";
    public static final String IS_MANAGER_YES_TAG = "\u7ba1\u7406\u5458\u7ed1\u5b9a";
    public static final String IS_MANAGER_NO_TAG = "\u7528\u6237\u7ed1\u5b9a";
    public static final String YSQ_FORG_NAME = "ysq_forg_name";
    public static final String YSQ_USER_NAME = "ysq_user_name";
    private static String ysqAgentFid = "ysq_agent_fid";
    private static String keyYsqBinSave = "ysq_btnok";
    private RobotCache robotCache = RobotCache.getInstance();
    private static Log log = LogFactory.getLog(AgentInfoFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getView().getControl(keyYsqBinSave);
        button.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String id = null;
        if (customParams != null) {
            id = customParams.get("id").toString();
        }
        if (id != null) {
            DynamicObject dbData = null;
            try {
                dbData = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_agent");
            }
            catch (Exception exception) {
                log.debug(exception.getMessage());
                dbData = null;
            }
            if (null == dbData) {
                return;
            }
            String alias = dbData.getString("ysq_agent_alias");
            String status = dbData.getString("ysq_data_status");
            String value = RoborDataStatusEnums.getValue((String)status);
            String agentNo = dbData.getString("ysq_agent_no");
            String agentName = dbData.getString("ysq_agent_name");
            String manager = dbData.getString("ysq_is_manager");
            String agentType = dbData.getString("ysq_agent_type");
            String userName = dbData.getString(YSQ_USER_NAME);
            agentType = StringUtils.isNotBlank((CharSequence)agentType) ? RobotTypeEnums.getValue((String)agentType) : "";
            manager = IS_MANAGER_YES.equals(manager) ? IS_MANAGER_YES_TAG : IS_MANAGER_NO_TAG;
            String verSion = dbData.getString("ysq_agent_version");
            String os = dbData.getString("ysq_agent_os");
            String ip = dbData.getString("ysq_agent_ip");
            String orgName = "";
            DynamicObject orgObj = dbData.getDynamicObject("org");
            if (orgObj != null) {
                orgName = orgObj.getString("name");
            }
            IDataModel model = this.getModel();
            model.setValue("ysq_agent_alias", (Object)alias);
            model.setValue("ysq_data_status", (Object)value);
            model.setValue("ysq_agent_no", (Object)agentNo);
            model.setValue(YSQ_FORG_NAME, (Object)orgName);
            model.setValue("ysq_agent_version", (Object)verSion);
            model.setValue("ysq_agent_name", (Object)agentName);
            model.setValue("ysq_agent_os", (Object)os);
            model.setValue("ysq_agent_ip", (Object)ip);
            model.setValue(YSQ_USER_NAME, (Object)userName);
            model.setValue("ysq_agent_type", (Object)agentType);
            model.setValue(ysqAgentFid, (Object)id);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)keyYsqBinSave)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long lid = dataEntity.getLong(ysqAgentFid);
            String alias = dataEntity.getString("ysq_agent_alias");
            DynamicObject dbData = null;
            try {
                dbData = BusinessDataServiceHelper.loadSingle((Object)lid, (String)"ysq_rpa_agent");
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                dbData = null;
            }
            if (null == dbData) {
                return;
            }
            dbData.set("ysq_agent_alias", (Object)alias);
            SaveServiceHelper.update((DynamicObject)dbData);
            this.robotCache.put(dbData.getString("ysq_comm_token"), new CdaAgentVO().fromDynamicObject(dbData));
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }
}

