/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.container.Container;
import kd.bos.form.control.Hyperlink;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.utils.StringUtil;

public class AppCenterFormPlugin
extends AbstractFormPlugin {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String YSQ_FLEX_TITLE = "ysq_flex_title";
    private static final String YSQ_FLEX_CHAR = "ysq_flex_char";
    private static final String YSQ_FLEX_NOTE = "ysq_flex_note";
    private static final String YSQ_FLEX_SCOPE = "ysq_flex_scope";
    private static final String YSQ_LABEL_APP_NAME = "ysq_label_app_name";
    private static final String YSQ_LABEL_LAUNCH_DATE = "ysq_label_launch_date";
    private static final String YSQ_LABEL_DEV_COM_NAME = "ysq_label_dev_com_name";
    private static final String YSQ_FLEX_APP_CHARACTER = "ysq_flex_app_character";
    private static final String YSQ_HYPER = "ysq_hyper";
    private static final String YSQ_CLOSEBACK_NOTIFY = "ysq_closeback_notify";
    private static String ysqProcCode = "ysq_proc_code";

    public void beforeBindData(EventObject e) {
        int i;
        String special;
        Label label;
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Object ysq_app_name = model.getValue("ysq_app_name");
        Object ysq_launch_date = model.getValue("ysq_launch_date");
        Object ysq_dev_com_name = model.getValue("ysq_dev_com_name");
        Object ysqAppUseHelper = model.getValue("ysq_app_use_helper_tag");
        Object openSourceObj = model.getValue("ysq_app_open_source");
        Object specialObj = model.getValue("ysq_app_special");
        Object priceObj = model.getValue("ysq_app_price");
        if (ObjectUtils.isNotEmpty((Object)ysq_app_name)) {
            label = (Label)this.getView().getControl(YSQ_LABEL_APP_NAME);
            label.setText(ysq_app_name.toString());
        }
        if (ObjectUtils.isNotEmpty((Object)ysq_launch_date)) {
            String launchDate = String.valueOf(ysq_launch_date);
            Label label2 = (Label)this.getView().getControl(YSQ_LABEL_LAUNCH_DATE);
            label2.setText("\u4e0a\u67b6\u65f6\u95f4\uff1a" + launchDate.substring(0, 10));
        }
        if (ObjectUtils.isNotEmpty((Object)ysq_dev_com_name)) {
            label = (Label)this.getView().getControl(YSQ_LABEL_DEV_COM_NAME);
            label.setText("\u5f00\u53d1\u5546\uff1a" + ysq_dev_com_name);
        }
        Container titleContainer = (Container)this.getView().getControl(YSQ_FLEX_TITLE);
        ArrayList<Map> titleItems = new ArrayList<Map>();
        ArrayList<String> labelList = new ArrayList<String>();
        if (openSourceObj != null) {
            String open = openSourceObj.toString();
            if ("yes".equals(open)) {
                labelList.add("\u5f00\u6e90");
            } else {
                labelList.add("\u52a0\u5bc6");
            }
        }
        if (specialObj != null && "yes".equals(special = specialObj.toString())) {
            labelList.add("\u4e13\u7528");
        }
        for (i = 0; i < labelList.size(); ++i) {
            titleContainer.deleteControls(new String[]{"label" + i});
        }
        for (i = 0; i < labelList.size(); ++i) {
            LabelAp labelAp = new LabelAp();
            labelAp.setId("label" + i);
            labelAp.setKey("label" + i);
            labelAp.setName(new LocaleString((String)labelList.get(i)));
            labelAp.setParentId(YSQ_FLEX_TITLE);
            Style style = labelAp.getStyle();
            if (style == null) {
                style = new Style();
            }
            Margin margin = new Margin();
            margin.setLeft("20px");
            style.setMargin(margin);
            Padding padding = new Padding();
            padding.setLeft("8px");
            padding.setRight("8px");
            style.setPadding(padding);
            Border border = new Border();
            border.setLeft("5px");
            border.setRight("5px");
            border.setTop("2px");
            border.setBottom("2px");
            style.setBorder(border);
            labelAp.setStyle(style);
            labelAp.setForeColor("#ffffff");
            if (StringUtils.equals((CharSequence)"\u5f00\u6e90", (CharSequence)((CharSequence)labelList.get(i)))) {
                labelAp.setBackColor("#40bd6e");
            } else {
                labelAp.setBackColor("#108EE9");
            }
            labelAp.setRadius("9px");
            titleItems.add(labelAp.createControl());
        }
        titleContainer.addControls(titleItems);
        if (ysqAppUseHelper != null) {
            this.initAppDetails(ysqAppUseHelper.toString());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.isBlank((CharSequence)itemKey)) {
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.isBlank((CharSequence)itemKey)) {
            return;
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void initAppDetails(String appUseHelper) {
        this.log.info("AppCenter\u8868\u5355\u9875\u8981\u52a0\u8f7d\u7684\u8be6\u7ec6\u4fe1\u606f" + appUseHelper);
        if (StringUtils.isBlank((CharSequence)appUseHelper) || !StringUtil.isJsonObject((String)appUseHelper)) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)appUseHelper);
        JSONObject appCharacter = jsonObject.getJSONObject("appCharacter");
        JSONArray appScope = jsonObject.getJSONArray("appScope");
        JSONArray appMore = jsonObject.getJSONArray("appMore");
        JSONArray main = appCharacter.getJSONArray("main");
        JSONArray note = appCharacter.getJSONArray("note");
        Object[] appCharMainArray = main.stream().toArray();
        Object[] appCharNoteArray = note.stream().toArray();
        Object[] appScopeArray = appScope.stream().toArray();
        this.loadLabel("label_char_main", YSQ_FLEX_CHAR, appCharMainArray, 13);
        this.loadLabel("label_char_note", YSQ_FLEX_NOTE, appCharNoteArray, 12);
        this.loadLabel("label_scope", YSQ_FLEX_SCOPE, appScopeArray, 13);
        HashMap<String, LocaleString> map = new HashMap<String, LocaleString>();
        if (!appMore.isEmpty()) {
            JSONObject appMoreJSONObject = appMore.getJSONObject(0);
            String moreName = appMoreJSONObject.getString("name");
            String moreHref = appMoreJSONObject.getString("href");
            Hyperlink ysqHyper = (Hyperlink)this.getControl(YSQ_HYPER);
            ysqHyper.setUrl(moreHref);
            map.put("text", new LocaleString(moreName));
        }
        this.getView().updateControlMetadata(YSQ_HYPER, map);
    }

    private void loadLabel(String labelKey, String flexId, Object[] dataArray, int fontSize) {
        int i;
        Container container = (Container)this.getView().getControl(flexId);
        ArrayList<Map> charLabelItems = new ArrayList<Map>();
        for (i = 0; i < dataArray.length; ++i) {
            container.deleteControls(new String[]{labelKey + i});
        }
        for (i = 0; i < dataArray.length; ++i) {
            LabelAp labelAp = new LabelAp();
            labelAp.setId(labelKey + i);
            labelAp.setKey(labelKey + i);
            labelAp.setName(new LocaleString(dataArray[i].toString()));
            labelAp.setParentId(flexId);
            labelAp.setFontSize(fontSize);
            labelAp.setForeColor("#aaaaaa");
            Style style = labelAp.getStyle();
            if (style == null) {
                style = new Style();
            }
            Padding padding = new Padding();
            padding.setLeft("22px");
            padding.setTop("5px");
            padding.setBottom("5px");
            style.setPadding(padding);
            labelAp.setStyle(style);
            charLabelItems.add(labelAp.createControl());
        }
        container.addControls(charLabelItems);
    }
}

