/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.app;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.AttachmentMarkEvent;
import kd.bos.form.control.events.AttachmentMarkListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.FileNameUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.model.ParamsVo;
import ysq.rpac.rpamc.common.model.dto.ParamDTO;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.StringUtil;

public class AppFileUploadPlugin
extends AbstractFormPlugin
implements UploadListener,
AttachmentMarkListener {
    private static Log log = LogFactory.getLog(AppFileUploadPlugin.class);
    private static final String key = "d6f0031cf47ca9bd";
    private static final String YSQ_IPKG_INFO_TAG = "ysq_ipkg_info_tag";
    private static final String YSQ_FILE_PATH_LIST = "ysq_file_path_list";
    private static final String YSQ_APP_MINE_ID = "ysq_app_mine_id";

    public void registerListener(EventObject e) {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("ysq_attachmentpanelap");
        panel.addMarkListener((AttachmentMarkListener)this);
        panel.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        this.getModel().setValue(YSQ_IPKG_INFO_TAG, (Object)"");
        this.getModel().setValue(YSQ_FILE_PATH_LIST, (Object)"");
        this.getModel().setValue(YSQ_APP_MINE_ID, (Object)"");
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList<String> fileUrls = new ArrayList<String>();
        Map<String, Object> map = null;
        String urlStr = null;
        for (Object url : evt.getUrls()) {
            urlStr = (String)((Map)url).get("url");
            fileUrls.add(urlStr);
        }
        for (String fileUrl : fileUrls) {
            if (!StringUtils.isNotBlank((CharSequence)fileUrl) || (map = this.urlToStream(fileUrl)) == null) continue;
            Map appInfo = MapUtils.getMap(map, (Object)"proAppInfos");
            String procCode = MapUtils.getString((Map)appInfo, (Object)"appSn");
            DynamicObject appMineObj = QueryServiceHelper.queryOne((String)"ysq_app_mine", (String)"id", (QFilter[])new QFilter[]{new QFilter("ysq_proc_code", "=", (Object)procCode)});
            if (appMineObj == null) {
                long appMineId = ID.genLongId();
                this.getModel().setValue(YSQ_APP_MINE_ID, (Object)appMineId);
            } else {
                this.getModel().setValue(YSQ_APP_MINE_ID, (Object)appMineObj.getLong("id"));
            }
            this.uploadDefValueFile(map, fileUrl);
        }
        if (map != null) {
            Control control = (Control)evt.getSource();
            IDataModel model = control.getModel();
            model.setValue("ysq_proc_file", (Object)urlStr);
            model.setValue("ysq_proc_code", map.get("proCode"));
            model.setValue("ysq_last_version", map.get("proVersion"));
            model.setValue("ysq_app_explain", map.get("proDesc"));
            model.setValue("ysq_pro_change", map.get("proChange"));
            model.setValue("ysq_studio_ver", map.get("proStudio"));
            String params = (String)map.get("Inputs");
            if (StringUtils.isNotBlank((CharSequence)params) && !StringUtils.equals((CharSequence)params, (CharSequence)"[]")) {
                model.setValue("ysq_param_tag", map.get("Inputs"));
            }
            Map proAppExteInfoMap = (Map)map.get("proAppExteInfos");
            model.setValue("ysq_app_name", (Object)MapUtils.getString((Map)proAppExteInfoMap, (Object)"appName"));
            model.setValue(YSQ_IPKG_INFO_TAG, (Object)JSONObject.toJSONString(map));
        }
    }

    public void remove(UploadEvent evt) {
        String paramDTOJson = (String)this.getModel().getValue(YSQ_FILE_PATH_LIST);
        if (StringUtils.isNotBlank((CharSequence)paramDTOJson) && StringUtil.isJSON((String)paramDTOJson)) {
            List paramDTOS = JSONObject.parseArray((String)paramDTOJson, ParamDTO.class);
            for (ParamDTO paramDTO : paramDTOS) {
                String filePath = paramDTO.getFilePath();
                FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                attachmentFileService.delete(filePath);
            }
        }
    }

    public void mark(AttachmentMarkEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> urlToStream(String url) {
        InputStream inStream = null;
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        Map map = null;
        try {
            String[] queryParams = new URL(url).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>();
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            map = IsearchFileUtils.readIpkgFile((InputStream)inStream);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\u3002");
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\u3002");
            }
        }
        return map;
    }

    private void uploadDefValueFile(Map<String, Object> ipkgInfoMap, String url) {
        if (ipkgInfoMap.containsKey("Inputs") && ipkgInfoMap.containsKey("proAppInfos")) {
            ArrayList<ParamDTO> fileParamList = new ArrayList<ParamDTO>();
            String procParams = MapUtils.getString(ipkgInfoMap, (Object)"Inputs");
            String globalVar = MapUtils.getString(ipkgInfoMap, (Object)"GlobalVar");
            List paramsVos = IsearchFileUtils.analysisParam((String)procParams, (String)globalVar);
            for (ParamsVo paramsVo : paramsVos) {
                if (!StringUtils.equals((CharSequence)paramsVo.getParamsType(), (CharSequence)"file")) continue;
                ParamDTO paramDTO = new ParamDTO();
                paramDTO.setParamName(paramsVo.getParamsName());
                paramDTO.setFileName(paramsVo.getParamsDefValue());
                fileParamList.add(paramDTO);
            }
            if (CollectionUtils.isNotEmpty(fileParamList)) {
                Object line = null;
                InputStream inStream = null;
                TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
                try {
                    String[] queryParams = new URL(url).getQuery().split("&");
                    HashMap<String, String> downloadFileParams = new HashMap<String, String>();
                    for (String queryParam : queryParams) {
                        String[] p = queryParam.split("=");
                        downloadFileParams.put(p[0], p[1]);
                    }
                    TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
                    inStream = content.getInputStream();
                }
                catch (Exception e) {
                    log.error("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\u3002");
                }
                ArrayList<ParamDTO> paramDTOS = new ArrayList<ParamDTO>();
                ZipEntry nextEntry = null;
                try (ZipInputStream zipInputStream = new ZipInputStream(inStream, Charset.forName("GBK"));){
                    while ((nextEntry = zipInputStream.getNextEntry()) != null) {
                        String name = nextEntry.getName();
                        name = "./" + name;
                        for (ParamDTO paramDTO : fileParamList) {
                            int len;
                            if (!StringUtils.equals((CharSequence)paramDTO.getFileName(), (CharSequence)name)) continue;
                            String[] split = name.split("/");
                            name = split[split.length - 1];
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] buffer = new byte[9000];
                            while ((len = zipInputStream.read(buffer)) != -1) {
                                baos.write(buffer, 0, len);
                            }
                            ByteArrayInputStream swapStream = new ByteArrayInputStream(baos.toByteArray());
                            String filePath = this.uploadFile(swapStream, name);
                            baos.close();
                            ParamDTO param = new ParamDTO();
                            param.setFilePath(filePath);
                            param.setFileName(name);
                            param.setParamName(paramDTO.getParamName());
                            paramDTOS.add(param);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.getModel().setValue(YSQ_FILE_PATH_LIST, (Object)JSONObject.toJSONString(paramDTOS));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadFile(InputStream is, String fileName) {
        String uploadPath = null;
        try {
            RequestContext context = RequestContext.get();
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            MainEntityType attaFiledEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_attachment");
            String tableName = attaFiledEntityType.getAlias();
            String[] ids = DBServiceHelper.genStringIds((String)tableName, (int)1);
            String attPk = null;
            if (ids != null && ids.length > 0) {
                attPk = ids[0];
            }
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String path = FileNameUtils.getAttachmentFileName((String)context.getTenantId(), (String)context.getAccountId(), (Object)attPk, (String)(uuid + "/" + fileName));
            FileItem fileItem = new FileItem(fileName, path, is);
            String string = uploadPath = fileService.upload(fileItem);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.close(is);
        }
        return uploadPath;
    }

    private void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

