/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAppCenterConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.model.dto.ParamDTO;
import ysq.rpac.rpamc.common.utils.IpkgUtils;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.StringUtil;

public class AppImportFormPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(AppImportFormPlugin.class);
    private static final String YSQ_BTN_SAVE = "ysq_btn_save";
    private static final String YSQ_BUT_EXIT = "ysq_but_exit";
    private static final String YSQ_ATTACHMENTPANELAP = "ysq_attachmentpanelap";
    private static final String KEY_PROCESS_DEIT_CHICK = "KEY_PROCESS_DEIT_CHICK";
    private static final String YSQ_APP_INFOS = "ysq_app_infos";
    private static final String YSQ_APP_EXTE_INFOS = "ysq_app_exte_infos";
    private static final String YSQ_IPKG_INFO_TAG = "ysq_ipkg_info_tag";
    public static final String YSQ_CLOSEBACK_AGREE = "ysq_closeback_agree";
    public static final String YSQ_CLOSEBACK_EXIT = "ysq_closeback_exit";
    private static final String YSQ_FILE_PATH_LIST = "ysq_file_path_list";
    private static final String YSQ_APP_MINE_ID = "ysq_app_mine_id";
    private static final String YSQ_IS_SAVE_SUCC = "ysq_is_save_succ";

    public void registerListener(EventObject e) {
        Button button = (Button)this.getView().getControl(YSQ_BTN_SAVE);
        button.addClickListener((ClickListener)this);
        Button exitButton = (Button)this.getView().getControl(YSQ_BUT_EXIT);
        exitButton.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        AttachmentPanel panel;
        List attachmentData;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.endsWith(YSQ_BTN_SAVE)) {
            this.checkData(control, evt);
            return;
        }
        if (key.endsWith(YSQ_BUT_EXIT) && (attachmentData = (panel = (AttachmentPanel)this.getControl(YSQ_ATTACHMENTPANELAP)).getAttachmentData()).size() != 0) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(YSQ_CLOSEBACK_EXIT, (IFormPlugin)this);
            this.getView().showConfirm("\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u4fee\u6539\u3002", MessageBoxOptions.OKCancel, confirmCallBackListener);
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.endsWith(YSQ_BTN_SAVE)) {
            this.getModel().setValue(YSQ_IS_SAVE_SUCC, (Object)"true");
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (YSQ_CLOSEBACK_AGREE.equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            this.getView().invokeOperation("donothing");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)KEY_PROCESS_DEIT_CHICK, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            AttachmentPanel panel = (AttachmentPanel)this.getControl(YSQ_ATTACHMENTPANELAP);
            List files = panel.getAttachmentData();
            this.saveFile(files, dataEntity);
            this.getView().invokeOperation("donothing");
            this.getModel().setValue(YSQ_IS_SAVE_SUCC, (Object)"true");
            this.getView().close();
        }
        if (StringUtils.equals((CharSequence)YSQ_CLOSEBACK_EXIT, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().invokeOperation("close");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isSaveSucc = (String)this.getModel().getValue(YSQ_IS_SAVE_SUCC);
        String paramDTOJson = (String)this.getModel().getValue(YSQ_FILE_PATH_LIST);
        if (StringUtils.equals((CharSequence)isSaveSucc, (CharSequence)"true")) {
            this.getView().returnDataToParent((Object)true);
        } else {
            this.getView().returnDataToParent((Object)paramDTOJson);
        }
    }

    private void checkData(Control control, BeforeClickEvent evt) {
        Map checkNoOpenIpkg;
        String ipkgIsOpen;
        FormDataModel model = (FormDataModel)control.getModel();
        DynamicObject dynamicObject = model.getDataEntity();
        AttachmentPanel panel = (AttachmentPanel)this.getControl(YSQ_ATTACHMENTPANELAP);
        dynamicObject.set("ysq_is_start_up", (Object)false);
        String ipkgInfo = dynamicObject.getString(YSQ_IPKG_INFO_TAG);
        String appSn = null;
        String appName = null;
        List files = panel.getAttachmentData();
        if (CollectionUtils.isEmpty((Collection)files)) {
            this.getView().showErrorNotification("\u6d41\u7a0b\u5305\u4e0d\u53ef\u4e3a\u7a7a\u3002");
            evt.setCancel(true);
            return;
        }
        if (StringUtils.isBlank((CharSequence)ipkgInfo)) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5408\u6cd5\u7684RPA\u6807\u51c6\u5e94\u7528\u3002");
            evt.setCancel(true);
            return;
        }
        HashMap appInfoMap = (HashMap)JSON.parseObject((String)ipkgInfo, HashMap.class);
        JSONObject appInfoObj = (JSONObject)appInfoMap.get("proAppInfos");
        JSONObject appExteInfoObj = (JSONObject)appInfoMap.get("proAppExteInfos");
        Map ipkgCheckResult = IpkgUtils.checkIpkgIsIntact((Map)appInfoMap);
        if (!MapUtils.getBoolean((Map)ipkgCheckResult, (Object)"result").booleanValue()) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5408\u6cd5\u7684RPA\u6807\u51c6\u5e94\u7528\u3002");
            evt.setCancel(true);
            return;
        }
        if (appInfoObj == null || appExteInfoObj == null || !appInfoObj.containsKey((Object)"appSn") || !appExteInfoObj.containsKey((Object)"appName")) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5408\u6cd5\u7684RPA\u6807\u51c6\u5e94\u7528\u3002");
            evt.setCancel(true);
            return;
        }
        HashMap proAppInfos = (HashMap)JSON.parseObject((String)appInfoObj.toString(), HashMap.class);
        HashMap proAppExteInfos = (HashMap)JSON.parseObject((String)appExteInfoObj.toString(), HashMap.class);
        appInfoMap.put("proAppInfos", proAppInfos);
        appInfoMap.put("proAppExteInfos", proAppExteInfos);
        String proVersion = MapUtils.getString((Map)appInfoMap, (Object)"proVersion");
        if (proVersion.length() < 1 || proVersion.length() > 11) {
            this.getView().showTipNotification("\u6d41\u7a0b\u7248\u672c\u8fc7\u957f\uff0c\u53ea\u80fd\u4e3a1~11\u5b57\u7b26");
            evt.setCancel(true);
            return;
        }
        appSn = MapUtils.getString((Map)proAppInfos, (Object)"appSn");
        if (this.checkProcName(appSn, appName = MapUtils.getString((Map)proAppExteInfos, (Object)"appName"))) {
            control.getView().showErrorNotification("\u201c\u6d41\u7a0b\u540d\u201d\u5df2\u5b58\u5728\u3002");
            evt.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)appSn);
        DynamicObject appCenter = QueryServiceHelper.queryOne((String)"ysq_app_center", (String)YsqAppCenterConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
        if (appCenter == null) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5408\u6cd5\u7684RPA\u6807\u51c6\u5e94\u7528\u3002");
            evt.setCancel(true);
            return;
        }
        int modeType = LicenseServiceHelper.getModeType();
        String ipkgProductType = MapUtils.getString((Map)proAppExteInfos, (Object)"productType");
        if (!StringUtils.equals((CharSequence)ipkgProductType, (CharSequence)(modeType + ""))) {
            this.getView().showErrorNotification("\u4fdd\u5b58\u5931\u8d25,\u8bf7\u6839\u636e\u5f53\u524d\u7cfb\u7edf\u7c7b\u578b\u4e0a\u4f20\u5bf9\u5e94\u7684\u5e94\u7528\u5305\u3002");
            evt.setCancel(true);
            return;
        }
        String appCenterIsOpen = appCenter.getString("ysq_app_open_source");
        if (!StringUtils.equals((CharSequence)appCenterIsOpen, (CharSequence)(ipkgIsOpen = MapUtils.getString((Map)proAppInfos, (Object)"isOpenSource")))) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5408\u6cd5\u7684RPA\u6807\u51c6\u5e94\u7528\u3002");
            evt.setCancel(true);
            return;
        }
        if ("no".equals(appCenterIsOpen) && !MapUtils.getBoolean((Map)(checkNoOpenIpkg = IpkgUtils.checkNoOpenIpkg((Map)appInfoMap)), (Object)"result").booleanValue()) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5408\u6cd5\u7684RPA\u6807\u51c6\u5e94\u7528\u3002");
            evt.setCancel(true);
            return;
        }
        String fileName = null;
        if (appSn != null) {
            String procCodeStr = appSn;
            QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCodeStr);
            QFilter procTypeFilter = new QFilter("ysq_proc_type", "!=", (Object)"standard");
            QFilter[] filters = new QFilter[]{procCodeFilter, procTypeFilter};
            DynamicObject proc = null;
            try {
                proc = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_process", (String)"id", (QFilter[])filters);
            }
            catch (Exception e) {
                log.debug(e.getMessage());
                proc = null;
            }
            if (proc != null) {
                control.getView().showErrorNotification("\u6d41\u7a0b\u5df2\u5b58\u5728\u3002\u8bf7\u5220\u9664\u540c\u540d\u6d41\u7a0b\u6216\u4fee\u6539\u6d41\u7a0b\u5305\u540d\u79f0\u540e\u518d\u4e0a\u4f20\u3002");
                evt.setCancel(true);
                return;
            }
            fileName = UUID.randomUUID().toString().replace("-", "") + ".ipkg";
            Map map = (Map)files.get(0);
            map.put("name", fileName);
            if (StringUtils.isNotBlank((CharSequence)fileName)) {
                dynamicObject.set("ysq_proc_file", (Object)("/doc/ipkg/" + fileName));
            }
            QFilter standProcFilter = new QFilter("ysq_proc_type", "=", (Object)"standard");
            QFilter[] procUserFilter = new QFilter[]{procCodeFilter, standProcFilter};
            DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])procUserFilter);
            if (query.size() > 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_PROCESS_DEIT_CHICK, (IFormPlugin)this);
                this.getView().showConfirm("\u5f53\u524d\u5e94\u7528\u5df2\u5b58\u5728\uff0c\u662f\u5426\u786e\u8ba4\u8986\u76d6\u66f4\u65b0\u5f53\u524d" + ((DynamicObject)query.get(0)).getString("ysq_proc_name") + "\u5e94\u7528\uff1f" + "\u5e94\u7528\u540d\u79f0\uff1a" + appName + "\uff1b\u5e94\u7528\u7248\u672c\uff1a" + proVersion, MessageBoxOptions.OKCancel, confirmCallBacks);
                evt.setCancel(true);
                return;
            }
        }
        this.saveFile(files, dynamicObject);
    }

    private void saveFile(List<Map<String, Object>> files, DynamicObject dynamicObject) {
        List paramDTOS;
        long procVerId = ID.genLongId();
        String procFile = null;
        String name = null;
        if (files == null || files.size() <= 0) {
            this.getView().showErrorNotification("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u5408\u6cd5\u7684RPA\u6807\u51c6\u5e94\u7528\u3002");
            return;
        }
        name = files.get(0).get("name").toString();
        procFile = files.get(0).get("url").toString();
        String filePath = AttachmentServiceHelper.saveTempToFileService((String)procFile, (String)"ysq_rpamc", (String)"ysq_rpa_process_ver", (Object)procVerId, (String)name);
        files.get(0).put("url", filePath);
        dynamicObject.set("ysq_fid", (Object)procVerId);
        AttachmentServiceHelper.upload((String)"ysq_rpa_process_ver", (Object)procVerId, (String)"attachmentpanel", files);
        long appMineFid = (Long)this.getModel().getValue(YSQ_APP_MINE_ID);
        AttachmentServiceHelper.remove((String)"ysq_app_mine", (Object)appMineFid);
        String paramDTOJson = (String)this.getModel().getValue(YSQ_FILE_PATH_LIST);
        if (StringUtils.isNotBlank((CharSequence)paramDTOJson) && StringUtil.isJSON((String)paramDTOJson) && CollectionUtils.isNotEmpty((Collection)(paramDTOS = JSONObject.parseArray((String)paramDTOJson, ParamDTO.class)))) {
            for (ParamDTO paramDTO : paramDTOS) {
                ArrayList fileList = new ArrayList();
                HashMap<String, Object> filePathMap = new HashMap<String, Object>();
                filePathMap.put("url", paramDTO.getFilePath());
                filePathMap.put("name", paramDTO.getFileName());
                filePathMap.put("size", 1000);
                filePathMap.put("uid", KdPageUtils.generateFileUID());
                fileList.add(filePathMap);
                AttachmentServiceHelper.upload((String)"ysq_app_mine", (Object)appMineFid, (String)paramDTO.getParamName(), fileList);
            }
        }
    }

    private boolean checkProcName(String procCode, String procName) {
        boolean flag = false;
        QFilter proCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])new QFilter[]{proCodeFilter});
        if (exists) {
            boolean procNameExists;
            QFilter procNameFilter = new QFilter("ysq_proc_name", "=", (Object)procName);
            QFilter procCodeFilter = new QFilter("ysq_proc_code", "!=", (Object)procCode);
            flag = procNameExists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])new QFilter[]{procNameFilter, procCodeFilter});
        } else {
            boolean procNameExists;
            QFilter qFilter = new QFilter("ysq_proc_name", "=", (Object)procName);
            flag = procNameExists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])new QFilter[]{qFilter});
        }
        return flag;
    }

    private Boolean inRouter(String procCode) {
        if (procCode == null || procCode.isEmpty()) {
            return false;
        }
        return true;
    }
}

