/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAppCenterConstant;
import ysq.rpac.rpamc.common.constant.YsqAppMineConstant;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.constant.YsqScheduleConstant;
import ysq.rpac.rpamc.common.enums.ProcessesStatusEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.servicehelper.AppMineServiceHelper;
import ysq.rpac.rpamc.common.servicehelper.ProcessServiceHelper;
import ysq.rpac.rpamc.common.status.job.core.JobStatusCache;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;

public class AppSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(AppSaveOpPlugin.class);
    public static final int COUNT = 100000;
    private static final String YSQ_IPKG_INFO_TAG = "ysq_ipkg_info_tag";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            DynamicObject[] load;
            Object lastVerObj = dynamicObject.get("ysq_last_version");
            String ipkgInfo = dynamicObject.getString(YSQ_IPKG_INFO_TAG);
            HashMap appInfoMap = (HashMap)JSON.parseObject((String)ipkgInfo, HashMap.class);
            JSONObject appInfoObj = (JSONObject)appInfoMap.get("proAppInfos");
            String appSn = appInfoObj.getString("appSn");
            QFilter appProcCodeFilter = new QFilter("ysq_proc_code", "=", (Object)appSn);
            DynamicObject appMine = QueryServiceHelper.queryOne((String)"ysq_app_mine", (String)YsqAppMineConstant.selAllFileds(), (QFilter[])new QFilter[]{appProcCodeFilter});
            if (appMine == null) {
                DynamicObject appCenter = QueryServiceHelper.queryOne((String)"ysq_app_center", (String)YsqAppCenterConstant.selAllFileds(), (QFilter[])new QFilter[]{appProcCodeFilter});
                AppMineServiceHelper.addAppCenter((DynamicObject)appCenter);
            }
            for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"ysq_app_mine", (String)YsqAppMineConstant.selAllFileds(), (QFilter[])new QFilter[]{appProcCodeFilter})) {
                object.set("ysq_last_version", (Object)lastVerObj.toString());
                object.set("ysq_status", (Object)"Activated");
            }
            SaveServiceHelper.update((DynamicObject[])load);
            this.saveAppMineVer(dynamicObject, appSn);
            String procVer = dynamicObject.getString("ysq_last_version");
            String procName = dynamicObject.getString("ysq_app_name");
            String procParam = dynamicObject.getString("ysq_param_tag");
            QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)appSn);
            QFilter[] procFilter = new QFilter[]{procCodeFilter};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"ysq_rpa_process", (String)"id", (QFilter[])procFilter);
            if (dynamicObjects.size() > 0) {
                AttachmentServiceHelper.remove((String)"ysq_rpa_process", (Object)((DynamicObject)dynamicObjects.get(0)).getLong("id"));
                QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)appSn);
                DeleteServiceHelper.delete((String)"ysq_rpa_process", (QFilter[])new QFilter[]{qFilter});
                DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process_ver", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (query.size() > 0) {
                    AttachmentServiceHelper.remove((String)"ysq_rpa_process_ver", (Object)((DynamicObject)query.get(0)).getLong("id"));
                }
                DeleteServiceHelper.delete((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{qFilter});
                this.saveProcess(dynamicObject, appSn);
                this.saveProcessVer(dynamicObject, appSn);
                this.uploadSchdule(appSn, procVer, procName, procParam);
                this.cancle(appSn);
                continue;
            }
            this.saveProcess(dynamicObject, appSn);
            this.saveProcessVer(dynamicObject, appSn);
        }
    }

    private void saveAppMineVer(DynamicObject dynamicObject, String appSn) {
        String version = dynamicObject.get("ysq_last_version").toString();
        String desc = dynamicObject.get("ysq_app_explain").toString();
        String procCode = dynamicObject.get("ysq_proc_code").toString();
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)appSn);
        DynamicObject appMineDO = BusinessDataServiceHelper.loadSingle((String)"ysq_app_mine", (String)(YsqAppMineConstant.selAllFileds() + ", " + "ysq_rpa_app_mine_ver" + "." + "ysq_app_ver_code" + "," + "ysq_rpa_app_mine_ver" + "." + "ysq_app_update_date" + ", " + "ysq_rpa_app_mine_ver" + "." + "ysq_app_update_content" + ", " + "ysq_rpa_app_mine_ver" + "." + "ysq_fk_proc_code" + ", " + "ysq_rpa_app_mine_ver" + "." + "seq" + "," + "ysq_rpa_app_mine_ver" + "." + "id"), (QFilter[])new QFilter[]{procCodeFilter});
        DynamicObject a = null;
        DynamicObjectCollection appMineVerCollection = null;
        if (appMineDO != null) {
            appMineVerCollection = appMineDO.getDynamicObjectCollection("ysq_rpa_app_mine_ver");
            if (appMineVerCollection.size() > 0) {
                for (DynamicObject object : appMineVerCollection) {
                    Object o = object.get("seq");
                    Integer sqeObj = Integer.valueOf(o.toString());
                    object.set("seq", (Object)(sqeObj + 1));
                }
            }
            a = appMineVerCollection.addNew();
            a.set("ysq_app_ver_code", (Object)version);
            a.set("ysq_fk_proc_code", (Object)appMineDO.getString("ysq_proc_code"));
            a.set("seq", (Object)1);
            a.set("ysq_app_update_date", (Object)new Date());
            a.set("ysq_app_update_content", (Object)desc);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appMineDO});
        }
    }

    private void cancle(String procCode) {
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        QFilter statusFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
        DynamicObject[] jobs = BusinessDataServiceHelper.load((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter, statusFilter});
        if (jobs != null && jobs.length > 0) {
            for (DynamicObject job : jobs) {
                String jobNo = job.getString("ysq_job_no");
                Long jobId = job.getLong("id");
                boolean isExist = RobotPendingJobProducer.getInstance().checkHasJob(jobNo, null);
                if (isExist) {
                    log.info("\u4efb\u52a1\u5df2\u88ab\u9886\u53d6\uff0c\u4ec5\u7b49\u5f85\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u4efb\u52a1\u53ef\u6267\u884c\u53d6\u6d88\u64cd\u4f5c\u3002");
                    continue;
                }
                boolean b = JobStatusCache.getInstance().handChacheStatusCheck(jobId, jobNo, RpaJobStatusEnums.PENDING.getCode(), ((Object)((Object)this)).getClass().getName());
                if (b) {
                    log.info("\u4fee\u6539\u52a8\u4f5c\u5df2\u63d0\u4ea4\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u3002");
                    continue;
                }
                try {
                    JobStatusCache.getInstance().handChacheStatus(jobId, jobNo, RpaJobStatusEnums.CANCELLED.getCode(), ((Object)((Object)this)).getClass().getName());
                }
                catch (Exception e) {
                    log.debug("exc: \u4efb\u52a1id\uff1a{}\uff0cjobNO\uff1a{}\uff0c\u8981\u6539\u6210\u72b6\u6001\uff1a{}\uff0c\u5df2\u63d0\u4ea4\uff0c\u672c\u6b21\u4e0d\u63d0\u4ea4\u961f\u5217\u3002\u4fee\u6539\u65f6\u95f4\uff1a{}", new Object[]{jobId, jobNo, RpaJobStatusEnums.CANCELLED.getCode(), new Date()});
                }
            }
        }
    }

    private void uploadSchdule(String procCode, String procVer, String procName, String procParam) {
        QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)YsqScheduleConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
        DynamicObject process = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"id", (QFilter[])new QFilter[]{qFilter});
        long procId = process.getLong("id");
        if (schedules != null && schedules.length > 0) {
            String paramBase64 = procParam;
            if (StringUtils.isNotBlank((CharSequence)procParam)) {
                paramBase64 = IsearchFileUtils.paramsBase64((String)procParam);
            }
            for (DynamicObject sch : schedules) {
                sch.set("ysq_proc_fid", (Object)procId);
                sch.set("ysq_proc_ver", (Object)procVer);
                sch.set("ysq_proc_name", (Object)procName);
                sch.set("ysq_sch_param_tag", (Object)paramBase64);
            }
            SaveServiceHelper.update((DynamicObject[])schedules);
        }
    }

    private void saveProcess(DynamicObject dynamicObject, String appSn) {
        String billNo;
        DynamicObject procDO;
        block1: {
            procDO = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process");
            billNo = "";
            int i = 0;
            do {
                billNo = this.getBillNo();
                QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
                QFilter[] qFilters = new QFilter[]{qFilter};
                boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_process", (QFilter[])qFilters);
                if (!exists) break block1;
            } while (++i <= 100000);
            throw new KDException("\u6d41\u7a0b\u7f16\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
        }
        procDO.set("billno", (Object)billNo);
        procDO.set("billstatus", (Object)"A");
        procDO.set("creator", (Object)RequestContext.get().getCurrUserId());
        procDO.set("org", (Object)RequestContext.get().getOrgId());
        procDO.set("ysq_proc_code", (Object)appSn);
        procDO.set("ysq_is_assistant", (Object)1);
        procDO.set("ysq_is_start_up", (Object)0);
        procDO.set("ysq_proc_file", dynamicObject.get("ysq_proc_file"));
        procDO.set("ysq_proc_ver", dynamicObject.get("ysq_last_version"));
        procDO.set("ysq_studio_ver", dynamicObject.get("ysq_studio_ver"));
        procDO.set("ysq_proc_name", dynamicObject.get("ysq_app_name"));
        procDO.set("ysq_proc_desc", dynamicObject.get("ysq_app_explain"));
        procDO.set("ysq_pro_change", dynamicObject.get("ysq_pro_change"));
        procDO.set("ysq_param_tag", dynamicObject.get("ysq_param_tag"));
        procDO.set("ysq_proc_type", (Object)"standard");
        procDO.set("ysq_status_ctime", (Object)new Date());
        procDO.set("ysq_publish_time", (Object)new Date());
        procDO.set("ysq_work_status", (Object)"release");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{procDO});
    }

    private void saveProcessVer(DynamicObject dynamicObject, String appSn) {
        String procCode = dynamicObject.get("ysq_proc_code").toString();
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)appSn);
        String appVer = dynamicObject.get("ysq_last_version").toString();
        QFilter verFilter = new QFilter("ysq_app_ver_code", "=", (Object)appVer);
        DynamicObject proDO = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"id", (QFilter[])new QFilter[]{procCodeFilter});
        long procId = proDO.getLong("id");
        QFilter qFilter = new QFilter("ysq_proc_fid", "=", (Object)procId);
        DynamicObject procVerObj = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)"id", (QFilter[])new QFilter[]{qFilter});
        DynamicObject procVerObject = BusinessDataServiceHelper.newDynamicObject((String)"ysq_rpa_process_ver");
        procVerObject.set("id", dynamicObject.get("ysq_fid"));
        procVerObject.set("ysq_proc_fid", (Object)procId);
        procVerObject.set("ysq_proc_name", dynamicObject.get("ysq_app_name"));
        procVerObject.set("ysq_proc_code", (Object)appSn);
        procVerObject.set("ysq_proc_file", dynamicObject.get("ysq_proc_file"));
        procVerObject.set("ysq_proc_ver", dynamicObject.get("ysq_last_version"));
        procVerObject.set("ysq_is_activity", (Object)"yes");
        procVerObject.set("ysq_proc_desc", dynamicObject.get("ysq_app_explain"));
        procVerObject.set("ysq_work_status", (Object)ProcessesStatusEnums.RELEASE.getCode());
        procVerObject.set("ysq_pro_change", dynamicObject.get("ysq_pro_change"));
        procVerObject.set("ysq_studio_ver", dynamicObject.get("ysq_studio_ver"));
        procVerObject.set("ysq_param_tag", dynamicObject.get("ysq_param_tag"));
        procVerObject.set("org", (Object)RequestContext.get().getOrgId());
        procVerObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        if (procVerObj != null) {
            procVerObject.set("id", procVerObj.get("id"));
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{procVerObject});
        } else {
            procVerObject.set("ysq_publish_time", (Object)new Date());
            procVerObject.set("ysq_status_ctime", (Object)new Date());
            SaveServiceHelper.save((IDataEntityType)procVerObject.getDataEntityType(), (Object[])new DynamicObject[]{procVerObject});
        }
        ProcessServiceHelper.checkProcExistAndStartSchedule((String)"start");
    }

    private String getBillNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String format = sdf.format(new Date());
        int i = (int)(Math.random() * 90000.0 + 10000.0);
        String billNo = "RPAprocess_" + format + "_" + i;
        return billNo;
    }
}

