/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.app;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.model.RpaJobVO;
import ysq.rpac.rpamc.common.utils.IsearchFileUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class AppSchOneOpPlugin
extends AbstractOperationServicePlugIn {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String YSQ_SCH_PARAM = "ysq_sch_param";
    private static final String YSQ_APP_NAME = "ysq_app_name";
    private JobQueueProducer jobQueueProducer = JobQueueProducer.getInstance();

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
                    String procCode = (String)data.getValue("ysq_proc_code");
                    String procName = (String)data.getValue(AppSchOneOpPlugin.YSQ_APP_NAME);
                    QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
                    DynamicObject object = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)"ysq_proc_ver", (QFilter[])new QFilter[]{procCodeFilter});
                    if (object == null) {
                        this.addErrorMessage(data, String.format("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u8c03\u5ea6\u4e00\u6b21\u3002", new Object[0]));
                        continue;
                    }
                    String procVer = object.getString("ysq_proc_ver");
                    QFilter procVerFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
                    if (QueryServiceHelper.exists((String)"ysq_rpa_process_ver", (QFilter[])new QFilter[]{procCodeFilter, procVerFilter})) continue;
                    this.addErrorMessage(data, String.format("\u6d41\u7a0b\uff1a%s\uff0c\u7248\u672c\uff1a%s\uff0c\u4e0d\u5b58\u5728\uff0c\u4e0d\u80fd\u7acb\u5373\u8fd0\u884c\u3002", procName, procVer));
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = args.getDataEntities()) {
            this.scheduleOne(data);
        }
    }

    private void scheduleOne(DynamicObject data) {
        Long fid = data.getLong("ysq_fid");
        String procParam = data.getString("ysq_sch_param_tag");
        String procCode = data.getString("ysq_proc_code");
        String robotSel = data.getString("ysq_robots_sel");
        String robotsNoSel = data.getString("ysq_exec_robots_no_sel");
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject procDB = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter});
        if (null == procDB) {
            return;
        }
        String procVer = procDB.getString("ysq_proc_ver");
        QFilter procVerFilter = new QFilter("ysq_proc_ver", "=", (Object)procVer);
        DynamicObject procVerDB = QueryServiceHelper.queryOne((String)"ysq_rpa_process_ver", (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{procCodeFilter, procVerFilter});
        if (null == procVerDB) {
            return;
        }
        Date now = new Date();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(RequestContext.get().getCurrUserId());
        RpaJobVO job = new RpaJobVO();
        job = this.buildOneJob(job, procDB, procVerDB, now, "manager", "manual_run", ((Map)UserServiceHelper.get(ids).get(0)).get("id").toString());
        job.setPriority("higher");
        job.setScheduleTime(now);
        job.setParameter(procParam);
        if (RobotRangeEnums.DEFAULT.getCode().equals(robotsNoSel)) {
            job.setExecRobotsNo(robotsNoSel);
        } else {
            String[] split;
            StringBuilder robots = new StringBuilder();
            for (String robotNo : split = robotSel.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)robotNo)) continue;
                robots.append("-");
                robots.append(robotNo);
                robots.append("-");
                robots.append(",");
            }
            robots.deleteCharAt(robots.length() - 1);
            job.setExecRobotsNo(robots.toString());
        }
        String proChange = procVerDB.getString("ysq_pro_change");
        DynamicObject object = job.buildDynamicObject();
        object.set("id", (Object)fid);
        Object[] jobs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        job.setFid(fid);
        this.jobQueueProducer.addJob(job, proChange);
    }

    private RpaJobVO buildOneJob(RpaJobVO job, DynamicObject processDb, DynamicObject processVerDb, Date now, String schType, String produceType, String jobType) {
        job.setWorkStatus(processDb.getString("ysq_work_status"));
        job.setJobNo(UUID.randomUUID().toString());
        job.setJobOrder(Long.valueOf(now.getTime()));
        job.setProduceType(produceType);
        job.setProcFid(Long.valueOf(processVerDb.getLong("id")));
        job.setProcCode(processDb.getString("ysq_proc_code"));
        job.setProcName(processDb.getString("ysq_proc_name"));
        job.setProcFile(processVerDb.getString("ysq_proc_file"));
        job.setProcVer(processVerDb.getString("ysq_proc_ver"));
        job.setPublishTime(processVerDb.getDate("ysq_publish_time"));
        job.setOrgId(UserUtils.getDptId());
        job.setDeveloperUserFid(Long.valueOf(processDb.getLong("ysq_dev_user_fid")));
        job.setDeveloperUserAlias(processDb.getString("ysq_dev_user_alias"));
        job.setJobTime(now);
        job.setStatus(RpaJobStatusEnums.PENDING.getCode());
        job.setPendingTimeout(Integer.valueOf(0));
        job.setRunningTimeout(Integer.valueOf(0));
        job.setProcHandDoMin(null);
        job.setAutoStopTime(Integer.valueOf(0));
        job.setFailTryTimes(Integer.valueOf(0));
        job.setRunTimes(Integer.valueOf(1));
        job.setJobType(jobType);
        job.setSchType(schType);
        job.setProcVerDesc(processDb.getString("ysq_proc_desc"));
        job.setStudioVer(processDb.getString("ysq_studio_ver"));
        job.setComJobType(processDb.getString("ysq_proc_type"));
        return job;
    }

    private String disposeParam(String param) {
        if (StringUtils.isNotBlank((CharSequence)param)) {
            return IsearchFileUtils.paramsBase64((String)param);
        }
        return null;
    }
}

