/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.app.home;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class AppJobCountPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(AppJobCountPlugin.class);
    private static final String YSQ_LABEL_JOB_NUM = "ysq_label_job_num";
    private static final String YSQ_LABEL_JOB_TIME = "ysq_label_job_time";
    private static final String YSQ_REFRESH = "ysq_refresh";
    private static final String YSQ_DATETYPE = "ysq_datetype";
    private static final String YSQ_JOB_DATE = "ysq_job_date";
    private static final String YSQ_LABEL_TIME_UNIT = "ysq_label_time_unit";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.queryAppJobCount(AppJobCountPlugin.getTodayDate(), null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label appJobNumLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_NUM);
        Label appJobTimeLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_TIME);
        appJobNumLabel.addClickListener((ClickListener)this);
        appJobTimeLabel.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{YSQ_REFRESH});
        this.addClickListeners(new String[]{YSQ_DATETYPE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (YSQ_DATETYPE.equals(fieldKey)) {
            String dateType = this.getModel().getValue(YSQ_DATETYPE).toString();
            if (StringUtils.equals((CharSequence)"today", (CharSequence)dateType)) {
                this.queryAppJobCount(AppJobCountPlugin.getTodayDate(), null);
            } else if (StringUtils.equals((CharSequence)"week", (CharSequence)dateType)) {
                this.queryAppJobCount(AppJobCountPlugin.getWeekStartDate(), "week");
            } else if (StringUtils.equals((CharSequence)"month", (CharSequence)dateType)) {
                this.queryAppJobCount(AppJobCountPlugin.getMonthDate(), "month");
            }
        }
        if (YSQ_JOB_DATE.equals(fieldKey)) {
            Date value = (Date)this.getModel().getValue(YSQ_JOB_DATE);
            if (value == null) {
                this.queryAppJobCount(AppJobCountPlugin.getTodayDate(), null);
                this.getModel().setValue(YSQ_DATETYPE, (Object)"today");
                return;
            }
            this.queryAppJobCount(value, "month");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_REFRESH.equals(control.getKey())) {
            this.getModel().setValue(YSQ_DATETYPE, (Object)"today");
            this.queryAppJobCount(AppJobCountPlugin.getTodayDate(), null);
        } else if (YSQ_LABEL_JOB_NUM.equals(control.getKey())) {
            Object dateTypeObj = this.getModel().getValue(YSQ_DATETYPE);
            String dateType = dateTypeObj.toString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("isAppOpen", "true");
            map.put("dptIds", RequestContext.get().getOrgId());
            map.put("dateType", dateType);
            if ("custom".equals(dateType)) {
                Object value = this.getModel().getValue(YSQ_JOB_DATE);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = formatter.format(value);
                map.put("customDate", date);
            }
            ListShowParameter showParameter = KdPageUtils.toListPage((String)"ysq_rpa_job", (ShowType)ShowType.MainNewTabPage, map);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void queryAppJobCount(Date date, String dateType) {
        QFilter jobTimeFilter = new QFilter("ysq_job_time", ">=", (Object)date);
        QFilter dateEndFilter = null;
        QFilter typeFilter = new QFilter("ysq_com_job_type", "=", (Object)"standard");
        QFilter dptFilter = new QFilter("org", "=", (Object)UserUtils.getDptId());
        if (StringUtils.isNotEmpty((CharSequence)dateType)) {
            if ("week".equals(dateType)) {
                dateEndFilter = new QFilter("ysq_job_time", "<=", (Object)DateUtils.getWeekEnd());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String formatDate = sdf.format(date);
                int year = Integer.parseInt(formatDate.substring(0, 4));
                int month = Integer.parseInt(formatDate.substring(5, 7));
                dateEndFilter = new QFilter("ysq_job_time", "<=", (Object)AppJobCountPlugin.getLastDayOfMonth(year, month));
            }
        }
        QFilter[] filters = new QFilter[]{jobTimeFilter, typeFilter, dateEndFilter, dptFilter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_job", (String)"ysq_run_time_sec", (QFilter[])filters);
        int size = query.size();
        Label numLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_NUM);
        numLabel.setText(size + "");
        Label jobTimeLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_TIME);
        int time = 0;
        for (DynamicObject job : query) {
            time += job.getInt("ysq_run_time_sec");
        }
        Label timeUnitLabel = (Label)this.getView().getControl(YSQ_LABEL_TIME_UNIT);
        String timeUnit = "\u79d2";
        if (time > 3600) {
            time /= 3600;
            timeUnit = "\u5c0f\u65f6";
        } else if (time > 60) {
            time /= 60;
            timeUnit = "\u5206\u949f";
        }
        jobTimeLabel.setText(time + "");
        timeUnitLabel.setText(timeUnit + "");
    }

    private static Date getTodayDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static Date getWeekStartDate() {
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7) - 1;
        int num = dayOfWeek == 1 ? 0 : (dayOfWeek == 0 ? -6 : 1 - dayOfWeek);
        calendar.add(5, num);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private static Date getMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    private boolean compareDate(Date selDate) {
        Date monthDate = AppJobCountPlugin.getMonthDate();
        return monthDate.after(selDate);
    }
}

