/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.app.home;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import ysq.rpac.rpamc.common.constant.YsqAgentConstant;
import ysq.rpac.rpamc.common.enums.RoborDataStatusEnums;
import ysq.rpac.rpamc.common.enums.RobotTypeEnums;
import ysq.rpac.rpamc.common.model.LicenseVO;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class AppMineRobotCountPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(AppMineRobotCountPlugin.class);
    private static final String YSQ_ROBOT_RUN = "ysq_robot_run";
    private static final String YSQ_ROBOT_FREE = "ysq_robot_free";
    private static final String YSQ_ROBOT_OFFLINE = "ysq_robot_offline";
    private static final String YSQ_PIE_ROBOT = "ysq_pie_robot";
    private static final String YSQ_REFRESH = "ysq_refresh";
    private static final String PIT_TITLE = "\u8bb8\u53ef\u4f7f\u7528\u60c5\u51b5";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.queryAppMineRobotCount();
        this.drawChart(YSQ_PIE_ROBOT);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label robotRunLabel = (Label)this.getView().getControl(YSQ_ROBOT_RUN);
        Label robotFreeLabel = (Label)this.getView().getControl(YSQ_ROBOT_FREE);
        Label robotOfflineLabel = (Label)this.getView().getControl(YSQ_ROBOT_OFFLINE);
        robotRunLabel.addClickListener((ClickListener)this);
        robotFreeLabel.addClickListener((ClickListener)this);
        robotOfflineLabel.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{YSQ_REFRESH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_REFRESH.equals(control.getKey())) {
            this.queryAppMineRobotCount();
            this.drawChart(YSQ_PIE_ROBOT);
            return;
        }
        if (YSQ_ROBOT_RUN.equals(control.getKey())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("isAppOpen", "true");
            map.put("dataStatus", RoborDataStatusEnums.RUNNING.getCode());
            ListShowParameter showParameter = KdPageUtils.toListPage((String)"ysq_rpa_agent", (ShowType)ShowType.MainNewTabPage, map);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (YSQ_ROBOT_FREE.equals(control.getKey())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("isAppOpen", "true");
            map.put("dataStatus", RoborDataStatusEnums.FREE.getCode());
            ListShowParameter showParameter = KdPageUtils.toListPage((String)"ysq_rpa_agent", (ShowType)ShowType.MainNewTabPage, map);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (YSQ_ROBOT_OFFLINE.equals(control.getKey())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("isAppOpen", "true");
            map.put("dataStatus", RoborDataStatusEnums.OFFLINE.getCode());
            ListShowParameter showParameter = KdPageUtils.toListPage((String)"ysq_rpa_agent", (ShowType)ShowType.MainNewTabPage, map);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void queryAppMineRobotCount() {
        Integer runCount = 0;
        Integer runFree = 0;
        Integer runOffline = 0;
        QFilter agentTypeFilter = new QFilter("ysq_agent_type", "=", (Object)"standardRobot");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)YsqAgentConstant.selAllFileds(), (QFilter[])new QFilter[]{agentTypeFilter});
        for (DynamicObject object : query) {
            Integer n;
            Integer n2;
            String agentStatus = object.getString("ysq_data_status");
            if (RoborDataStatusEnums.RUNNING.getCode().equals(agentStatus)) {
                n2 = runCount;
                n = runCount = Integer.valueOf(runCount + 1);
                continue;
            }
            if (RoborDataStatusEnums.FREE.getCode().equals(agentStatus)) {
                n2 = runFree;
                n = runFree = Integer.valueOf(runFree + 1);
                continue;
            }
            if (!RoborDataStatusEnums.OFFLINE.getCode().equals(agentStatus)) continue;
            n2 = runOffline;
            n = runOffline = Integer.valueOf(runOffline + 1);
        }
        Label robotRunLabel = (Label)this.getView().getControl(YSQ_ROBOT_RUN);
        Label robotFreeLabel = (Label)this.getView().getControl(YSQ_ROBOT_FREE);
        Label robotOfflineLabel = (Label)this.getView().getControl(YSQ_ROBOT_OFFLINE);
        robotRunLabel.setText(runCount + "");
        robotFreeLabel.setText(runFree + "");
        robotOfflineLabel.setText(runOffline + "");
    }

    private void drawChart(String ckey) {
        PieChart assistantPieChart = (PieChart)this.getControl(ckey);
        assistantPieChart.clearData();
        assistantPieChart.setShowTooltip(true);
        HashMap<String, String> color = new HashMap<String, String>();
        color.put("used", "#00CFFF");
        color.put("notUse", "#CCCCCC");
        Map<String, Integer> licenseUseMap = this.getLicenseUseStatus();
        Integer used = licenseUseMap.get("used");
        Integer total = licenseUseMap.get("total");
        if (used > total) {
            used = total;
        }
        int notUse = total - used;
        HashMap<String, ItemValue[]> resMap = new HashMap<String, ItemValue[]>();
        ItemValue[] itemValues = new ItemValue[]{new ItemValue("\u5df2\u7528\u8bb8\u53ef", (Number)used, (String)color.get("used")), new ItemValue("\u672a\u4f7f\u7528\u8bb8\u53ef", (Number)notUse, (String)color.get("notUse"))};
        resMap.put(PIT_TITLE, itemValues);
        PieSeries series = assistantPieChart.createPieSeries(PIT_TITLE);
        series.setRadius("40%", "60%");
        this.setSeriesData(series, (ItemValue[])resMap.get(PIT_TITLE));
        assistantPieChart.setShowTitle(true);
        assistantPieChart.setTitlePropValue("text", (Object)(used + "/" + total));
        assistantPieChart.setTitlePropValue("top", (Object)"center");
        assistantPieChart.setTitlePropValue("left", (Object)"center");
        this.getView().updateView(ckey);
    }

    private PieSeries setSeriesData(PieSeries series, ItemValue[] items) {
        series.setData(items);
        HashMap map02 = new HashMap();
        HashMap<String, Boolean> normalMap02 = new HashMap<String, Boolean>();
        map02.put("normal", normalMap02);
        normalMap02.put("show", Boolean.FALSE);
        series.setPropValue("labelLine", map02);
        return series;
    }

    private Map<String, Integer> getLicenseUseStatus() {
        LicenseVO licenseVO = LicenseUtils.licenseNums();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer robotsTotal = licenseVO.getCsRobot();
        if (robotsTotal == null || robotsTotal == 0) {
            map.put("used", 0);
            map.put("total", 0);
        } else {
            DynamicObjectCollection robots = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{new QFilter("ysq_agent_type", "=", (Object)RobotTypeEnums.STANDARD_ROBOT.getCode())});
            map.put("used", robots.size());
            map.put("total", robotsTotal);
        }
        return map;
    }
}

