/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.asset;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAssetConstant;
import ysq.rpac.rpamc.common.enums.AssetType;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.utils.SecretUtil;

public class AssetFormPlugin
extends AbstractFormPlugin {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String YSQ_ASSET_VALUE_EDIT = "ysq_asset_value";
    public static final String YSQ_ORG_SEL = "ysq_org_sel";
    public static final String YSQ_BTOK = "ysq_btok";

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button button = (Button)this.getView().getControl(YSQ_BTOK);
        button.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.click((EventObject)evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)YSQ_BTOK)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long assetId = dataEntity.getLong("id");
            String assetName = dataEntity.getString("ysq_asset_name");
            QFilter qFilter = new QFilter("ysq_asset_name", "=", (Object)assetName);
            QFilter idFilter = new QFilter("id", "!=", (Object)assetId);
            boolean exists = QueryServiceHelper.exists((String)"ysq_rpa_asset", (QFilter[])new QFilter[]{qFilter, idFilter});
            if (exists) {
                this.getView().showTipNotification("\u53d8\u91cf\u540d\u5df2\u5b58\u5728");
                evt.setCancel(true);
            }
            String type = dataEntity.getString("ysq_asset_type");
            if (AssetType.TEXT.getCode().equals(type)) {
                dataEntity.set("ysq_asset_value_pass", null);
                String value = dataEntity.getString("ysq_asset_value_tag");
                if ((long)value.length() > YsqAssetConstant.LIMIT_TEXT_SIZE) {
                    this.getView().showTipNotification("\u53d8\u91cf\u503c\u6700\u5927\u4e3a4096\u5b57\u7b26");
                    evt.setCancel(true);
                }
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
        this.initEdit();
    }

    public void propertyChanged(PropertyChangedArgs changeArgs) {
        Object newValue;
        ChangeData[] changeSet;
        super.propertyChanged(changeArgs);
        String fieldKey = changeArgs.getProperty().getName();
        if ("ysq_asset_type".equals(fieldKey)) {
            IDataModel model = this.getModel();
            ChangeData[] changeSet2 = changeArgs.getChangeSet();
            if (changeSet2 != null && changeSet2.length > 0) {
                Object newValue2 = changeSet2[0].getNewValue();
                if (newValue2 != null) {
                    String type = newValue2.toString();
                    if (AssetType.TEXT.getCode().equals(type)) {
                        this.setMustInput(YSQ_ASSET_VALUE_EDIT, true);
                        this.setMustInput("ysq_asset_value_pass", false);
                        LargeTextOtherEdit largeTextEdit = (LargeTextOtherEdit)this.getView().getControl(YSQ_ASSET_VALUE_EDIT);
                        String tagPropName = largeTextEdit.getTagFieldKey();
                        model.setValue(YSQ_ASSET_VALUE_EDIT, null);
                        model.setValue(tagPropName, null);
                        this.getView().updateView(YSQ_ASSET_VALUE_EDIT);
                    } else {
                        this.setMustInput(YSQ_ASSET_VALUE_EDIT, false);
                        this.setMustInput("ysq_asset_value_pass", true);
                        model.setValue("ysq_asset_value_pass", null);
                    }
                }
            } else {
                this.log.info("\u53d8\u91cf\u7c7b\u578b\u4e0b\u62c9\u5217\u8868\u9009\u62e9\u4e3a\u7a7a");
            }
        } else if ("ysq_robots_no_sel".equals(fieldKey) && (changeSet = changeArgs.getChangeSet()) != null && changeSet.length > 0 && (newValue = changeSet[0].getNewValue()) != null) {
            String value = newValue.toString();
            String[] split = value.split(",");
            if (RobotRangeEnums.DEPTALL.getCode().equals(split[split.length - 1])) {
                this.getModel().setValue("ysq_robots_no_sel", (Object)("," + RobotRangeEnums.DEPTALL.getCode() + ","));
            } else {
                String replace = value.replace(",-deptall-,", ",");
                this.getModel().setValue("ysq_robots_no_sel", (Object)replace);
            }
        }
    }

    private void initData() {
        long orgId = RequestContext.get().getOrgId();
        ArrayList<Long> childIds = new ArrayList();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        childIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIds, (boolean)true);
        this.bindAgent(childIds);
        this.pwdEcho();
    }

    private void pwdEcho() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String type = dataEntity.getString("ysq_asset_type");
        String pass = dataEntity.getString("ysq_asset_value_tag");
        if (StringUtils.isNotBlank((CharSequence)pass) && AssetType.PASSWORD.getCode().equals(type)) {
            pass = SecretUtil.desDecrypt((String)pass);
        }
        model.setValue("ysq_asset_value_pass", (Object)pass);
    }

    private void bindOrg() {
        long orgId = RequestContext.get().getOrgId();
        this.getOrgList(orgId);
    }

    private void initEdit() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity != null) {
            String assetType = dataEntity.getString("ysq_asset_type");
            if (AssetType.TEXT.getCode().equals(assetType)) {
                this.setMustInput(YSQ_ASSET_VALUE_EDIT, true);
                this.setMustInput("ysq_asset_value_pass", false);
            } else {
                this.setMustInput(YSQ_ASSET_VALUE_EDIT, false);
                this.setMustInput("ysq_asset_value_pass", true);
            }
        }
    }

    private void bindAgent(List<Long> childIds) {
        ComboEdit agentCom = (ComboEdit)this.getControl("ysq_robots_no_sel");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        QFilter filter = new QFilter("org", "in", childIds);
        ArrayList<String> agentType = new ArrayList<String>();
        agentType.add("robot");
        agentType.add("assistant");
        filter.and(new QFilter("ysq_agent_type", "in", agentType));
        filter.or(new QFilter("ysq_agent_type", "=", (Object)"standardRobot"));
        String field = "ysq_agent_alias,ysq_agent_no";
        DynamicObject[] processList = BusinessDataServiceHelper.load((String)"ysq_rpa_agent", (String)field, (QFilter[])new QFilter[]{filter});
        data.add(new ComboItem(new LocaleString(RobotRangeEnums.DEPTALL.getName()), RobotRangeEnums.DEPTALL.getCode()));
        for (DynamicObject dynamicObject : processList) {
            Object code = dynamicObject.get("ysq_agent_no");
            Object name = dynamicObject.get("ysq_agent_alias");
            data.add(new ComboItem(new LocaleString(name.toString()), code.toString()));
        }
        agentCom.setComboItems(data);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String robots = dataEntity.getString("ysq_robots_no_sel");
        if (StringUtils.isBlank((CharSequence)robots) || ",,".equals(robots)) {
            this.getModel().setValue("ysq_robots_no_sel", (Object)("," + RobotRangeEnums.DEPTALL.getCode() + ","));
        }
    }

    private void setMustInput(String key, boolean bl) {
        TextEdit asserValueEdit = (TextEdit)this.getControl(key);
        TextProp asserValueProperty = (TextProp)asserValueEdit.getProperty();
        asserValueProperty.setMustInput(bl);
        asserValueEdit.setMustInput(bl);
    }

    private List<Map<String, Object>> getOrgList(Long parentId) {
        OrgTreeParam param = new OrgTreeParam();
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        param.setId(parentId.longValue());
        param.setOrgViewNumber("01");
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        List rootInfoMap = orgService.getTreeChildrenMap(param);
        ComboEdit agentCom = (ComboEdit)this.getControl(YSQ_ORG_SEL);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        for (Map map : rootInfoMap) {
            Object code = map.get("id");
            Object name = map.get("name");
            data.add(new ComboItem(new LocaleString(name.toString()), code.toString()));
        }
        agentCom.setComboItems(data);
        return rootInfoMap;
    }
}

