/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.asset;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.AssetType;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;

public class AssetListPlugin
extends AbstractListPlugin {
    public static final String YSQ_ASSET_VALUE = "ysq_asset_value";
    public static final String KEY_MAINBAR = "toolbarap";
    private static final String BILLLISTAP = "billlistap";
    private static final String YSQ_BTN_DEL = "tbldel";
    public static final String YSQ_NEW_ASSET = "ysq_new_asset";
    public static final String YSQ_ASSET_ADD = "ysq_asset_add";
    public static final String YSQ_DEL_LOG = "ysq_del_log";
    public static final String YSQ_ASSET_DEL_CALL_BACK = "ysq_asset_del_call_back";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        this.dataPass(e, rowData);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        int size = selectedRows.size();
        if (StringUtils.equals((CharSequence)YSQ_BTN_DEL, (CharSequence)evt.getItemKey())) {
            if (size == 0) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
                evt.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)YSQ_DEL_LOG, (CharSequence)evt.getItemKey()) && this.checkRows(evt)) {
            this.delAssetLog(evt);
        }
        if (evt.getItemKey().equals("ysq_btn_log") && size != 1) {
            this.getView().showTipNotification("\u4ec5\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e");
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("ysq_btn_log")) {
            super.itemClick(evt);
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRow row = list.getSelectedRows().get(0);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.toString(), (String)"ysq_rpa_asset");
            Long value = dynamicObject.getLong("id");
            this.logRouter(value);
        }
    }

    private void logRouter(Long assetId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("ysq_asset_log");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("assetId", (Object)assetId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void dataPass(PackageDataEvent e, DynamicObject rowData) {
        if (e.getSource() instanceof ColumnDesc) {
            String alias;
            long fid;
            DynamicObject dynamicObject;
            ColumnDesc columnDesc = (ColumnDesc)e.getSource();
            if (YSQ_ASSET_VALUE.equals(columnDesc.getKey())) {
                String type;
                if (rowData != null && StringUtils.isNotBlank((CharSequence)(type = rowData.getString("ysq_asset_type"))) && AssetType.PASSWORD.getCode().equals(type)) {
                    e.setFormatValue((Object)"******");
                }
            } else if ("ysq_agent_alias".equals(columnDesc.getKey()) && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)(fid = rowData.getLong("id")), (String)"ysq_rpa_asset")) != null && StringUtils.isNotBlank((CharSequence)(alias = dynamicObject.get("ysq_agent_alias_tag").toString()))) {
                String code = RobotRangeEnums.DEPTALL.getCode();
                if (code.equals(alias)) {
                    e.setFormatValue((Object)RobotRangeEnums.DEPTALL.getName());
                } else {
                    String[] split = alias.split(",");
                    StringBuilder sb = new StringBuilder();
                    for (String alia : split) {
                        if (!StringUtils.isNotBlank((CharSequence)alia)) continue;
                        String sp = alia.substring(1, alia.length() - 1);
                        sb.append(sp);
                        sb.append(",");
                    }
                    String rtAlias = sb.substring(0, sb.length() - 1);
                    e.setFormatValue((Object)rtAlias);
                }
            }
        }
    }

    private void delAssetLog(BeforeItemClickEvent evt) {
        String msg = "\u6e05\u7a7a\u8be5\u53d8\u91cf\u7684\u8bbf\u95ee\u65e5\u5fd7\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\n\n\u786e\u5b9a\u8981\u6e05\u7a7a\u65e5\u5fd7\u5417\uff1f";
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    private boolean checkRows(BeforeItemClickEvent evt) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        int size = selectedRows.size();
        if (size > 1) {
            this.getView().showTipNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        if (size == 0) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        return true;
    }
}

