/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.asset;

import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqAssetConstant;
import ysq.rpac.rpamc.common.enums.AssetType;
import ysq.rpac.rpamc.common.enums.RobotRangeEnums;
import ysq.rpac.rpamc.common.utils.EsUtils;
import ysq.rpac.rpamc.common.utils.SecretUtil;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class AssetNewOpPlugin
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            String robotNo;
            String type = data.getString("ysq_asset_type");
            if (AssetType.PASSWORD.getCode().equals(type)) {
                String pass = data.getString("ysq_asset_value_pass");
                if (StringUtils.isNotBlank((CharSequence)pass)) {
                    pass = SecretUtil.desEncrypt((String)pass);
                }
                data.set("ysq_asset_value_tag", (Object)pass);
            }
            if (StringUtils.isNotBlank((CharSequence)(robotNo = data.getString("ysq_robots_no_sel")))) {
                String dep = "," + RobotRangeEnums.DEPTALL.getCode() + ",";
                if (dep.equals(robotNo)) {
                    String sub = robotNo.substring(1, robotNo.length() - 1);
                    data.set("ysq_robots_no_tag", (Object)sub);
                    data.set("ysq_agent_alias_tag", (Object)sub);
                } else {
                    String[] split = robotNo.split(",");
                    StringBuilder sbRobotNo = new StringBuilder();
                    StringBuilder sbAlias = new StringBuilder();
                    for (String s : split) {
                        if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                        sbRobotNo.append("-");
                        sbRobotNo.append(s);
                        sbRobotNo.append("-");
                        sbRobotNo.append(",");
                        QFilter qFilter = new QFilter("ysq_agent_no", "=", (Object)s);
                        DynamicObjectCollection robots = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"ysq_agent_alias", (QFilter[])new QFilter[]{qFilter});
                        if (!CollectionUtils.isNotEmpty((Collection)robots)) continue;
                        String alias = ((DynamicObject)robots.get(0)).getString("ysq_agent_alias");
                        if (StringUtils.isBlank((CharSequence)alias)) {
                            alias = s;
                        }
                        sbAlias.append("-");
                        sbAlias.append(alias);
                        sbAlias.append("-");
                        sbAlias.append(",");
                    }
                    String robotNos = sbRobotNo.substring(0, sbRobotNo.length() - 1);
                    String robotAlias = sbAlias.substring(0, sbAlias.length() - 1);
                    data.set("ysq_robots_no_tag", (Object)robotNos);
                    data.set("ysq_agent_alias_tag", (Object)robotAlias);
                }
            } else {
                data.set("ysq_robots_no_tag", (Object)" ");
            }
            long assetId = data.getLong("id");
            Long userId = RequestContext.get().getCurrUserId();
            QFilter qFilter = new QFilter("id", "=", (Object)assetId);
            DynamicObject dbData = QueryServiceHelper.queryOne((String)"ysq_rpa_asset", (String)YsqAssetConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
            StringBuilder info = new StringBuilder();
            String action = "";
            if (dbData == null) {
                action = "create";
            } else {
                String replace;
                String newValue;
                String replace2;
                String dataType;
                String daType;
                action = "edit";
                long currUserId = RequestContext.get().getCurrUserId();
                String userName = "";
                if (currUserId != 0L) {
                    userName = UserUtils.getUserName((Long)currUserId);
                    info.append("\u7528\u6237");
                    info.append(userName);
                }
                if (!dbData.getString("ysq_asset_name").equals(data.getString("ysq_asset_name"))) {
                    String nameDesc = "\u4fee\u6539\u201c\u53d8\u91cf\u540d\u201d\u3002\u4fee\u6539\u524d\uff1a${A}\uff0c\u4fee\u6539\u540e\uff1a${B}\u3002";
                    String replace3 = nameDesc.replace("${A}", dbData.getString("ysq_asset_name"));
                    String newName = replace3.replace("${B}", data.getString("ysq_asset_name"));
                    info.append(newName);
                }
                if ((daType = dbData.getString("ysq_asset_type")).equals(dataType = data.getString("ysq_asset_type")) && !dbData.getString("ysq_asset_value_tag").equals(data.getString("ysq_asset_value_tag"))) {
                    String valueDesc = "\u4fee\u6539\u201c\u53d8\u91cf\u503c\u201d\u3002\u4fee\u6539\u524d\uff1a${A}\uff0c\u4fee\u6539\u540e\uff1a${B}\u3002";
                    replace2 = valueDesc.replace("${A}", dbData.getString("ysq_asset_value_tag"));
                    newValue = replace2.replace("${B}", data.getString("ysq_asset_value_tag"));
                    info.append(newValue);
                }
                if (!dbData.getString("ysq_asset_type").equals(data.getString("ysq_asset_type"))) {
                    String typeDesc = "\u4fee\u6539\u201c\u53d8\u91cf\u7c7b\u578b\u201d\u3002\u4fee\u6539\u524d\uff1a${A}\uff0c\u4fee\u6539\u540e\uff1a${B}\u3002";
                    String oldType = dbData.getString("ysq_asset_type");
                    oldType = AssetType.TEXT.getCode().equals(oldType) ? AssetType.TEXT.getName() : AssetType.PASSWORD.getName();
                    String newType = data.getString("ysq_asset_type");
                    newType = AssetType.TEXT.getCode().equals(newType) ? AssetType.TEXT.getName() : AssetType.PASSWORD.getName();
                    replace = typeDesc.replace("${A}", oldType);
                    String newdata = replace.replace("${B}", newType);
                    info.append(newdata);
                }
                if (!dbData.getString("ysq_agent_alias_tag").equals(data.getString("ysq_agent_alias_tag"))) {
                    String robotSel = "\u4fee\u6539\u201c\u673a\u5668\u4eba\u6743\u9650\u201d\u3002\u4fee\u6539\u524d\uff1a${A}\uff0c\u4fee\u6539\u540e\uff1a${B}\u3002";
                    String oldAlias = dbData.getString("ysq_agent_alias_tag");
                    String newAlias = data.getString("ysq_agent_alias_tag");
                    if (StringUtils.isNotBlank((CharSequence)oldAlias)) {
                        oldAlias = this.getRobotAlias(oldAlias);
                    }
                    if (StringUtils.isNotBlank((CharSequence)newAlias)) {
                        newAlias = this.getRobotAlias(newAlias);
                    }
                    replace = robotSel.replace("${A}", oldAlias);
                    String newRobot = replace.replace("${B}", newAlias);
                    info.append(newRobot);
                }
                if (!dbData.getString("ysq_is_client_edit").equals(data.getString("ysq_is_client_edit"))) {
                    String client = "\u4fee\u6539\u201c\u5ba2\u6237\u7aef\u53ef\u4fee\u6539\u201d\u3002\u4fee\u6539\u524d\uff1a${A}\uff0c\u4fee\u6539\u540e\uff1a${B}\u3002";
                    replace2 = client.replace("${A}", String.valueOf(dbData.getBoolean("ysq_is_client_edit")));
                    newValue = replace2.replace("${B}", String.valueOf(data.getBoolean("ysq_is_client_edit")));
                    info.append(newValue);
                }
                if (!dbData.getString("ysq_is_python_expr").equals(data.getString("ysq_is_python_expr"))) {
                    String exprDesc = "\u4fee\u6539\u201c\u4fdd\u5b58\u683c\u5f0f\u201d\u3002\u4fee\u6539\u524d\uff1a${A}\uff0c\u4fee\u6539\u540e\uff1a${B}\u3002";
                    replace2 = exprDesc.replace("${A}", String.valueOf(dbData.getBoolean("ysq_is_python_expr")));
                    String newExpr = replace2.replace("${B}", String.valueOf(data.getBoolean("ysq_is_python_expr")));
                    info.append(newExpr);
                }
            }
            EsUtils.addAssetEsIndex((DynamicObject)data, (String)action, (String)"", (String)"", (String)"", (Long)userId, (String)"", (String)info.toString());
        }
    }

    private String getRobotAlias(String alias) {
        if (RobotRangeEnums.DEPTALL.getCode().equals(alias)) {
            return RobotRangeEnums.DEPTALL.getName();
        }
        String[] split = alias.split(",");
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            sb.append(s.substring(1, s.length() - 1));
            sb.append(",");
        }
        String substring = "";
        if (sb.length() > 0) {
            substring = sb.substring(0, sb.length() - 1);
        }
        return substring;
    }
}

