/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.annotation.OperateFileLog;
import ysq.rpac.rpamc.common.constant.YsqShareFileConstant;
import ysq.rpac.rpamc.common.enums.FileTypeFilterEnums;
import ysq.rpac.rpamc.common.utils.DateUtils;
import ysq.rpac.rpamc.common.utils.EsUtils;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class ShareFileCleanListPlugin
extends AbstractListPlugin {
    private static final String TBLDEL = "tbldel";
    private static final String BILLLISTAP = "billlistap";
    private static final String YSQ_CLOSEBACK_EXIT = "YSQ_CLOSEBACK_EXIT";
    private static String YSQ_RPA_SFILE_BACK = "ysq_rpa_sfile_back";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (TBLDEL.equals(evt.getItemKey())) {
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            if (selectedRows.size() <= 0) {
                this.getView().showTipNotification("\u672a\u9009\u62e9\u76f8\u5e94\u6570\u636e\u3002");
                evt.setCancel(true);
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(YSQ_CLOSEBACK_EXIT, (IFormPlugin)this);
            this.getView().showConfirm("\u6e05\u7406\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u6587\u4ef6\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u6e05\u7406\u8be5\u8bb0\u5f55\u5417\uff1f", MessageBoxOptions.OKCancel, confirmCallBackListener);
            evt.setCancel(true);
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject data : pageData) {
            if (StringUtils.isEmpty((CharSequence)data.getString("ysq_user_name"))) {
                data.set("ysq_user_name", (Object)"-");
            }
            if (StringUtils.isEmpty((CharSequence)data.getString("ysq_proc_name"))) {
                data.set("ysq_proc_name", (Object)"-");
            }
            if (!StringUtils.isEmpty((CharSequence)data.getString("ysq_proc_code"))) continue;
            data.set("ysq_proc_code", (Object)"-");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)YSQ_CLOSEBACK_EXIT, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            Iterator rows = selectedRows.iterator();
            int rowIndex = 0;
            while (rows.hasNext()) {
                ListSelectedRow row = (ListSelectedRow)rows.next();
                rowIndex = row.getRowKey();
            }
            FilterParameter clientQueryFilterParameter = list.getClientQueryFilterParameter();
            QFilter mainOrgQFilter = list.getMainOrgQFilter();
            FilterParameter queryFilterParameter = list.getQueryFilterParameter();
            ArrayList<QFilter> allfilters = new ArrayList<QFilter>();
            allfilters.addAll(clientQueryFilterParameter.getQFilters());
            allfilters.add(mainOrgQFilter);
            allfilters.addAll(queryFilterParameter.getQFilters());
            DynamicObjectCollection startToEnd = this.getStartToEnd(rowIndex, 1, allfilters);
            if (startToEnd != null && startToEnd.size() > 0) {
                DynamicObject clean = (DynamicObject)startToEnd.get(0);
                String[] ids = clean.getString("ysq_file_ids").split(",");
                List idList = Arrays.stream(ids).map(Long::valueOf).collect(Collectors.toList());
                QFilter idsFilter = new QFilter("id", "in", idList);
                DynamicObjectCollection files = QueryServiceHelper.query((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{idsFilter});
                for (DynamicObject file : files) {
                    EsUtils.addFileEsIndex((Long)file.getLong("id"), (String)file.getString("ysq_file_name"), (String)OperateFileLog.Type.CLEAN.getType(), null, (Long)UserUtils.getCurrUserId(), (Long)file.getLong("ysq_org_id"), null);
                }
                DeleteServiceHelper.delete((String)"ysq_rpa_sfile", (QFilter[])new QFilter[]{idsFilter});
            }
            this.getView().returnDataToParent((Object)true);
            this.getView().invokeOperation("refresh");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (TBLDEL.equals(itemKey)) {
            // empty if block
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            FileTypeFilterEnums[] values;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"ysq_file_type".equals(fieldName)) continue;
            CommonFilterColumn filter = (CommonFilterColumn)commonFilterColumn;
            List comboItems = filter.getComboItems();
            comboItems.clear();
            for (FileTypeFilterEnums value : values = FileTypeFilterEnums.values()) {
                ComboItem comboItem = new ComboItem(new LocaleString(value.getName()), value.getCode());
                comboItems.add(comboItem);
            }
            filter.setComboItems(comboItems);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection dataCollection = this.getCollection(this.getQFilters());
                DynamicObjectCollection dObjectCollection = ShareFileCleanListPlugin.this.getStartToEnd(arg0, arg1, this.getQFilters());
                int dataCount = dataCollection.size();
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                return dObjectCollection;
            }

            private DynamicObjectCollection getCollection(List<QFilter> qFilters) {
                String getfilter = ShareFileCleanListPlugin.this.getfilter(qFilters);
                String timeFilter = "1=1";
                for (QFilter qf : qFilters) {
                    if (!"createtime".equals(qf.getProperty())) continue;
                    String startTime = DateUtils.engDateToString((String)qf.getValue().toString(), (String)"yyyy-MM-dd HH:mm:ss");
                    List nests = qf.getNests(true);
                    String endTime = DateUtils.engDateToString((String)((QFilter.QFilterNest)nests.get(0)).getFilter().getValue().toString(), (String)"yyyy-MM-dd HH:mm:ss");
                    timeFilter = "createtime >= TO_DATE('" + startTime + "','yyyy-MM-dd HH:mm:ss') and createtime < TO_DATE('" + endTime + "','yyyy-MM-dd HH:mm:ss')";
                }
                String sSql = "SELECT " + ShareFileCleanListPlugin.this.getCleanListCol() + " FROM ysq_rpa_sfile " + " where " + getfilter;
                DataSet dsResult = ORM.create().queryDataSet(ShareFileCleanListPlugin.class.getName(), sSql, new Object[0]).filter(timeFilter).orderBy(new String[]{"ysq_file_create_type asc", "ysq_file_size desc"});
                DataSet agg = dsResult.groupBy(new String[]{"ysq_file_create_type", "ysq_user_name", "ysq_proc_code", "ysq_proc_name", "ysq_cur_org_name"}).sum("ysq_file_size", "ysq_file_size").count("ysq_file_count").max("createtime", "createtime").groupConcat("id", "ysq_file_ids").finish();
                DynamicObjectCollection dCollection = ORM.create().toPlainDynamicObjectCollection(agg);
                return dCollection;
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    private DynamicObjectCollection getStartToEnd(int start, int limit, List<QFilter> qFilters) {
        String getfilter = this.getfilter(qFilters);
        String timeFilter = "1=1";
        for (QFilter qf : qFilters) {
            if (qf == null || !"createtime".equals(qf.getProperty())) continue;
            String startTime = DateUtils.engDateToString((String)qf.getValue().toString(), (String)"yyyy-MM-dd HH:mm:ss");
            List nests = qf.getNests(true);
            String endTime = DateUtils.engDateToString((String)((QFilter.QFilterNest)nests.get(0)).getFilter().getValue().toString(), (String)"yyyy-MM-dd HH:mm:ss");
            timeFilter = "createtime >= TO_DATE('" + startTime + "','yyyy-MM-dd HH:mm:ss') and createtime < TO_DATE('" + endTime + "','yyyy-MM-dd HH:mm:ss')";
        }
        String sSql = "SELECT " + this.getCleanListCol() + " FROM ysq_rpa_sfile " + " where " + getfilter;
        DataSet dsResult = ORM.create().queryDataSet(ShareFileCleanListPlugin.class.getName(), sSql, new Object[0]).filter(timeFilter).orderBy(new String[]{"ysq_file_create_type asc", "ysq_file_size desc"});
        DataSet agg = dsResult.groupBy(new String[]{"ysq_file_create_type", "ysq_user_name", "ysq_proc_code", "ysq_proc_name", "ysq_cur_org_name"}).sum("ysq_file_size", "ysq_file_size").count("ysq_file_count").max("createtime", "createtime").groupConcat("id", "ysq_file_ids").finish();
        DataSet limitcoll = agg.limit(start, limit);
        DynamicObjectCollection dCollection = ORM.create().toPlainDynamicObjectCollection(limitcoll);
        return dCollection;
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        DynamicObject rowData = e.getRowData();
        long fileSize = rowData.getLong("ysq_file_size");
        String unit = "B";
        if (fileSize / 1024L > 0L) {
            unit = "KB";
            if ((fileSize /= 1024L) / 1024L > 0L) {
                unit = "MB";
                if ((fileSize /= 1024L) / 1024L > 0L) {
                    fileSize /= 1024L;
                    unit = "GB";
                }
            }
        }
        if (e.getSource() instanceof ColumnDesc && "ysq_file_size".equals((columnDesc = (ColumnDesc)e.getSource()).getKey())) {
            e.setFormatValue((Object)(fileSize + unit));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        int rowIndex = args.getRowIndex();
        BillList list = (BillList)this.getControl(BILLLISTAP);
        FilterParameter clientQueryFilterParameter = list.getClientQueryFilterParameter();
        QFilter mainOrgQFilter = list.getMainOrgQFilter();
        FilterParameter queryFilterParameter = list.getQueryFilterParameter();
        ArrayList<QFilter> allfilters = new ArrayList<QFilter>();
        allfilters.addAll(clientQueryFilterParameter.getQFilters());
        allfilters.add(mainOrgQFilter);
        allfilters.addAll(queryFilterParameter.getQFilters());
        DynamicObjectCollection startToEnd = this.getStartToEnd(rowIndex, 1, allfilters);
        if (startToEnd != null && startToEnd.size() > 0) {
            DynamicObject clean = (DynamicObject)startToEnd.get(0);
            String[] ids = clean.getString("ysq_file_ids").split(",");
            List idList = Arrays.stream(ids).map(Long::valueOf).collect(Collectors.toList());
            HashMap map = new HashMap();
            map.put("idList", idList);
            ListShowParameter formShowParameter = KdPageUtils.toListPage((String)"ysq_rpa_sfile", (ShowType)ShowType.MainNewTabPage, map);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_RPA_SFILE_BACK));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private String getCleanListCol() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",");
        sb.append("ysq_file_create_type");
        sb.append(",");
        sb.append("ysq_proc_code");
        sb.append(",");
        sb.append("ysq_proc_name");
        sb.append(",");
        sb.append("ysq_user_name");
        sb.append(",");
        sb.append("ysq_cur_org_name");
        sb.append(",");
        sb.append("ysq_file_size");
        sb.append(",");
        sb.append("createtime");
        return sb.toString();
    }

    private String getCleanListColAll() {
        StringBuilder sb = new StringBuilder();
        sb.append("ysq_file_create_type");
        sb.append(",");
        sb.append("ysq_proc_code");
        sb.append(",");
        sb.append("ysq_proc_name");
        sb.append(",");
        sb.append("ysq_user_name");
        sb.append(",");
        sb.append("count(1) as ");
        sb.append("ysq_file_count");
        sb.append(",");
        sb.append("sum(ysq_file_size) as ");
        sb.append("ysq_file_size");
        sb.append(",");
        sb.append("max(createtime) as ");
        sb.append("createtime");
        return sb.toString();
    }

    private String getfilter(List<QFilter> qFilters) {
        StringBuilder sb = new StringBuilder();
        sb.append(" 1=1 ");
        qFilters.stream().forEach(item -> {
            if (item != null) {
                if ("1".equals(item.getProperty())) {
                    String value = item.getValue().toString().toLowerCase();
                    String[] querys = value.split("#");
                    if (querys.length > 1) {
                        String queryValue = querys[1];
                        sb.append(" and (ysq_proc_name like '%" + queryValue + "%' or ysq_user_name like '%" + queryValue + "%')");
                    }
                } else if ("ysq_file_type".equals(item.getProperty())) {
                    Object value = item.getValue();
                    if (value instanceof List) {
                        ArrayList filterValue = (ArrayList)value;
                        item.__setCP("in");
                        ArrayList<String> realFilterValue = new ArrayList<String>();
                        for (String s : filterValue) {
                            ArrayList fileType = FileTypeFilterEnums.getFileType((String)s);
                            if (fileType != null) {
                                realFilterValue.addAll(fileType);
                                continue;
                            }
                            realFilterValue.add(s);
                        }
                        item.__setValue(realFilterValue);
                    } else {
                        item.__setCP("in");
                        ArrayList realFilterValue = new ArrayList();
                        ArrayList fileType = FileTypeFilterEnums.getFileType((String)value.toString());
                        if (fileType != null) {
                            realFilterValue.addAll(fileType);
                        }
                        item.__setValue(realFilterValue);
                    }
                    sb.append(" and " + item.toString());
                } else if ("org".equals(item.getProperty())) {
                    item.__setProperty("ysq_org_id");
                    sb.append(" and " + item.toString());
                } else if (!"createtime".equals(item.getProperty())) {
                    sb.append(" and " + item.toString());
                }
            }
        });
        return sb.toString();
    }
}

