/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.file;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import ysq.rpac.rpamc.common.annotation.OperateFileLog;
import ysq.rpac.rpamc.common.servicehelper.ShareFileServiceHelper;
import ysq.rpac.rpamc.common.utils.EsUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class ShareFileDelOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ShareFileDelOpPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Object billPkId = dataEntity.getBillPkId();
                    if (QueryServiceHelper.exists((String)"ysq_rpa_sfile", (Object)billPkId)) continue;
                    this.addErrorMessage(dataEntity, "\u6587\u4ef6\u540d\u4e3a\uff1a" + dataEntity.getValue("ysq_file_name") + "\u7684\u6587\u4ef6\u5df2\u4e0d\u5b58\u5728\u3002");
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
            long id = dynamicObject.getLong("id");
            DynamicObject shareFile = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_sfile");
            if (shareFile == null) continue;
            String jobNo = shareFile.getString("ysq_job_no");
            AttachmentServiceHelper.remove((String)"ysq_rpa_sfile", (Object)id);
            ShareFileServiceHelper.updateJobFileNum((String)jobNo, null);
            EsUtils.addFileEsIndex((Long)shareFile.getLong("id"), (String)shareFile.getString("ysq_file_name"), (String)OperateFileLog.Type.PAGE_DELETE.getType(), null, (Long)UserUtils.getCurrUserId(), (Long)shareFile.getLong("ysq_org_id"), null);
        }
    }
}

