/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.annotation.OperateFileLog;
import ysq.rpac.rpamc.common.constant.YsqShareFileConstant;
import ysq.rpac.rpamc.common.enums.FileTypeFilterEnums;
import ysq.rpac.rpamc.common.utils.EsUtils;
import ysq.rpac.rpamc.common.utils.KdPageUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class ShareFileListPlugin
extends AbstractListPlugin {
    public static final String KEY_MAINBAR = "toolbarap";
    public static final String CLOSE_CALL_BACK_PERSON_LIST = "close_call_back_person_list";
    public static final String CLOSE_CALL_BACK_FILE_TAG_LIST = "close_call_back_file_tag_list";
    private static final String YSQ_BTN_DOWNLOAD = "ysq_btn_download";
    private static final String YSQ_BTN_UPLOAD = "ysq_btn_upload";
    private static final String YSQ_OPE_HISTORY = "ysq_ope_history";
    private static final String YSQ_OPE_ALL_HISTORY = "ysq_ope_all_history";
    public static final String REFRESH = "refresh";
    private static final String YSQ_SET_TAGS = "ysq_set_tags";
    private static final String YSQ_RPA_FILE_LOG = "ysq_rpa_file_log";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            FileTypeFilterEnums[] values;
            String fieldName = commonFilterColumn.getFieldName();
            if (!"ysq_file_type".equals(fieldName)) continue;
            CommonFilterColumn filter = (CommonFilterColumn)commonFilterColumn;
            List comboItems = filter.getComboItems();
            comboItems.clear();
            for (FileTypeFilterEnums value : values = FileTypeFilterEnums.values()) {
                ComboItem comboItem = new ComboItem(new LocaleString(value.getName()), value.getCode());
                comboItems.add(comboItem);
            }
            filter.setComboItems(comboItems);
        }
    }

    public void setFilter(SetFilterEvent e) {
        Object fileIds;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        for (QFilter qFilter : qFilters) {
            String tags;
            String[] query;
            String property = qFilter.getProperty();
            if ("ysq_file_type".equals(property)) {
                Object value = qFilter.getValue();
                if (value instanceof List) {
                    ArrayList filterValue = (ArrayList)value;
                    qFilter.__setCP("in");
                    ArrayList realFilterValue = new ArrayList();
                    for (String s : filterValue) {
                        realFilterValue.addAll(FileTypeFilterEnums.getFileType((String)s));
                    }
                    qFilter.__setValue(realFilterValue);
                    continue;
                }
                qFilter.__setCP("in");
                ArrayList realFilterValue = new ArrayList();
                realFilterValue.addAll(FileTypeFilterEnums.getFileType((String)value.toString()));
                qFilter.__setValue(realFilterValue);
                continue;
            }
            if ("ysq_file_name".equals(property)) {
                qFilter.__setProperty("ysq_file_name_low");
                String name = qFilter.getValue().toString().toLowerCase();
                qFilter.__setValue((Object)name);
                continue;
            }
            if (!"1".equals(property) || (query = (tags = qFilter.getValue().toString().toLowerCase()).split("#")).length <= 1) continue;
            String[] split = query[1].replace("\uff0c", ",").split(",");
            Set fileTags = Arrays.stream(split).filter(item -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item})).collect(Collectors.toSet());
            QFilter tagFilter = null;
            for (String tag : fileTags) {
                if (tagFilter == null) {
                    tagFilter = new QFilter("ysq_file_tag", "like", (Object)("%" + tag + "%"));
                    continue;
                }
                tagFilter = tagFilter.or(new QFilter("ysq_file_tag", "like", (Object)("%" + tag + "%")));
            }
            qFilter.or(tagFilter);
        }
        Object jobNo = this.getView().getFormShowParameter().getCustomParam("ysq_job_no");
        if (jobNo != null) {
            QFilter jobNoFilter = new QFilter("ysq_job_no", "=", (Object)jobNo.toString());
            qFilters.add(jobNoFilter);
        }
        if ((fileIds = this.getView().getFormShowParameter().getCustomParam("idList")) != null) {
            QFilter jobNoFilter = new QFilter("id", "in", fileIds);
            qFilters.add(jobNoFilter);
        }
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc columnDesc;
        DynamicObject rowData = e.getRowData();
        long fileSize = rowData.getLong("ysq_file_size");
        String unit = "B";
        if (fileSize / 1024L > 0L) {
            unit = "KB";
            if ((fileSize /= 1024L) / 1024L > 0L) {
                unit = "MB";
                if ((fileSize /= 1024L) / 1024L > 0L) {
                    fileSize /= 1024L;
                    unit = "GB";
                }
            }
        }
        if (e.getSource() instanceof ColumnDesc && "ysq_file_size_show".equals((columnDesc = (ColumnDesc)e.getSource()).getKey())) {
            e.setFormatValue((Object)(fileSize + unit));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (YSQ_BTN_UPLOAD.equals(itemKey)) {
            FormShowParameter formShowParameter = KdPageUtils.toFormPage((String)"ysq_rpa_share_file_upload", (ShowType)ShowType.Modal, null);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_PERSON_LIST));
            this.getView().showForm(formShowParameter);
            return;
        }
        if (YSQ_OPE_HISTORY.equals(itemKey)) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int size = selectedRows.size();
            if (size <= 0) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u67e5\u770b\u7684\u6587\u4ef6\u3002");
                evt.setCancel(true);
            } else if (size > 1) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u5355\u4e2a\u6587\u4ef6\u3002");
                evt.setCancel(true);
            }
            return;
        }
        if (YSQ_BTN_DOWNLOAD.equals(itemKey)) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int size = selectedRows.size();
            if (size <= 0) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u3002");
                evt.setCancel(true);
            }
            return;
        }
        if (YSQ_SET_TAGS.equals(itemKey)) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            int size = selectedRows.size();
            if (size <= 0) {
                this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u8bbe\u7f6e\u6807\u7b7e\u7684\u6587\u4ef6\u3002");
                evt.setCancel(true);
            }
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals(YSQ_BTN_DOWNLOAD)) {
            super.itemClick(evt);
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows.size() == 1) {
                ListSelectedRow row = list.getSelectedRows().get(0);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)row.toString(), (String)"ysq_rpa_sfile");
                String shareFileId = dynamicObject.getString("id");
                List attachmentpanel = AttachmentServiceHelper.getAttachments((String)"ysq_rpa_sfile", (Object)shareFileId, (String)"attachmentpanel", (boolean)false);
                String path = ((Map)attachmentpanel.get(0)).get("url").toString();
                EsUtils.addFileEsIndex((Long)dynamicObject.getLong("id"), (String)dynamicObject.getString("ysq_file_name"), (String)OperateFileLog.Type.PAGE_DOWNLOUD.getType(), null, (Long)UserUtils.getCurrUserId(), (Long)dynamicObject.getLong("ysq_org_id"), null);
                this.getView().download(path);
            } else {
                FileService fs = FileServiceFactory.getAttachmentFileService();
                String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.93 Safari/537.36";
                ArrayList<Long> idList = new ArrayList<Long>();
                for (ListSelectedRow selectedRow : selectedRows) {
                    Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
                    idList.add(primaryKeyValue);
                }
                QFilter f1 = new QFilter("id", "in", idList);
                DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{f1});
                List<DynamicObject> l = Arrays.asList(dynamicObject);
                List<BatchDownloadRequest.Dir> dirs = this.createDirAndFileByAttPanel(l);
                BatchDownloadRequest bdr = new BatchDownloadRequest("alldownload");
                BatchDownloadRequest.Dir[] dir = new BatchDownloadRequest.Dir[dirs.size()];
                bdr.setDirs(dirs.toArray(dir));
                FileOutputStream out = null;
                String url = "";
                try {
                    File file = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".zip");
                    out = new FileOutputStream(file);
                    fs.batchDownload(bdr, (OutputStream)out, userAgent);
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    url = cache.saveAsUrl(file.getName(), (InputStream)new FileInputStream(file), 120);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.getView().download(url);
            }
        } else {
            if (YSQ_OPE_HISTORY.equals(evt.getItemKey())) {
                ListShowParameter formShowParameter = KdPageUtils.toListPage((String)YSQ_RPA_FILE_LOG, (ShowType)ShowType.Modal, null);
                BillList list = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                formShowParameter.setCustomParam("fileId", (Object)Long.parseLong(selectedRows.get(0).getPrimaryKeyValue().toString()));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_CALL_BACK_FILE_LOG_LIST"));
                this.getView().showForm((FormShowParameter)formShowParameter);
                return;
            }
            if (YSQ_OPE_ALL_HISTORY.equals(evt.getItemKey())) {
                ListShowParameter formShowParameter = KdPageUtils.toListPage((String)YSQ_RPA_FILE_LOG, (ShowType)ShowType.Modal, null);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOSE_CALL_BACK_FILE_LOG_LIST"));
                this.getView().showForm((FormShowParameter)formShowParameter);
                return;
            }
            if (YSQ_SET_TAGS.equals(evt.getItemKey())) {
                FormShowParameter formShowParameter = KdPageUtils.toFormPage((String)YSQ_SET_TAGS, (ShowType)ShowType.Modal, null);
                BillList list = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                ArrayList<Long> fileIds = new ArrayList<Long>();
                for (ListSelectedRow row : selectedRows) {
                    fileIds.add(Long.parseLong(row.getPrimaryKeyValue().toString()));
                }
                formShowParameter.setCustomParam("fileIds", fileIds);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALL_BACK_FILE_TAG_LIST));
                this.getView().showForm(formShowParameter);
                return;
            }
        }
    }

    private List<BatchDownloadRequest.Dir> createDirAndFileByAttPanel(List<DynamicObject> list) {
        ArrayList<BatchDownloadRequest.Dir> requestDirList = new ArrayList<BatchDownloadRequest.Dir>();
        BatchDownloadRequest.Dir testDir = new BatchDownloadRequest.Dir("");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        ArrayList<BatchDownloadRequest.File> testFile = new ArrayList<BatchDownloadRequest.File>();
        for (DynamicObject model : list) {
            Map map = (Map)AttachmentServiceHelper.getAttachments((String)"ysq_rpa_sfile", (Object)model.getLong("id"), (String)"attachmentpanel").get(0);
            String atturl = (String)map.get("url");
            if (atturl.indexOf("path=") != -1) {
                String[] urlsplit = atturl.split("path=");
                String path = urlsplit[1];
                String[] split = path.split("&");
                String name = (String)map.get("name");
                BatchDownloadRequest.File aFile = new BatchDownloadRequest.File(name, split[0]);
                testFile.add(aFile);
            }
            EsUtils.addFileEsIndex((Long)model.getLong("id"), (String)model.getString("ysq_file_name"), (String)OperateFileLog.Type.PAGE_DOWNLOUD.getType(), null, (Long)UserUtils.getCurrUserId(), (Long)model.getLong("ysq_org_id"), null);
        }
        BatchDownloadRequest.File[] testArray = new BatchDownloadRequest.File[testFile.size()];
        testDir.setFiles(testFile.toArray(testArray));
        requestDirList.add(testDir);
        return requestDirList;
    }

    private BatchDownloadRequest.Dir createDirAndFileByAttPanel1(String fileName, List<Map<String, Object>> attachmentData) {
        BatchDownloadRequest.Dir attpanelDir = new BatchDownloadRequest.Dir(fileName);
        ArrayList<BatchDownloadRequest.File> attpanelFile = new ArrayList<BatchDownloadRequest.File>();
        for (Map<String, Object> map : attachmentData) {
            String atturl = (String)map.get("url");
            if (atturl.indexOf("path=") == -1) continue;
            String[] urlsplit = atturl.split("path=");
            String path = urlsplit[1];
            String[] split = path.split("&");
            String name = (String)map.get("name");
            BatchDownloadRequest.File aFile = new BatchDownloadRequest.File(name, split[0]);
            attpanelFile.add(aFile);
        }
        BatchDownloadRequest.File[] files = attpanelFile.toArray(new BatchDownloadRequest.File[attpanelFile.size()]);
        attpanelDir.setFiles(files);
        return attpanelDir;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (CLOSE_CALL_BACK_PERSON_LIST.equals(actionId) && returnData != null) {
            this.getView().showSuccessNotification("\u4e0a\u4f20\u6210\u529f\u3002");
            this.getView().invokeOperation(REFRESH);
        } else if (CLOSE_CALL_BACK_FILE_TAG_LIST.equals(actionId) && returnData != null) {
            this.getView().showSuccessNotification("\u4fee\u6539\u6210\u529f\u3002");
            this.getView().invokeOperation(REFRESH);
        }
    }
}

