/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.file;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqShareFileConstant;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;

public class ShareFileSetTagsFormPlugin
extends AbstractFormPlugin {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String KEY_BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String YSQ_FILE_TAGS = "ysq_file_tags";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl(KEY_BTNOK);
        btnOk.addClickListener((ClickListener)this);
        Button btnClose = (Button)this.getView().getControl(BTNCANCEL);
        btnClose.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List fileIds = (List)this.getView().getFormShowParameter().getCustomParam("fileIds");
        if (fileIds.size() == 1) {
            QFilter qFilter = new QFilter("id", "in", (Object)fileIds);
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter});
            this.getModel().setValue(YSQ_FILE_TAGS, (Object)load.getString("ysq_file_tag"));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(KEY_BTNOK)) {
            DynamicObject[] load;
            Object ysqFileTags = this.getModel().getValue(YSQ_FILE_TAGS);
            String tags = "";
            if (ysqFileTags != null) {
                String tag = ysqFileTags.toString().replace("\uff0c", ",");
                if (tag.length() > 200) {
                    evt.setCancel(true);
                    this.getView().showErrorNotification(ResultStatusEnums.SHARE_FILE_TAG_LEN.getCodeMsg());
                    return;
                }
                String[] split = tag.split(",");
                Set collect = Arrays.stream(split).filter(item -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item})).collect(Collectors.toSet());
                if (collect.size() > 5) {
                    evt.setCancel(true);
                    this.getView().showErrorNotification(ResultStatusEnums.SHARE_FILE_TAG_NUM.getCodeMsg());
                    return;
                }
                tags = collect.toString().replace("[", "").replace("]", "");
            }
            List fileIds = (List)this.getView().getFormShowParameter().getCustomParam("fileIds");
            QFilter qFilter = new QFilter("id", "in", (Object)fileIds);
            for (DynamicObject file : load = BusinessDataServiceHelper.load((String)"ysq_rpa_sfile", (String)YsqShareFileConstant.selAllFileds(), (QFilter[])new QFilter[]{qFilter})) {
                file.set("ysq_file_tag", (Object)tags);
            }
            SaveServiceHelper.update((DynamicObject[])load, (OperateOption)OperateOption.create());
            this.getView().returnDataToParent((Object)true);
        }
    }
}

