/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import ysq.rpac.rpamc.common.constant.YsqShareFileConstant;
import ysq.rpac.rpamc.common.enums.ResultStatusEnums;
import ysq.rpac.rpamc.common.servicehelper.ShareFileServiceHelper;
import ysq.rpac.rpamc.common.utils.StringUtil;

public class ShareFileUploadFormPlugin
extends AbstractFormPlugin {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String KEY_BTNOK = "btnok";
    private static final String YSQ_FILE_TAGS = "ysq_file_tags";
    private static final String KEY_YSQ_ATTACHMENTPANELAP = "ysq_attachmentpanelap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl(KEY_BTNOK);
        btnOk.addClickListener((ClickListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        AttachmentPanel panel = (AttachmentPanel)this.getControl(KEY_YSQ_ATTACHMENTPANELAP);
        List attachmentDataList = panel.getAttachmentData();
        if (CollectionUtils.isEmpty((Collection)attachmentDataList)) {
            this.getView().showErrorNotification("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            evt.setCancel(true);
            return;
        }
        int size = 0;
        for (Map attachmentData : attachmentDataList) {
            String name = (String)attachmentData.get("name");
            if (StringUtil.isEmpty((CharSequence)name)) {
                evt.setCancel(true);
                this.getView().showErrorNotification("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return;
            }
            if (name.length() > 64) {
                evt.setCancel(true);
                this.getView().showErrorNotification("\u6587\u4ef6\u540d\u8fc7\u957f\u3002");
                return;
            }
            if (!this.fileNameCheck(name)) {
                evt.setCancel(true);
                this.getView().showErrorNotification("\u6587\u4ef6\u540d\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3002");
                return;
            }
            if (!this.fileTypeCheck(name)) {
                evt.setCancel(true);
                this.getView().showErrorNotification("\u6587\u4ef6\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20*.txt,*.TXT,*.zip,*.ZIP,*.jpg,*.JPG,*.doc,*.DOC,*.docx,*.DOCX,*.xls,*.XLS,*.xlsx,*.XLSX,*.ppt,*.PPT,*.pptx,*.PPTX,*.jpeg,*.JPEG,*.png,*.PNG,*.pdf,*.PDF,*.bmp,*.BMP,*.rar,*.csv\u7c7b\u578b");
                return;
            }
            size = Integer.parseInt(attachmentData.get("size").toString()) + size;
        }
        Map licenseUseMap = ShareFileServiceHelper.getFileCapacity();
        Long used = (Long)licenseUseMap.get("used");
        Long total = (Long)licenseUseMap.get("total");
        if (used + (long)size > total) {
            evt.setCancel(true);
            this.getView().showErrorNotification("\u6587\u4ef6\u7a7a\u95f4\u4e0d\u8db3\uff0c\u8bf7\u53ca\u65f6\u6e05\u7406\u3002");
            return;
        }
        Object ysqFileTags = this.getModel().getValue(YSQ_FILE_TAGS);
        String tags = "";
        if (ysqFileTags != null) {
            String tag = ysqFileTags.toString().replace("\uff0c", ",");
            if (tag.length() > 200) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResultStatusEnums.SHARE_FILE_TAG_LEN.getCodeMsg());
                return;
            }
            String[] split = tag.split(",");
            Set collect = Arrays.stream(split).filter(item -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item})).collect(Collectors.toSet());
            if (collect.size() > 5) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResultStatusEnums.SHARE_FILE_TAG_NUM.getCodeMsg());
                return;
            }
            tags = collect.toString().replace("[", "").replace("]", "");
        }
        ShareFileServiceHelper.uploadFileList((List)attachmentDataList, (String)tags);
        this.getView().returnDataToParent((Object)true);
    }

    public boolean fileNameCheck(String fileName) {
        Pattern pattern = Pattern.compile("[\\\\/:\\*\\?\\\"<>\\|]");
        Matcher matcher = pattern.matcher(fileName);
        return !matcher.find();
    }

    public boolean fileTypeCheck(String fileName) {
        String[] split = fileName.split("\\.");
        String fileType = split[split.length - 1];
        return YsqShareFileConstant.ALLOWED_FILE_TYPE.contains(fileType.toLowerCase());
    }
}

