/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.home;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class AgentFormPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(AgentFormPlugin.class);
    private static final String YSQ_LABE_AGENT_RUN = "ysq_labe_agent_run";
    private static final String YSQ_LABE_AGENT_FREE = "ysq_labe_agent_free";
    private static final String YSQ_LABE_AGENT_OFFLINE = "ysq_labe_agent_offline";
    private static final String YSQ_VECTORAP_REFRESH = "ysq_vectorap_refresh";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label agentRunLabel = (Label)this.getView().getControl(YSQ_LABE_AGENT_RUN);
        Label agentFreeLabel = (Label)this.getView().getControl(YSQ_LABE_AGENT_FREE);
        Label agentOfflineLabel = (Label)this.getView().getControl(YSQ_LABE_AGENT_OFFLINE);
        agentRunLabel.addClickListener((ClickListener)this);
        agentFreeLabel.addClickListener((ClickListener)this);
        agentOfflineLabel.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{YSQ_VECTORAP_REFRESH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_VECTORAP_REFRESH.equals(control.getKey())) {
            this.updateData();
        }
        if (YSQ_LABE_AGENT_RUN.equals(control.getKey())) {
            this.toProListPage("busy");
            return;
        }
        if (YSQ_LABE_AGENT_FREE.equals(control.getKey())) {
            this.toProListPage("free");
            return;
        }
        if (YSQ_LABE_AGENT_OFFLINE.equals(control.getKey())) {
            this.toProListPage("offline");
            return;
        }
    }

    private void updateData() {
        Label agentRunLabel = (Label)this.getView().getControl(YSQ_LABE_AGENT_RUN);
        agentRunLabel.setText(this.queryAgent("busy") + "");
        Label agentFreeLabel = (Label)this.getView().getControl(YSQ_LABE_AGENT_FREE);
        agentFreeLabel.setText(this.queryAgent("free") + "");
        Label agentOfflineLabel = (Label)this.getView().getControl(YSQ_LABE_AGENT_OFFLINE);
        agentOfflineLabel.setText(this.queryAgent("offline") + "");
    }

    private void toProListPage(String status) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("ysq_rpa_agent");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParam("dptIds", (Object)UserUtils.getDptId());
        listShowParameter.setCustomParam("dataStatus", (Object)status);
        listShowParameter.setCustomParam("agentType", new ArrayList<String>(Arrays.asList("robot", "assistant", "standardRobot")));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private int queryAgent(String status) {
        QFilter statusFilter = null;
        if (StringUtils.isNotBlank((CharSequence)status)) {
            statusFilter = new QFilter("ysq_data_status", "=", (Object)status);
        }
        QFilter dptFilter = new QFilter("org", "in", (Object)UserUtils.getDptId());
        QFilter typeFilter = new QFilter("ysq_agent_type", "!=", (Object)"studio");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{statusFilter, dptFilter, typeFilter});
        return query.size();
    }
}

