/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.home;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import ysq.rpac.rpamc.common.servicehelper.ShareFileServiceHelper;

public class FileCapacityHomeCheckPlugin
extends AbstractFormPlugin {
    public static final String YSQ_PIE_ROBOT = "ysq_pie_file";
    private static final String YSQ_REFRESH = "ysq_refresh";
    private static final String PIT_TITLE = "\u6587\u4ef6\u7a7a\u95f4\u4f7f\u7528\u60c5\u51b5";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.drawChart(YSQ_PIE_ROBOT);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{YSQ_REFRESH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_REFRESH.equals(control.getKey())) {
            this.drawChart(YSQ_PIE_ROBOT);
        }
    }

    private void drawChart(String ckey) {
        PieChart assistantPieChart = (PieChart)this.getControl(ckey);
        assistantPieChart.clearData();
        assistantPieChart.setShowTooltip(true);
        HashMap<String, String> color = new HashMap<String, String>();
        color.put("used", "#00CFFF");
        color.put("notUse", "#CCCCCC");
        Map licenseUseMap = ShareFileServiceHelper.getFileCapacity();
        Long used = (Long)licenseUseMap.get("used");
        Long total = (Long)licenseUseMap.get("total");
        if (used > total) {
            used = total;
        }
        long notUse = total - used;
        HashMap<String, ItemValue[]> resMap = new HashMap<String, ItemValue[]>();
        ItemValue[] itemValues = new ItemValue[]{new ItemValue("\u5df2\u7528(MB)", (Number)(used / 1024L / 1024L), (String)color.get("used")), new ItemValue("\u672a\u4f7f\u7528(MB)", (Number)(notUse / 1024L / 1024L), (String)color.get("notUse"))};
        resMap.put(PIT_TITLE, itemValues);
        PieSeries series = assistantPieChart.createPieSeries(PIT_TITLE);
        series.setRadius("40%", "60%");
        this.setSeriesData(series, (ItemValue[])resMap.get(PIT_TITLE));
        assistantPieChart.setShowTitle(true);
        assistantPieChart.setTitlePropValue("text", (Object)(used * 100L / total + "%"));
        assistantPieChart.setTitlePropValue("top", (Object)"center");
        assistantPieChart.setTitlePropValue("left", (Object)"center");
        this.getView().updateView(ckey);
    }

    private PieSeries setSeriesData(PieSeries series, ItemValue[] items) {
        series.setData(items);
        HashMap map02 = new HashMap();
        HashMap<String, Boolean> normalMap02 = new HashMap<String, Boolean>();
        map02.put("normal", normalMap02);
        normalMap02.put("show", Boolean.FALSE);
        series.setPropValue("labelLine", map02);
        return series;
    }

    private String formateSize(Integer size) {
        String unit = "B";
        if (size / 1024 > 0) {
            size = size / 1024;
            unit = "KB";
            if (size / 1024 > 0) {
                size = size / 1024;
                unit = "MB";
                if (size / 1024 > 0) {
                    size = size / 1024;
                    unit = "GB";
                }
            }
        }
        return size + unit;
    }
}

