/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.home;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.servicehelper.ProcessServiceHelper;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class HomeFormPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(HomeFormPlugin.class);
    private static final String YSQ_LABEL_JOB_NUM = "ysq_label_job_num";
    private static final String YSQ_LABEL_JOB_RUN = "ysq_label_job_run";
    private static final String YSQ_LABEL_JOB_SUCC = "ysq_label_job_succ";
    private static final String YSQ_LABEL_JOB_FAIL = "ysq_label_job_fail";
    private static final String YSQ_LABEL_JOB_PEND = "ysq_label_job_pend";
    private static final String YSQ_LABEL_JOB_TIME = "ysq_label_job_time";
    private static final String YSQ_LABEL_TIME_UNIT = "ysq_label_time_unit";
    private static final String YSQ_JOB_DATE = "ysq_job_date";
    private static final String YSQ_REFRESH = "ysq_refresh";
    private static final String YSQ_DATE_TYPE = "ysq_datetype";
    private static String customDate = "";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ProcessServiceHelper.checkProcExistAndStartSchedule((String)"start");
        this.setJobCount(HomeFormPlugin.getTodayDate(), null);
        this.setJobLabels(HomeFormPlugin.getTodayDate(), null);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label jobNumLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_NUM);
        Label jobRunLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_RUN);
        Label jobSuccLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_SUCC);
        Label jobFailLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_FAIL);
        Label jobPendLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_PEND);
        jobNumLabel.addClickListener((ClickListener)this);
        jobRunLabel.addClickListener((ClickListener)this);
        jobSuccLabel.addClickListener((ClickListener)this);
        jobFailLabel.addClickListener((ClickListener)this);
        jobPendLabel.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{YSQ_REFRESH});
        this.addClickListeners(new String[]{YSQ_JOB_DATE});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (YSQ_DATE_TYPE.equals(fieldKey)) {
            String dateType = this.getModel().getValue(YSQ_DATE_TYPE).toString();
            if (StringUtils.equals((CharSequence)"today", (CharSequence)dateType)) {
                Date todayDate = HomeFormPlugin.getTodayDate();
                this.setJobCount(todayDate, null);
                this.setJobLabels(todayDate, null);
            } else if (StringUtils.equals((CharSequence)"week", (CharSequence)dateType)) {
                Date weekStartDate = HomeFormPlugin.getWeekStartDate();
                this.setJobCount(weekStartDate, "week");
                this.setJobLabels(weekStartDate, "week");
            } else if (StringUtils.equals((CharSequence)"month", (CharSequence)dateType)) {
                Date monthDate = HomeFormPlugin.getMonthDate();
                this.setJobCount(monthDate, "month");
                this.setJobLabels(monthDate, "month");
            }
        }
        if (YSQ_JOB_DATE.equals(fieldKey)) {
            Date value = (Date)this.getModel().getValue(YSQ_JOB_DATE);
            if (value == null) {
                this.setJobCount(HomeFormPlugin.getTodayDate(), null);
                this.setJobLabels(HomeFormPlugin.getTodayDate(), null);
                this.getModel().setValue(YSQ_DATE_TYPE, (Object)"today");
                return;
            }
            this.setJobCount(value, "month");
            this.setJobLabels(value, "month");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_REFRESH.equals(control.getKey())) {
            this.getModel().setValue(YSQ_JOB_DATE, (Object)"");
            Date todayDate = HomeFormPlugin.getTodayDate();
            this.setJobCount(todayDate, null);
            this.setJobLabels(todayDate, null);
            this.getModel().setValue(YSQ_DATE_TYPE, (Object)"today");
        }
        if (YSQ_LABEL_JOB_NUM.equals(control.getKey())) {
            this.toJobListPage(null);
        }
        if (YSQ_LABEL_JOB_RUN.equals(control.getKey())) {
            this.toJobListPage(RpaJobStatusEnums.RUNNING.getCode());
        }
        if (YSQ_LABEL_JOB_SUCC.equals(control.getKey())) {
            this.toJobListPage(RpaJobStatusEnums.SUCCESS.getCode());
        }
        if (YSQ_LABEL_JOB_FAIL.equals(control.getKey())) {
            this.toJobListPage(RpaJobStatusEnums.FAILED.getCode());
        }
        if (YSQ_LABEL_JOB_PEND.equals(control.getKey())) {
            this.toJobListPage(RpaJobStatusEnums.PENDING.getCode());
        }
    }

    private void toJobListPage(String status) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("ysq_rpa_job");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParam("dptIds", (Object)this.getDptId());
        listShowParameter.setCustomParam("ysq_status", (Object)status);
        Object dateTypeObj = this.getModel().getValue(YSQ_DATE_TYPE);
        String dateType = dateTypeObj.toString();
        listShowParameter.setCustomParam("dateType", (Object)dateType);
        if ("custom".equals(dateType)) {
            Object value = this.getModel().getValue(YSQ_JOB_DATE);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String date = formatter.format(value);
            listShowParameter.setCustomParam("customDate", (Object)date);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void setJobCount(Date date, String dateType) {
        QFilter jobTimeFilter = new QFilter("ysq_job_time", ">=", (Object)date);
        QFilter typeFilter = new QFilter("ysq_com_job_type", "!=", (Object)"standard");
        QFilter dptFilter = new QFilter("org", "in", (Object)this.getDptId());
        QFilter dateEndFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)dateType)) {
            if ("week".equals(dateType)) {
                dateEndFilter = new QFilter("ysq_job_time", "<=", (Object)DateUtils.getWeekEnd());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String formatDate = sdf.format(date);
                int year = Integer.parseInt(formatDate.substring(0, 4));
                int month = Integer.parseInt(formatDate.substring(5, 7));
                dateEndFilter = new QFilter("ysq_job_time", "<=", (Object)HomeFormPlugin.getLastDayOfMonth(year, month));
            }
        }
        QFilter[] filters = new QFilter[]{jobTimeFilter, dptFilter, dateEndFilter, typeFilter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])filters);
        int size = query.size();
        Label numLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_NUM);
        numLabel.setText(size + "");
        this.setRunTime(query);
    }

    private void setJobLabels(Date date, String dateType) {
        Label runLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_RUN);
        Label succLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_SUCC);
        Label failLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_FAIL);
        Label pendLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_PEND);
        runLabel.setText(this.getJobCountByStatus(RpaJobStatusEnums.RUNNING.getCode(), date, dateType) + "");
        succLabel.setText(this.getJobCountByStatus(RpaJobStatusEnums.SUCCESS.getCode(), date, dateType) + "");
        failLabel.setText(this.getJobCountByStatus(RpaJobStatusEnums.FAILED.getCode(), date, dateType) + "");
        pendLabel.setText(this.getJobCountByStatus(RpaJobStatusEnums.PENDING.getCode(), date, dateType) + "");
    }

    private void setRunTime(DynamicObjectCollection collection) {
        int total = 0;
        for (DynamicObject dynamicObject : collection) {
            total += dynamicObject.getInt("ysq_run_time_sec");
        }
        Label jobTimeLabel = (Label)this.getView().getControl(YSQ_LABEL_JOB_TIME);
        Label timeUnitLabel = (Label)this.getView().getControl(YSQ_LABEL_TIME_UNIT);
        String timeUnit = "\u79d2";
        if (total > 3600) {
            total /= 3600;
            timeUnit = "\u5c0f\u65f6";
        }
        if (total > 60) {
            total /= 60;
            timeUnit = "\u5206\u949f";
        }
        jobTimeLabel.setText(total + "");
        timeUnitLabel.setText(timeUnit + "");
    }

    private String getJobCountByStatus(String status, Date date, String dateType) {
        QFilter statusFilter = new QFilter("ysq_status", "=", (Object)status);
        QFilter dateFilter = new QFilter("ysq_job_time", ">=", (Object)date);
        QFilter dptFilter = new QFilter("org", "in", (Object)this.getDptId());
        QFilter typeFilter = new QFilter("ysq_com_job_type", "!=", (Object)"standard");
        QFilter dateEndFilter = null;
        if (StringUtils.isNotEmpty((CharSequence)dateType)) {
            if ("week".equals(dateType)) {
                dateEndFilter = new QFilter("ysq_job_time", "<=", (Object)DateUtils.getWeekEnd());
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String formatDate = sdf.format(date);
                int year = Integer.parseInt(formatDate.substring(0, 4));
                int month = Integer.parseInt(formatDate.substring(5, 7));
                dateEndFilter = new QFilter("ysq_job_time", "<=", (Object)HomeFormPlugin.getLastDayOfMonth(year, month));
            }
        }
        QFilter[] filters = new QFilter[]{statusFilter, dateFilter, dptFilter, dateEndFilter, typeFilter};
        DynamicObjectCollection rs = QueryServiceHelper.query((String)"ysq_rpa_job", (String)"id", (QFilter[])filters);
        return rs.size() + "";
    }

    private Long getDptId() {
        RequestContext rc = RequestContext.get();
        Long orgId = rc.getOrgId();
        return orgId;
    }

    private static Date getTodayDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static Date getWeekStartDate() {
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7) - 1;
        int num = dayOfWeek == 1 ? 0 : (dayOfWeek == 0 ? -6 : 1 - dayOfWeek);
        calendar.add(5, num);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private static Date getMonthDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    private boolean compareDate(Date selDate) {
        Date monthDate = HomeFormPlugin.getMonthDate();
        return monthDate.after(selDate);
    }
}

