/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.home;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import ysq.rpac.rpamc.common.model.LicenseVO;
import ysq.rpac.rpamc.common.utils.LicenseUtils;

public class PermitFormPlugin
extends AbstractFormPlugin {
    public static final String YSQ_PIE_ROBOT = "ysq_pie_robot";
    public static final String YSQ_PIE_ASSISTANT = "ysq_pie_assistant";
    public static final String YSQ_PIE_STUDIO = "ysq_pie_studio";
    private static final String YSQ_REFRESH = "ysq_refresh";
    private static final String PIT_TITLE = "\u8bb8\u53ef\u4f7f\u7528\u60c5\u51b5";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.drawChart(YSQ_PIE_ROBOT);
        this.drawChart(YSQ_PIE_ASSISTANT);
        this.drawChart(YSQ_PIE_STUDIO);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{YSQ_REFRESH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_REFRESH.equals(control.getKey())) {
            this.drawChart(YSQ_PIE_ROBOT);
            this.drawChart(YSQ_PIE_ASSISTANT);
            this.drawChart(YSQ_PIE_STUDIO);
        }
    }

    private void drawChart(String ckey) {
        PieChart assistantPieChart = (PieChart)this.getControl(ckey);
        assistantPieChart.clearData();
        assistantPieChart.setShowTooltip(true);
        HashMap<String, String> color = new HashMap<String, String>();
        color.put("used", "#00CFFF");
        color.put("notUse", "#CCCCCC");
        Map<String, Integer> licenseUseMap = this.getLicenseUseStatus(ckey);
        Integer used = licenseUseMap.get("used");
        Integer total = licenseUseMap.get("total");
        if (used > total) {
            used = total;
        }
        int notUse = total - used;
        HashMap<String, ItemValue[]> resMap = new HashMap<String, ItemValue[]>();
        ItemValue[] itemValues = new ItemValue[]{new ItemValue("\u5df2\u7528\u8bb8\u53ef", (Number)used, (String)color.get("used")), new ItemValue("\u672a\u4f7f\u7528\u8bb8\u53ef", (Number)notUse, (String)color.get("notUse"))};
        resMap.put(PIT_TITLE, itemValues);
        PieSeries series = assistantPieChart.createPieSeries(PIT_TITLE);
        series.setRadius("40%", "60%");
        this.setSeriesData(series, (ItemValue[])resMap.get(PIT_TITLE));
        assistantPieChart.setShowTitle(true);
        assistantPieChart.setTitlePropValue("text", (Object)(used + "/" + total));
        assistantPieChart.setTitlePropValue("top", (Object)"center");
        assistantPieChart.setTitlePropValue("left", (Object)"center");
        this.getView().updateView(ckey);
    }

    private PieSeries setSeriesData(PieSeries series, ItemValue[] items) {
        series.setData(items);
        HashMap map02 = new HashMap();
        HashMap<String, Boolean> normalMap02 = new HashMap<String, Boolean>();
        map02.put("normal", normalMap02);
        normalMap02.put("show", Boolean.FALSE);
        series.setPropValue("labelLine", map02);
        return series;
    }

    private Map<String, Integer> getLicenseUseStatus(String agentType) {
        LicenseVO licenseVO = LicenseUtils.licenseNums();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (YSQ_PIE_ROBOT.equals(agentType)) {
            Integer robotsTotal = licenseVO.getRobots();
            if (robotsTotal == null || robotsTotal == 0) {
                map.put("used", 0);
                map.put("total", 0);
            } else {
                DynamicObjectCollection robots = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{new QFilter("ysq_agent_type", "=", (Object)"robot")});
                map.put("used", robots.size());
                map.put("total", robotsTotal);
            }
        } else if (YSQ_PIE_ASSISTANT.equals(agentType)) {
            Integer assistantTotal = licenseVO.getAssistants();
            if (assistantTotal == null || assistantTotal == 0) {
                map.put("used", 0);
                map.put("total", 0);
            } else {
                DynamicObjectCollection assistant = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{new QFilter("ysq_agent_type", "=", (Object)"assistant")});
                map.put("used", assistant.size());
                map.put("total", assistantTotal);
            }
        } else if (YSQ_PIE_STUDIO.equals(agentType)) {
            Integer studioTotal = licenseVO.getStudios();
            if (studioTotal == null || studioTotal == 0) {
                map.put("used", 0);
                map.put("total", 0);
            } else {
                DynamicObjectCollection studio = QueryServiceHelper.query((String)"ysq_rpa_agent", (String)"id", (QFilter[])new QFilter[]{new QFilter("ysq_agent_type", "=", (Object)"studio")});
                map.put("used", studio.size());
                map.put("total", studioTotal);
            }
        }
        return map;
    }
}

