/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.home;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.enums.ProcessesStatusEnums;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class ProcessFormPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(ProcessFormPlugin.class);
    private static final String YSQ_LABEL_PRO_ALL = "ysq_label_pro_all";
    private static final String YSQ_LABEL_PRO_PUB = "ysq_label_pro_pub";
    private static final String YSQ_VECTORAP_REFRESH = "ysq_vectorap_refresh";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label labelAll = (Label)this.getView().getControl(YSQ_LABEL_PRO_ALL);
        labelAll.setText(this.queryProcess(null) + "");
        Label labelPub = (Label)this.getView().getControl(YSQ_LABEL_PRO_PUB);
        labelPub.setText(this.queryProcess(ProcessesStatusEnums.RELEASE.getCode()) + "");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label jobNumLabel = (Label)this.getView().getControl(YSQ_LABEL_PRO_ALL);
        Label jobRunLabel = (Label)this.getView().getControl(YSQ_LABEL_PRO_PUB);
        jobNumLabel.addClickListener((ClickListener)this);
        jobRunLabel.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{YSQ_VECTORAP_REFRESH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_VECTORAP_REFRESH.equals(control.getKey())) {
            Label labelAll = (Label)this.getView().getControl(YSQ_LABEL_PRO_ALL);
            labelAll.setText(this.queryProcess(null) + "");
            Label labelPub = (Label)this.getView().getControl(YSQ_LABEL_PRO_PUB);
            labelPub.setText(this.queryProcess(ProcessesStatusEnums.RELEASE.getCode()) + "");
        }
        if (YSQ_LABEL_PRO_ALL.equals(control.getKey())) {
            this.toProListPage(null);
        }
        if (YSQ_LABEL_PRO_PUB.equals(control.getKey())) {
            this.toProListPage(ProcessesStatusEnums.RELEASE.getCode());
        }
    }

    private void toProListPage(String status) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("ysq_rpa_process");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParam("dptIds", (Object)UserUtils.getDptId());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private int queryProcess(String status) {
        QFilter statusFilter = null;
        if (StringUtils.isNotBlank((CharSequence)status)) {
            statusFilter = new QFilter("ysq_work_status", "=", (Object)status);
        }
        QFilter dptFilter = new QFilter("org", "in", (Object)UserUtils.getDptId());
        QFilter typeFilter = new QFilter("ysq_proc_type", "!=", (Object)"standard");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_rpa_process", (String)"id", (QFilter[])new QFilter[]{statusFilter, dptFilter, typeFilter});
        return query.size();
    }
}

