/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.home;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import ysq.rpac.rpamc.common.utils.UserUtils;

public class ScheduleFormPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(ScheduleFormPlugin.class);
    private static final String YSQ_LABEL_SCH_ALL = "ysq_label_sch_all";
    private static final String YSQ_LABEL_SCH_ENABLE = "ysq_label_sch_enable";
    private static final String YSQ_LABEL_SCH_DISABLE = "ysq_label_sch_disable";
    private static final String YSQ_VECTORAP_REFRESH = "ysq_vectorap_refresh";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label schAllLabel = (Label)this.getView().getControl(YSQ_LABEL_SCH_ALL);
        Label schEnableLabel = (Label)this.getView().getControl(YSQ_LABEL_SCH_ENABLE);
        Label schStopLabel = (Label)this.getView().getControl(YSQ_LABEL_SCH_DISABLE);
        schAllLabel.addClickListener((ClickListener)this);
        schEnableLabel.addClickListener((ClickListener)this);
        schStopLabel.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{YSQ_VECTORAP_REFRESH});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (YSQ_VECTORAP_REFRESH.equals(control.getKey())) {
            this.updateData();
        }
        if (YSQ_LABEL_SCH_ALL.equals(control.getKey())) {
            this.toProListPage(null);
            return;
        }
        if (YSQ_LABEL_SCH_ENABLE.equals(control.getKey())) {
            this.toProListPage("yes");
            return;
        }
        if (YSQ_LABEL_SCH_DISABLE.equals(control.getKey())) {
            this.toProListPage("no");
        }
    }

    private void updateData() {
        Label schAllLabel = (Label)this.getView().getControl(YSQ_LABEL_SCH_ALL);
        schAllLabel.setText(this.querySchedule(null) + "");
        Label schEnableLabel = (Label)this.getView().getControl(YSQ_LABEL_SCH_ENABLE);
        schEnableLabel.setText(this.querySchedule("yes") + "");
        Label schStopLabel = (Label)this.getView().getControl(YSQ_LABEL_SCH_DISABLE);
        schStopLabel.setText(this.querySchedule("no") + "");
    }

    private void toProListPage(String status) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("ysq_process_schedule");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParam("dptIds", (Object)UserUtils.getDptId());
        listShowParameter.setCustomParam("status", (Object)status);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private int querySchedule(String status) {
        QFilter statusFilter = null;
        if (StringUtils.isNotBlank((CharSequence)status)) {
            statusFilter = new QFilter("ysq_status", "=", (Object)status);
        }
        QFilter typeFilter = new QFilter("ysq_sch_type", "!=", (Object)"standard");
        QFilter dptFilter = new QFilter("org", "in", (Object)UserUtils.getDptId());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_process_schedule", (String)"id", (QFilter[])new QFilter[]{statusFilter, dptFilter, typeFilter});
        return query.size();
    }
}

