/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import ysq.rpac.rpamc.common.constant.YsqRpaJobConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.message.JobQueueProducer;
import ysq.rpac.rpamc.common.message.RobotPendingJobProducer;
import ysq.rpac.rpamc.common.servicehelper.ProcessServiceHelper;
import ysq.rpac.rpamc.common.utils.ScheduleUtils;

public class ProccessDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(ProccessDeleteOpPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity data : dataEntities = this.getDataEntities()) {
                    String id = data.getValue("id").toString();
                    DynamicObject dynamicObject = null;
                    try {
                        dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_process");
                    }
                    catch (Exception exception) {
                        log.debug(exception.getMessage());
                        dynamicObject = null;
                    }
                    if (null == dynamicObject) continue;
                    String proCode = dynamicObject.getString("ysq_proc_code");
                    QFilter statusFilter = new QFilter("ysq_work_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
                    QFilter procCodeFilte = new QFilter("ysq_proc_code", "=", (Object)proCode);
                    DynamicObjectCollection jobsData = QueryServiceHelper.query((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{statusFilter, procCodeFilte});
                    for (DynamicObject job : jobsData) {
                        String jobNo = job.getString("ysq_job_no");
                        boolean isExist = RobotPendingJobProducer.getInstance().checkHasJob(jobNo, null);
                        if (!isExist) continue;
                        this.addErrorMessage(data, String.format("%s\u6d41\u7a0b\u6709\u4efb\u52a1\u5df2\u52a0\u5165\u5904\u7406\u961f\u5217\uff0c\u4e0d\u80fd\u5220\u9664\u3002", proCode));
                    }
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] schs;
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> procIds = new ArrayList<String>();
        for (DynamicObject dynamicObject : dataEntities) {
            String id = dynamicObject.get("id").toString();
            DynamicObject processObj = null;
            try {
                processObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_process");
            }
            catch (Exception exception) {
                log.debug(exception.getMessage());
                processObj = null;
            }
            if (null == processObj) continue;
            String procCode = processObj.get("ysq_proc_code").toString();
            String felid = "ysq_kd_planid,ysq_kd_jobid";
            QFilter qFilter = new QFilter("ysq_proc_code", "=", (Object)procCode);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"ysq_process_schedule", (String)felid, (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject sch : query) {
                Long jobId = sch.getLong("ysq_kd_jobid");
                Long palinId = sch.getLong("ysq_kd_planid");
                ScheduleUtils.delTaskJob((String)jobId.toString(), (String)palinId.toString());
            }
            list.add(procCode);
            procIds.add(id);
        }
        QFilter procCodeFilter = new QFilter("ysq_proc_code", "in", list);
        QFilter[] filters = new QFilter[]{procCodeFilter};
        for (DynamicObject sch : schs = BusinessDataServiceHelper.load((String)"ysq_process_schedule", (String)"id", (QFilter[])filters)) {
            AttachmentServiceHelper.remove((String)"ysq_process_schedule", (Object)sch.getLong("id"));
        }
        DeleteServiceHelper.delete((String)"ysq_process_schedule", (QFilter[])filters);
        QFilter qFilter = new QFilter("ysq_proc_code", "in", list);
        QFilter[] verFilters = new QFilter[]{qFilter};
        DynamicObject[] vers = BusinessDataServiceHelper.load((String)"ysq_rpa_process_ver", (String)"id", (QFilter[])verFilters);
        for (DynamicObject ver : vers) {
            AttachmentServiceHelper.remove((String)"ysq_rpa_process_ver", (Object)ver.getLong("id"));
        }
        DeleteServiceHelper.delete((String)"ysq_rpa_process_ver", (QFilter[])verFilters);
        for (String procId : procIds) {
            AttachmentServiceHelper.remove((String)"ysq_rpa_process", (Object)Long.valueOf(procId));
        }
        for (String procCode : list) {
            QFilter statusFilter = new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.PENDING.getCode());
            QFilter procCodeFilte = new QFilter("ysq_proc_code", "=", (Object)procCode);
            DynamicObjectCollection jobsData = QueryServiceHelper.query((String)"ysq_rpa_job", (String)YsqRpaJobConstant.selAllFileds(), (QFilter[])new QFilter[]{statusFilter, procCodeFilte});
            for (DynamicObject job : jobsData) {
                Long jobId = job.getLong("id");
                String jobNo = job.getString("ysq_job_no");
                JobQueueProducer.getInstance().removeJob(jobNo);
                AttachmentServiceHelper.remove((String)"ysq_rpa_job", (Object)jobId);
            }
            DeleteServiceHelper.delete((String)"ysq_rpa_job", (QFilter[])new QFilter[]{procCodeFilter, statusFilter});
        }
        ProcessServiceHelper.checkProcExistAndStartSchedule((String)"stop");
    }
}

