/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import ysq.rpac.rpamc.common.constant.YsqProcessConstant;
import ysq.rpac.rpamc.common.constant.YsqProcessVerConstant;
import ysq.rpac.rpamc.common.constant.YsqSysConfigConstant;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.model.dto.ProcessVersionDTO;
import ysq.rpac.rpamc.common.upgrade.ProcessMigrate;

public class ProcessListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(ProcessListPlugin.class);
    public static final String KEY_MAINBAR = "toolbarap";
    private static final String BILLLISTAP = "billlistap";
    private static final String YSQ_BTN_SCH_ONE = "ysq_btn_sch_one";
    public static final String SHC_NUM = "\u8c03\u5ea6\u6570";
    public static final String YSQ_PRO_RUN_INFO = "ysq_pro_run_info";
    public static final String YSQ_CLOSEBACK_PROCESS = "ysq_closeback_process";
    private static final String YSQ_CLOSE_BACK_SCH_ONE = "ysq_close_back_sch_one";
    private static final String SCHEDULE_PAGE_ID = "ysq_process_schedule";
    private static final String BUTTON_NEW_VERSION = "ysq_baritemap1";
    private static final String ACTION_UPDATE = "update";
    private static final String ACTION_SAVE = "save";
    private static final String VERSION_PAGE_ID = "ysq_rpa_process_ver";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ProcessMigrate.migrateProcess();
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object dptIdParam = showParameter.getCustomParam("dptIds");
        Long dptId = null;
        FilterColumn orgColumn = args.getFilterColumn("org.number");
        if (dptIdParam != null) {
            dptId = Long.valueOf(dptIdParam.toString());
        }
        if (orgColumn != null && dptId != null) {
            orgColumn.setDefaultValues(new Object[]{dptId.toString()});
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter procTypeFilter = new QFilter("ysq_proc_type", "!=", (Object)"standard");
        e.addCustomQFilter(procTypeFilter);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject data : pageData) {
            long id = data.getLong("id");
            DynamicObject processDb = null;
            try {
                processDb = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ysq_rpa_process");
            }
            catch (Exception exception) {
                log.debug(exception.getMessage());
                processDb = null;
            }
            if (null != processDb) {
                QFilter filter = new QFilter("ysq_proc_code", "=", (Object)processDb.getString("ysq_proc_code"));
                DynamicObjectCollection schDataList = QueryServiceHelper.query((String)SCHEDULE_PAGE_ID, (String)"id", (QFilter[])new QFilter[]{filter});
                data.set("ysq_dispatch_time", (Object)schDataList.size());
            }
            if (null == processDb) continue;
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)processDb.getString("ysq_proc_code"));
            DynamicObject[] load = BusinessDataServiceHelper.load((String)VERSION_PAGE_ID, (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter});
            data.set("ysq_version_count", (Object)load.length);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        this.dataEncapsulation(e, rowData);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)YSQ_BTN_SCH_ONE) && !this.checkRows(evt)) {
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)YSQ_BTN_SCH_ONE)) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Long primaryKeyValue = (Long)selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject procObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"ysq_rpa_process");
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", procObject.get("ysq_proc_code"));
            QFilter versionFilter = new QFilter("ysq_proc_ver", "=", procObject.get("ysq_proc_ver"));
            DynamicObject model = BusinessDataServiceHelper.loadSingle((String)VERSION_PAGE_ID, (String)YsqProcessVerConstant.selAllFileds(), (QFilter[])new QFilter[]{codeFilter, versionFilter});
            if (procObject != null) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("ysq_rpa_sch_one");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("procId", (Object)model.getLong("id"));
                formShowParameter.setCustomParam("versionLock", (Object)false);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSE_BACK_SCH_ONE));
                this.getView().showForm(formShowParameter);
                return;
            }
        }
        if (BUTTON_NEW_VERSION.equals(itemKey)) {
            this.versionFormRouterByAction(null, ACTION_SAVE);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object primaryKeyValue;
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        Long id = 0L;
        if (currentRow != null && (primaryKeyValue = currentRow.getPrimaryKeyValue()) != null) {
            id = Long.valueOf(primaryKeyValue.toString());
        }
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"ysq_rpa_process", (String)YsqProcessConstant.selAllFileds(), (QFilter[])filters);
        if (dynamicObject == null) {
            this.getView().showTipNotification("\u5f53\u524d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u3002");
            args.setCancel(true);
            return;
        }
        String proCode = dynamicObject.getString("ysq_proc_code");
        String proVerCode = dynamicObject.getString("ysq_proc_ver");
        String proOrg = dynamicObject.getString("org");
        if ("billno".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            QFilter filter = new QFilter("ysq_proc_code", "=", (Object)proCode);
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)VERSION_PAGE_ID, (String)"id", (QFilter[])new QFilter[]{filter});
            if (ids.length == 1) {
                this.versionFormRouterByAction(proCode, ACTION_UPDATE);
            } else {
                this.versionListRouter(proCode);
            }
        }
        if ("ysq_dispatch_time".equals(args.getHyperLinkClickEvent().getFieldName())) {
            BillShowParameter showParameter;
            args.setCancel(true);
            QFilter codeFilter = new QFilter("ysq_proc_code", "=", (Object)proCode);
            DynamicObjectCollection query = QueryServiceHelper.query((String)SCHEDULE_PAGE_ID, (String)"id", (QFilter[])new QFilter[]{codeFilter});
            int schTime = query.size();
            if (schTime <= 1) {
                showParameter = new BillShowParameter();
                if (schTime == 0) {
                    showParameter.setCustomParam("routerParam", (Object)new ProcessVersionDTO(proCode, proVerCode));
                }
                if (schTime == 1) {
                    DynamicObject singleSchedule = (DynamicObject)query.get(0);
                    showParameter.setPkId(singleSchedule.get("id"));
                }
                showParameter.setFormId(SCHEDULE_PAGE_ID);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
            if (schTime > 1) {
                showParameter = new ListShowParameter();
                showParameter.setBillFormId(SCHEDULE_PAGE_ID);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("proCode", (Object)proCode);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
        if (YSQ_PRO_RUN_INFO.equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ysq_proc_code", proCode);
            map.put("ysq_proc_ver", proVerCode);
            map.put("org", proOrg);
            map.put("contactVersion", false);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ysq_rpa_process_run_info");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParams(map);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YSQ_CLOSEBACK_PROCESS));
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)YSQ_CLOSEBACK_PROCESS) && null != closedCallBackEvent.getReturnData()) {
            HashMap<String, Object> map;
            ArrayList<String> list;
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            String jobType = (String)returnData.get("jobType");
            String proCode = (String)returnData.get("proCode");
            String proVer = (String)returnData.get("proVer");
            String proOrg = (String)returnData.get("proOrg");
            if (StringUtils.equals((CharSequence)jobType, (CharSequence)"run")) {
                list = new ArrayList<String>();
                list.add(RpaJobStatusEnums.RUNNING.getCode());
                list.add(RpaJobStatusEnums.STOPPING.getCode());
                list.add(RpaJobStatusEnums.SUCCESS.getCode());
                list.add(RpaJobStatusEnums.FAILED.getCode());
                list.add(RpaJobStatusEnums.STOPPED.getCode());
                list.add(RpaJobStatusEnums.RUN_OUTTIME.getCode());
                map = new HashMap();
                map.put("org", proOrg);
                map.put("ysq_proc_code", proCode);
                map.put("ysq_proc_ver", proVer);
                map.put("jobStatus", list);
                map.put("contactVersion", false);
                this.toJobListPage(map);
            }
            if (StringUtils.equals((CharSequence)jobType, (CharSequence)"fail")) {
                list = new ArrayList();
                list.add(RpaJobStatusEnums.FAILED.getCode());
                map = new HashMap<String, Object>();
                map.put("org", proOrg);
                map.put("ysq_proc_code", proCode);
                map.put("ysq_proc_ver", proVer);
                map.put("jobStatus", list);
                map.put("contactVersion", false);
                this.toJobListPage(map);
            }
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)YSQ_CLOSE_BACK_SCH_ONE) && null != closedCallBackEvent.getReturnData()) {
            this.getView().showSuccessNotification("\u64cd\u4f5c\u6210\u529f\u3002");
        }
    }

    private void toJobListPage(Map<String, Object> map) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("ysq_rpa_job");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCustomParams(map);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void dataEncapsulation(PackageDataEvent e, DynamicObject rowData) {
        ColumnDesc columnDesc;
        if (e.getSource() instanceof ColumnDesc && YSQ_PRO_RUN_INFO.equals((columnDesc = (ColumnDesc)e.getSource()).getKey())) {
            e.setFormatValue((Object)"\u67e5\u770b");
        }
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        BillEntityType mainEntityType = e.getMainEntityType();
        List signField1 = mainEntityType.getSignField();
    }

    public void afterExportFile(ExportFileEvent e) {
        Map customHeaderMap = e.getCustomHeaderMap();
        File file = e.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                if (this.checkTitle(sheet)) {
                    int[] seets = new int[]{11, 12, 13};
                    ProcessListPlugin.deleteColumns(sheet, seets);
                    FileOutputStream out = new FileOutputStream(file);
                    wb.write((OutputStream)out);
                    wb.close();
                    out.close();
                }
            }
            catch (Throwable ex) {
                log.warn("\u5bfc\u51fa\u6d41\u7a0b\u5931\u8d25:" + ex.getMessage());
            }
        }
    }

    public static void deleteColumns(Sheet sheet, int[] columnToDeletes) {
        for (int r = 0; r <= sheet.getLastRowNum(); ++r) {
            Row row = sheet.getRow(r);
            for (int i = 0; i < columnToDeletes.length; ++i) {
                ProcessListPlugin.deleteColum(sheet, row, r, columnToDeletes[i]);
                for (int j = i; j < columnToDeletes.length; ++j) {
                    int tb = columnToDeletes[i];
                    int tc = columnToDeletes[j];
                    if (tb >= tc) continue;
                    int n = j;
                    columnToDeletes[n] = columnToDeletes[n] - 1;
                }
            }
        }
    }

    public static void deleteColum(Sheet sheet, Row row, int r, int columnToDelete) {
        for (int c = columnToDelete; c <= row.getLastCellNum(); ++c) {
            Cell cNext;
            Cell cOld = row.getCell(c);
            if (cOld != null) {
                row.removeCell(cOld);
            }
            if ((cNext = row.getCell(c + 1)) == null) continue;
            Cell cNew = row.createCell(c, cNext.getCellType());
            ProcessListPlugin.cloneCell(cNew, cNext);
            if (r != 0) continue;
            sheet.setColumnWidth(c, sheet.getColumnWidth(c + 1));
        }
    }

    private static void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        if (CellType.BOOLEAN == cNew.getCellType()) {
            cNew.setCellValue(cOld.getBooleanCellValue());
        } else if (CellType.NUMERIC == cNew.getCellType()) {
            cNew.setCellValue(cOld.getNumericCellValue());
        } else if (CellType.STRING == cNew.getCellType()) {
            cNew.setCellValue(cOld.getStringCellValue());
        } else if (CellType.ERROR == cNew.getCellType()) {
            cNew.setCellValue((double)cOld.getErrorCellValue());
        } else if (CellType.FORMULA == cNew.getCellType()) {
            cNew.setCellValue(cOld.getCellFormula());
        }
    }

    private boolean checkTitle(Sheet sheet) {
        Row row = sheet.getRow(0);
        if (row != null) {
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                Cell cell = row.getCell(i);
                String title = cell.getStringCellValue();
                if (!SHC_NUM.equals(title)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRows(BeforeItemClickEvent evt) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        int size = selectedRows.size();
        if (size > 1) {
            this.getView().showTipNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        if (size == 0) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002");
            evt.setCancel(true);
            return false;
        }
        return true;
    }

    private void versionListRouter(String procCode) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(VERSION_PAGE_ID);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("param", (Object)procCode);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void versionFormRouterByAction(String procCode, String action) {
        BillShowParameter showParameter = new BillShowParameter();
        DynamicObject model = this.findSingleVersionByProcCode(procCode);
        if (model != null) {
            showParameter.setPkId(model.get("id"));
        }
        showParameter.setFormId(VERSION_PAGE_ID);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("param", (Object)action);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject findSingleVersionByProcCode(String procCode) {
        QFilter filter = new QFilter("ysq_proc_code", "=", (Object)procCode);
        DynamicObject model = BusinessDataServiceHelper.loadSingle((String)VERSION_PAGE_ID, (String)YsqSysConfigConstant.selAllFileds(), (QFilter[])new QFilter[]{filter});
        return model;
    }
}

