/*
 * Decompiled with CFR 0.152.
 */
package ysq.rpac.rpamc.plugin.process;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import ysq.rpac.rpamc.common.enums.RpaJobStatusEnums;
import ysq.rpac.rpamc.common.utils.DateUtils;

public class ProcessRunInfoFormPlugin
extends AbstractFormPlugin {
    public static final String YSQ_LABEL_RUN_TIME = "ysq_label_run_time";
    public static final String YSQ_LABEL_FAIL_TIME = "ysq_label_fail_time";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label runTimeLabel = (Label)this.getView().getControl(YSQ_LABEL_RUN_TIME);
        runTimeLabel.addClickListener((ClickListener)this);
        Label failTimeLabel = (Label)this.getView().getControl(YSQ_LABEL_FAIL_TIME);
        failTimeLabel.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String proCode = null;
        String proVer = null;
        Boolean contactVersion = null;
        if (customParams != null) {
            proCode = customParams.get("ysq_proc_code").toString();
            proVer = customParams.get("ysq_proc_ver").toString();
            contactVersion = Boolean.parseBoolean(customParams.get("contactVersion").toString());
        }
        Label runLabel = (Label)this.getView().getControl(YSQ_LABEL_RUN_TIME);
        Label failLabel = (Label)this.getView().getControl(YSQ_LABEL_FAIL_TIME);
        runLabel.setText(this.queryProRunTimes(proCode, proVer, contactVersion) + "");
        failLabel.setText(this.queryProFailTimes(proCode, proVer, contactVersion) + "");
    }

    public void click(EventObject evt) {
        HashMap<String, String> hashMap;
        Control control = (Control)evt.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String proCode = null;
        String proVer = null;
        String proOrg = null;
        if (customParams != null) {
            proCode = customParams.get("ysq_proc_code").toString();
            proVer = customParams.get("ysq_proc_ver").toString();
            proOrg = customParams.get("org").toString();
        }
        if (YSQ_LABEL_RUN_TIME.equals(control.getKey())) {
            hashMap = new HashMap<String, String>();
            hashMap.put("jobType", "run");
            hashMap.put("proCode", proCode);
            hashMap.put("proVer", proVer);
            hashMap.put("proOrg", proOrg);
            this.getView().returnDataToParent(hashMap);
            this.getView().close();
        }
        if (YSQ_LABEL_FAIL_TIME.equals(control.getKey())) {
            hashMap = new HashMap();
            hashMap.put("jobType", "fail");
            hashMap.put("proCode", proCode);
            hashMap.put("proVer", proVer);
            hashMap.put("proOrg", proOrg);
            this.getView().returnDataToParent(hashMap);
            this.getView().close();
        }
    }

    private int queryProRunTimes(String proCode, String proVer, Boolean contactVersion) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(RpaJobStatusEnums.PENDING.getCode());
        list.add(RpaJobStatusEnums.PEND_OUTTIME.getCode());
        list.add(RpaJobStatusEnums.CANCELLED.getCode());
        QFilter runFilter = new QFilter("ysq_proc_code", "=", (Object)proCode);
        if (contactVersion.booleanValue()) {
            runFilter.and(new QFilter("ysq_proc_ver", "=", (Object)proVer));
        }
        runFilter.and(new QFilter("ysq_status", "not in", list));
        runFilter.and(new QFilter("ysq_job_time", ">=", (Object)DateUtils.getWeekStartDate()));
        DynamicObjectCollection runs = QueryServiceHelper.query((String)"ysq_rpa_job", (String)"id", (QFilter[])new QFilter[]{runFilter});
        return runs.size();
    }

    private int queryProFailTimes(String proCode, String proVer, Boolean contactVersion) {
        QFilter failFilter = new QFilter("ysq_proc_code", "=", (Object)proCode);
        if (contactVersion.booleanValue()) {
            failFilter.and(new QFilter("ysq_proc_ver", "=", (Object)proVer));
        }
        failFilter.and(new QFilter("ysq_status", "=", (Object)RpaJobStatusEnums.FAILED.getCode()));
        failFilter.and(new QFilter("ysq_job_time", ">=", (Object)DateUtils.getWeekStartDate()));
        DynamicObjectCollection faileds = QueryServiceHelper.query((String)"ysq_rpa_job", (String)"id", (QFilter[])new QFilter[]{failFilter});
        return faileds.size();
    }
}

